/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.integration.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.command.AbstractTwinCommand;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.core.push.dto.BulkGenericDto;
import org.eclipse.sensinact.core.push.dto.GenericDto;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.core.snapshot.ServiceSnapshot;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.junit5.service.ServiceExtension;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

@ExtendWith(value={ServiceExtension.class})
public class FilterTest {
    @InjectService
    DataUpdate push;
    @InjectService
    GatewayThread thread;

    @Test
    void testBasicQuery() throws Exception {
        BulkGenericDto bulk = new BulkGenericDto();
        bulk.dtos = new ArrayList();
        for (int svcIdx = 0; svcIdx < 4; ++svcIdx) {
            for (int modelIdx = 0; modelIdx < 2; ++modelIdx) {
                GenericDto dto = new GenericDto();
                dto.model = "model_" + modelIdx;
                dto.provider = "provider_" + modelIdx;
                dto.service = "service_" + svcIdx;
                dto.resource = "resource";
                dto.value = svcIdx + 1;
                dto.type = Integer.class;
                bulk.dtos.add(dto);
            }
        }
        this.push.pushUpdate((Object)bulk).getValue();
        final Predicate<ProviderSnapshot> providerFilter = p -> "model_1".equals(p.getModelName());
        final Predicate<ServiceSnapshot> svcFilter = s -> "service_1".equals(s.getName());
        final Predicate<ResourceSnapshot> rcFilter = r -> "resource".equals(r.getName());
        Collection providers = (Collection)this.thread.execute((AbstractSensinactCommand)new AbstractTwinCommand<Collection<ProviderSnapshot>>(){

            protected Promise<Collection<ProviderSnapshot>> call(SensinactDigitalTwin model, PromiseFactory pf) {
                return pf.resolved((Object)model.filteredSnapshot(null, providerFilter, svcFilter, rcFilter));
            }
        }).getValue();
        Assertions.assertEquals((int)1, (int)providers.size());
        ProviderSnapshot provider = (ProviderSnapshot)providers.iterator().next();
        Assertions.assertEquals((Object)"model_1", (Object)provider.getModelName());
        Assertions.assertEquals((Object)"provider_1", (Object)provider.getName());
        Assertions.assertEquals((int)5, (int)provider.getServices().size());
        ServiceSnapshot service = provider.getServices().stream().filter(s -> "service_1".equals(s.getName())).findFirst().get();
        Assertions.assertEquals((int)1, (int)service.getResources().size());
        ResourceSnapshot resource = (ResourceSnapshot)service.getResources().get(0);
        Assertions.assertEquals((Object)"resource", (Object)resource.getName());
        Assertions.assertEquals((Object)2, (Object)resource.getValue().getValue());
        Assertions.assertNotNull((Object)resource.getValue().getTimestamp());
    }
}

