/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.model.impl;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sensinact.core.emf.model.EMFModel;
import org.eclipse.sensinact.core.emf.util.EMFTestUtil;
import org.eclipse.sensinact.core.model.Model;
import org.eclipse.sensinact.core.model.ModelBuilder;
import org.eclipse.sensinact.core.model.Resource;
import org.eclipse.sensinact.core.model.ResourceType;
import org.eclipse.sensinact.core.model.Service;
import org.eclipse.sensinact.core.model.ServiceBuilder;
import org.eclipse.sensinact.core.model.impl.SensinactModelManagerImpl;
import org.eclipse.sensinact.core.model.nexus.ModelNexus;
import org.eclipse.sensinact.core.notification.NotificationAccumulator;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.core.snapshot.ServiceSnapshot;
import org.eclipse.sensinact.core.twin.impl.SensinactDigitalTwinImpl;
import org.eclipse.sensinact.model.core.provider.ProviderPackage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.osgi.util.promise.PromiseFactory;

@ExtendWith(value={MockitoExtension.class})
public class ModelBuildingTest {
    @Mock
    NotificationAccumulator accumulator;
    private ResourceSet resourceSet;
    private ModelNexus nexus;
    private SensinactModelManagerImpl manager;

    @BeforeEach
    void start() {
        this.resourceSet = EMFTestUtil.createResourceSet();
        this.nexus = new ModelNexus(this.resourceSet, ProviderPackage.eINSTANCE, () -> this.accumulator);
        this.manager = new SensinactModelManagerImpl(this.nexus);
    }

    @Nested
    public class ModelTest {
        private static final String TEST_MODEL = "testmodel";
        private static final String TEST_SERVICE = "testservice";
        private static final String TEST_RESOURCE = "testValue";

        @Test
        void testEmptyModel() {
            EMFModel model = ModelBuildingTest.this.manager.createModel(TEST_MODEL).build();
            Assertions.assertEquals((Object)TEST_MODEL, (Object)model.getName());
            Assertions.assertEquals((int)1, (int)model.getServices().size());
            Assertions.assertTrue((boolean)model.getServices().containsKey("admin"));
            Service admin = (Service)model.getServices().get("admin");
            Assertions.assertEquals((Object)"admin", (Object)admin.getName());
            Assertions.assertFalse((boolean)admin.getResources().isEmpty());
        }

        @Test
        void basicResource() {
            Model model = ((ModelBuilder)((ServiceBuilder)ModelBuildingTest.this.manager.createModel(TEST_MODEL).withService(TEST_SERVICE).withResource(TEST_RESOURCE).withType(Integer.class).build()).build()).build();
            Assertions.assertTrue((boolean)model.getServices().containsKey(TEST_SERVICE));
            Service service = (Service)model.getServices().get(TEST_SERVICE);
            Assertions.assertEquals((Object)TEST_SERVICE, (Object)service.getName());
            Assertions.assertTrue((boolean)service.getResources().containsKey(TEST_RESOURCE));
            Resource resource = (Resource)service.getResources().get(TEST_RESOURCE);
            Assertions.assertEquals((Object)TEST_RESOURCE, (Object)resource.getName());
            Assertions.assertEquals(Integer.class, (Object)resource.getType());
            Assertions.assertEquals((Object)ResourceType.SENSOR, (Object)resource.getResourceType());
        }

        @Test
        void testResourcePresenceOnNewInstance() {
            ((ModelBuilder)((ServiceBuilder)ModelBuildingTest.this.manager.createModel(TEST_MODEL).withService(TEST_SERVICE).withResource(TEST_RESOURCE).withType(Integer.class).build()).build()).build();
            String providerName = "foobar";
            ModelBuildingTest.this.nexus.createProviderInstance(TEST_MODEL, "foobar");
            List filteredSnapshot = new SensinactDigitalTwinImpl(ModelBuildingTest.this.nexus, new PromiseFactory(PromiseFactory.inlineExecutor())).filteredSnapshot(null, null, null, null);
            ProviderSnapshot provider = filteredSnapshot.stream().filter(p -> p.getName().equals("foobar")).findFirst().get();
            ServiceSnapshot svc = provider.getServices().stream().filter(s -> TEST_SERVICE.equals(s.getName())).findFirst().get();
            Assertions.assertNotNull((Object)svc);
            ResourceSnapshot rc = svc.getResources().stream().filter(r -> TEST_RESOURCE.equals(r.getName())).findFirst().get();
            Assertions.assertNotNull((Object)rc);
            Assertions.assertNull((Object)rc.getValue());
        }

        @Test
        void actionResource() {
            List<AbstractMap.SimpleEntry<String, Class<Long>>> parameters = List.of(new AbstractMap.SimpleEntry<String, Class<Double>>("foo", Double.class), new AbstractMap.SimpleEntry<String, Class<Long>>("bar", Long.class));
            Model model = ((ModelBuilder)((ServiceBuilder)ModelBuildingTest.this.manager.createModel(TEST_MODEL).withService(TEST_SERVICE).withResource(TEST_RESOURCE).withType(Integer.class).withAction(parameters).build()).build()).build();
            Assertions.assertTrue((boolean)model.getServices().containsKey(TEST_SERVICE));
            Service service = (Service)model.getServices().get(TEST_SERVICE);
            Assertions.assertEquals((Object)TEST_SERVICE, (Object)service.getName());
            Assertions.assertTrue((boolean)service.getResources().containsKey(TEST_RESOURCE));
            Resource resource = (Resource)service.getResources().get(TEST_RESOURCE);
            Assertions.assertEquals((Object)TEST_RESOURCE, (Object)resource.getName());
            Assertions.assertEquals(Integer.class, (Object)resource.getType());
            Assertions.assertEquals((Object)ResourceType.ACTION, (Object)resource.getResourceType());
            Assertions.assertEquals(parameters, (Object)resource.getArguments());
        }

        @Test
        void testDeleteModel() {
            EMFModel model = ModelBuildingTest.this.manager.createModel(TEST_MODEL).build();
            String packageUri = model.getPackageUri();
            String name = model.getName();
            Assertions.assertTrue((boolean)ModelBuildingTest.this.nexus.getModel(packageUri, name).isPresent());
            ModelBuildingTest.this.manager.deleteModel(packageUri, name);
            Assertions.assertFalse((boolean)ModelBuildingTest.this.nexus.getModel(packageUri, name).isPresent());
            Assertions.assertThrows(IllegalStateException.class, () -> ModelTest.lambda$testDeleteModel$3((Model)model));
        }

        @Test
        void resourceWithDefaultMetadata() {
            Model model = ((ModelBuilder)((ServiceBuilder)ModelBuildingTest.this.manager.createModel(TEST_MODEL).withService(TEST_SERVICE).withResource(TEST_RESOURCE).withType(Integer.class).withDefaultMetadata(Map.of("foo", "bar", "foobar", 42)).build()).build()).build();
            Resource resource = (Resource)((Service)model.getServices().get(TEST_SERVICE)).getResources().get(TEST_RESOURCE);
            Assertions.assertEquals((Object)TEST_RESOURCE, (Object)resource.getName());
            Assertions.assertEquals(Integer.class, (Object)resource.getType());
            Assertions.assertEquals((Object)ResourceType.SENSOR, (Object)resource.getResourceType());
            Map metadata = resource.getDefaultMetadata();
            Assertions.assertNotNull((Object)metadata);
            Assertions.assertEquals((Object)"bar", metadata.get("foo"));
            Assertions.assertEquals((Object)42, metadata.get("foobar"));
        }

        @Test
        void actionWithDefaultMetadata() {
            List<AbstractMap.SimpleEntry<String, Class<Long>>> parameters = List.of(new AbstractMap.SimpleEntry<String, Class<Double>>("foo", Double.class), new AbstractMap.SimpleEntry<String, Class<Long>>("bar", Long.class));
            Model model = ((ModelBuilder)((ServiceBuilder)ModelBuildingTest.this.manager.createModel(TEST_MODEL).withService(TEST_SERVICE).withResource(TEST_RESOURCE).withType(Integer.class).withAction(parameters).withDefaultMetadata(Map.of("foo", "bar", "foobar", 42)).build()).build()).build();
            Resource resource = (Resource)((Service)model.getServices().get(TEST_SERVICE)).getResources().get(TEST_RESOURCE);
            Assertions.assertEquals((Object)TEST_RESOURCE, (Object)resource.getName());
            Assertions.assertEquals(Integer.class, (Object)resource.getType());
            Assertions.assertEquals((Object)ResourceType.ACTION, (Object)resource.getResourceType());
            Assertions.assertEquals(parameters, (Object)resource.getArguments());
            Map metadata = resource.getDefaultMetadata();
            Assertions.assertNotNull((Object)metadata);
            Assertions.assertEquals((Object)"bar", metadata.get("foo"));
            Assertions.assertEquals((Object)42, metadata.get("foobar"));
        }

        private static /* synthetic */ void lambda$testDeleteModel$3(Model model) throws Throwable {
            model.getPackageUri();
        }
    }
}

