/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.notification.impl;

import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import org.eclipse.sensinact.core.model.nexus.emf.EMFUtil;
import org.eclipse.sensinact.core.notification.LifecycleNotification;
import org.eclipse.sensinact.core.notification.NotificationAccumulator;
import org.eclipse.sensinact.core.notification.ResourceActionNotification;
import org.eclipse.sensinact.core.notification.ResourceDataNotification;
import org.eclipse.sensinact.core.notification.ResourceMetaDataNotification;
import org.eclipse.sensinact.core.notification.impl.NotificationAccumulatorImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.opentest4j.AssertionFailedError;
import org.osgi.service.typedevent.TypedEventBus;

@ExtendWith(value={MockitoExtension.class})
class NotificationSenderTest {
    private static final String MODEL = "model";
    private static final String PROVIDER = "provider";
    private static final String PROVIDER_2 = "provider2";
    private static final String SERVICE = "service";
    private static final String SERVICE_2 = "service2";
    private static final String RESOURCE = "resource";
    private static final String RESOURCE_2 = "resource2";
    private final String MODEL_PKG = EMFUtil.constructPackageUri((String)"model");
    @Mock
    TypedEventBus bus;
    NotificationAccumulator accumulator;
    private static final String METADATA_KEY = "foo";
    private static final String METADATA_KEY_2 = "bar";
    private static final String METADATA_VALUE = "fizz";
    private static final Integer METADATA_VALUE_2 = 42;
    private static final Integer INTEGER_VALUE = 5;
    private static final Integer INTEGER_VALUE_2 = 14;

    NotificationSenderTest() {
    }

    @BeforeEach
    void start() {
        this.accumulator = new NotificationAccumulatorImpl(this.bus);
    }

    ArgumentMatcher<LifecycleNotification> isLifecycleNotificationWith(LifecycleNotification.Status status, String provider) {
        return this.isLifecycleNotificationWith(status, provider, null);
    }

    ArgumentMatcher<LifecycleNotification> isLifecycleNotificationWith(LifecycleNotification.Status status, String provider, String service) {
        return this.isLifecycleNotificationWith(status, provider, service, null);
    }

    ArgumentMatcher<LifecycleNotification> isLifecycleNotificationWith(LifecycleNotification.Status status, String provider, String service, String resource) {
        return i -> {
            try {
                Assertions.assertEquals((Object)MODEL, (Object)i.model);
                Assertions.assertEquals((Object)status, (Object)i.status);
                Assertions.assertEquals((Object)provider, (Object)i.provider);
                Assertions.assertEquals((Object)service, (Object)i.service);
                Assertions.assertEquals((Object)resource, (Object)i.resource);
            }
            catch (AssertionFailedError e) {
                return false;
            }
            return true;
        };
    }

    ArgumentMatcher<ResourceMetaDataNotification> isMetadataNotificationWith(String provider, String service, String resource, Map<String, Object> oldValues, Map<String, Object> newValues, Instant timestamp) {
        return i -> {
            try {
                Assertions.assertEquals((Object)MODEL, (Object)i.model);
                Assertions.assertEquals((Object)provider, (Object)i.provider);
                Assertions.assertEquals((Object)service, (Object)i.service);
                Assertions.assertEquals((Object)resource, (Object)i.resource);
                Assertions.assertEquals((Object)oldValues, (Object)i.oldValues);
                Assertions.assertEquals((Object)newValues, (Object)i.newValues);
                Assertions.assertEquals((Object)timestamp, (Object)i.timestamp);
            }
            catch (AssertionFailedError e) {
                return false;
            }
            return true;
        };
    }

    ArgumentMatcher<ResourceDataNotification> isValueNotificationWith(String provider, String service, String resource, Class<?> type, Object oldValue, Object newValue, Instant timestamp) {
        return i -> {
            try {
                Assertions.assertEquals((Object)MODEL, (Object)i.model);
                Assertions.assertEquals((Object)provider, (Object)i.provider);
                Assertions.assertEquals((Object)service, (Object)i.service);
                Assertions.assertEquals((Object)resource, (Object)i.resource);
                Assertions.assertEquals((Object)type, (Object)i.type);
                Assertions.assertEquals((Object)oldValue, (Object)i.oldValue);
                Assertions.assertEquals((Object)newValue, (Object)i.newValue);
                Assertions.assertEquals((Object)timestamp, (Object)i.timestamp);
            }
            catch (AssertionFailedError e) {
                return false;
            }
            return true;
        };
    }

    ArgumentMatcher<ResourceActionNotification> isActionNotificationWith(String provider, String service, String resource, Instant timestamp) {
        return i -> {
            try {
                Assertions.assertEquals((Object)MODEL, (Object)i.model);
                Assertions.assertEquals((Object)provider, (Object)i.provider);
                Assertions.assertEquals((Object)service, (Object)i.service);
                Assertions.assertEquals((Object)resource, (Object)i.resource);
                Assertions.assertEquals((Object)timestamp, (Object)i.timestamp);
            }
            catch (AssertionFailedError e) {
                return false;
            }
            return true;
        };
    }

    @Nested
    class NotificationOrderingTests {
        NotificationOrderingTests() {
        }

        @Test
        void testNotificationOrdering() {
            Instant now = Instant.now();
            NotificationSenderTest.this.accumulator.resourceAction(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE_2, now.minusSeconds(10L));
            NotificationSenderTest.this.accumulator.resourceAction(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, now);
            NotificationSenderTest.this.accumulator.resourceValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE_2, Integer.class, null, (Object)INTEGER_VALUE, now);
            NotificationSenderTest.this.accumulator.resourceValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Integer.class, null, (Object)INTEGER_VALUE_2, now);
            NotificationSenderTest.this.accumulator.metadataValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE_2, null, Collections.singletonMap(NotificationSenderTest.METADATA_KEY_2, METADATA_VALUE_2), now);
            NotificationSenderTest.this.accumulator.metadataValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, null, Collections.singletonMap(NotificationSenderTest.METADATA_KEY, NotificationSenderTest.METADATA_VALUE), now);
            NotificationSenderTest.this.accumulator.addResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER_2, NotificationSenderTest.SERVICE_2, NotificationSenderTest.RESOURCE_2);
            NotificationSenderTest.this.accumulator.addResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER_2, NotificationSenderTest.SERVICE_2, NotificationSenderTest.RESOURCE);
            NotificationSenderTest.this.accumulator.addResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER_2, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE_2);
            NotificationSenderTest.this.accumulator.addResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER_2, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE);
            NotificationSenderTest.this.accumulator.addResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE_2, NotificationSenderTest.RESOURCE_2);
            NotificationSenderTest.this.accumulator.addResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE_2, NotificationSenderTest.RESOURCE);
            NotificationSenderTest.this.accumulator.addResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE_2);
            NotificationSenderTest.this.accumulator.addResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE);
            NotificationSenderTest.this.accumulator.addService(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER_2, NotificationSenderTest.SERVICE_2);
            NotificationSenderTest.this.accumulator.addService(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER_2, NotificationSenderTest.SERVICE);
            NotificationSenderTest.this.accumulator.addService(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE_2);
            NotificationSenderTest.this.accumulator.addService(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE);
            NotificationSenderTest.this.accumulator.addProvider(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER_2);
            NotificationSenderTest.this.accumulator.addProvider(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER);
            NotificationSenderTest.this.accumulator.completeAndSend();
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{NotificationSenderTest.this.bus});
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.PROVIDER_CREATED, NotificationSenderTest.PROVIDER)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.SERVICE_CREATED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.RESOURCE_CREATED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service/resource2"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.RESOURCE_CREATED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE_2)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service2"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.SERVICE_CREATED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE_2)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service2/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.RESOURCE_CREATED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE_2, NotificationSenderTest.RESOURCE)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service2/resource2"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.RESOURCE_CREATED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE_2, NotificationSenderTest.RESOURCE_2)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider2"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.PROVIDER_CREATED, NotificationSenderTest.PROVIDER_2)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider2/service"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.SERVICE_CREATED, NotificationSenderTest.PROVIDER_2, NotificationSenderTest.SERVICE)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider2/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.RESOURCE_CREATED, NotificationSenderTest.PROVIDER_2, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider2/service/resource2"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.RESOURCE_CREATED, NotificationSenderTest.PROVIDER_2, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE_2)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider2/service2"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.SERVICE_CREATED, NotificationSenderTest.PROVIDER_2, NotificationSenderTest.SERVICE_2)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider2/service2/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.RESOURCE_CREATED, NotificationSenderTest.PROVIDER_2, NotificationSenderTest.SERVICE_2, NotificationSenderTest.RESOURCE)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider2/service2/resource2"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.RESOURCE_CREATED, NotificationSenderTest.PROVIDER_2, NotificationSenderTest.SERVICE_2, NotificationSenderTest.RESOURCE_2)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"METADATA/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isMetadataNotificationWith(NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Collections.emptyMap(), Collections.singletonMap(NotificationSenderTest.METADATA_KEY, NotificationSenderTest.METADATA_VALUE), now)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"METADATA/model/provider/service/resource2"), ArgumentMatchers.argThat(NotificationSenderTest.this.isMetadataNotificationWith(NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE_2, Collections.emptyMap(), Collections.singletonMap(NotificationSenderTest.METADATA_KEY_2, METADATA_VALUE_2), now)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"DATA/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isValueNotificationWith(NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Integer.class, null, INTEGER_VALUE_2, now)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"DATA/model/provider/service/resource2"), ArgumentMatchers.argThat(NotificationSenderTest.this.isValueNotificationWith(NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE_2, Integer.class, null, INTEGER_VALUE, now)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"ACTION/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isActionNotificationWith(NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, now)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"ACTION/model/provider/service/resource2"), ArgumentMatchers.argThat(NotificationSenderTest.this.isActionNotificationWith(NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE_2, now.minusSeconds(10L))));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }
    }

    @Nested
    class ResourceActionTests {
        ResourceActionTests() {
        }

        @Test
        void testAction() {
            Instant now = Instant.now();
            NotificationSenderTest.this.accumulator.resourceAction(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, now);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"ACTION/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isActionNotificationWith(NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, now)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testMultiAction() {
            Instant now = Instant.now();
            NotificationSenderTest.this.accumulator.resourceAction(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, now);
            NotificationSenderTest.this.accumulator.resourceAction(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, now);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus, (VerificationMode)Mockito.times((int)2))).deliver((String)ArgumentMatchers.eq((Object)"ACTION/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isActionNotificationWith(NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, now)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testMultiActionDifferentTimes() {
            Instant now = Instant.now();
            NotificationSenderTest.this.accumulator.resourceAction(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, now.minusSeconds(10L));
            NotificationSenderTest.this.accumulator.resourceAction(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, now);
            NotificationSenderTest.this.accumulator.completeAndSend();
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{NotificationSenderTest.this.bus});
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"ACTION/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isActionNotificationWith(NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, now.minusSeconds(10L))));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"ACTION/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isActionNotificationWith(NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, now)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testMultiActionDifferentTimesReverseOrder() {
            Instant now = Instant.now();
            NotificationSenderTest.this.accumulator.resourceAction(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, now);
            NotificationSenderTest.this.accumulator.resourceAction(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, now.minusSeconds(10L));
            NotificationSenderTest.this.accumulator.completeAndSend();
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{NotificationSenderTest.this.bus});
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"ACTION/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isActionNotificationWith(NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, now.minusSeconds(10L))));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"ACTION/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isActionNotificationWith(NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, now)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }
    }

    @Nested
    class ResourceValueTests {
        ResourceValueTests() {
        }

        @Test
        void testUpdateNull() {
            Instant now = Instant.now();
            NotificationSenderTest.this.accumulator.resourceValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, String.class, null, null, now);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"DATA/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isValueNotificationWith(NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, String.class, null, null, now)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testUpdateValue() {
            Instant now = Instant.now();
            NotificationSenderTest.this.accumulator.resourceValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Integer.class, null, (Object)INTEGER_VALUE, now);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"DATA/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isValueNotificationWith(NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Integer.class, null, INTEGER_VALUE, now)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testMultipleUpdate() {
            Instant now = Instant.now();
            NotificationSenderTest.this.accumulator.resourceValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Integer.class, null, (Object)INTEGER_VALUE, now);
            NotificationSenderTest.this.accumulator.resourceValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Integer.class, (Object)INTEGER_VALUE, (Object)INTEGER_VALUE_2, now);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"DATA/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isValueNotificationWith(NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Integer.class, null, INTEGER_VALUE_2, now)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testAddMetadataAcrossMultipleCallsWithTimeChange() {
            Instant now = Instant.now();
            NotificationSenderTest.this.accumulator.resourceValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Integer.class, null, (Object)INTEGER_VALUE, now.minusSeconds(10L));
            NotificationSenderTest.this.accumulator.resourceValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Integer.class, (Object)INTEGER_VALUE, (Object)INTEGER_VALUE_2, now);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"DATA/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isValueNotificationWith(NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Integer.class, null, INTEGER_VALUE_2, now)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testAddMetadataAcrossMultipleCallsReverseTime() {
            Instant now = Instant.now();
            NotificationSenderTest.this.accumulator.resourceValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Integer.class, null, (Object)INTEGER_VALUE, now);
            Exception thrown = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> NotificationSenderTest.this.accumulator.resourceValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Integer.class, (Object)INTEGER_VALUE, (Object)INTEGER_VALUE_2, now.minusSeconds(10L)));
            Assertions.assertTrue((boolean)thrown.getMessage().contains("out of temporal order"), (String)("Wrong message: " + thrown.getMessage()));
        }
    }

    @Nested
    class MetadataTests {
        MetadataTests() {
        }

        @Test
        void testAddNullMetadata() {
            Instant now = Instant.now();
            NotificationSenderTest.this.accumulator.metadataValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, null, null, now);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"METADATA/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isMetadataNotificationWith(NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Collections.emptyMap(), Collections.emptyMap(), now)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testAddNewMetadata() {
            Instant now = Instant.now();
            NotificationSenderTest.this.accumulator.metadataValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, null, Collections.singletonMap(NotificationSenderTest.METADATA_KEY, NotificationSenderTest.METADATA_VALUE), now);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"METADATA/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isMetadataNotificationWith(NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Collections.emptyMap(), Collections.singletonMap(NotificationSenderTest.METADATA_KEY, NotificationSenderTest.METADATA_VALUE), now)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testRemoveMetadata() {
            Instant now = Instant.now();
            NotificationSenderTest.this.accumulator.metadataValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Collections.singletonMap(NotificationSenderTest.METADATA_KEY, NotificationSenderTest.METADATA_VALUE), null, now);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"METADATA/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isMetadataNotificationWith(NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Collections.singletonMap(NotificationSenderTest.METADATA_KEY, NotificationSenderTest.METADATA_VALUE), Collections.emptyMap(), now)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testAddMetadataAcrossMultipleCalls() {
            Instant now = Instant.now();
            NotificationSenderTest.this.accumulator.metadataValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, null, Collections.singletonMap(NotificationSenderTest.METADATA_KEY, NotificationSenderTest.METADATA_VALUE), now);
            NotificationSenderTest.this.accumulator.metadataValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Collections.singletonMap(NotificationSenderTest.METADATA_KEY, NotificationSenderTest.METADATA_VALUE), Map.of(NotificationSenderTest.METADATA_KEY, NotificationSenderTest.METADATA_VALUE, NotificationSenderTest.METADATA_KEY_2, METADATA_VALUE_2), now);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"METADATA/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isMetadataNotificationWith(NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Collections.emptyMap(), Map.of(NotificationSenderTest.METADATA_KEY, NotificationSenderTest.METADATA_VALUE, NotificationSenderTest.METADATA_KEY_2, METADATA_VALUE_2), now)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testAddMetadataAcrossMultipleCallsWithTimeChange() {
            Instant now = Instant.now();
            NotificationSenderTest.this.accumulator.metadataValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, null, Collections.singletonMap(NotificationSenderTest.METADATA_KEY, NotificationSenderTest.METADATA_VALUE), now.minusSeconds(10L));
            NotificationSenderTest.this.accumulator.metadataValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Collections.singletonMap(NotificationSenderTest.METADATA_KEY, NotificationSenderTest.METADATA_VALUE), Map.of(NotificationSenderTest.METADATA_KEY, NotificationSenderTest.METADATA_VALUE, NotificationSenderTest.METADATA_KEY_2, METADATA_VALUE_2), now);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"METADATA/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isMetadataNotificationWith(NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Collections.emptyMap(), Map.of(NotificationSenderTest.METADATA_KEY, NotificationSenderTest.METADATA_VALUE, NotificationSenderTest.METADATA_KEY_2, METADATA_VALUE_2), now)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testAddMetadataAcrossMultipleCallsReverseTime() {
            Instant now = Instant.now();
            NotificationSenderTest.this.accumulator.metadataValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, null, Collections.singletonMap(NotificationSenderTest.METADATA_KEY, NotificationSenderTest.METADATA_VALUE), now);
            Exception thrown = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> NotificationSenderTest.this.accumulator.metadataValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Collections.singletonMap(NotificationSenderTest.METADATA_KEY, NotificationSenderTest.METADATA_VALUE), Map.of(NotificationSenderTest.METADATA_KEY_2, METADATA_VALUE_2), now.minusSeconds(10L)));
            Assertions.assertTrue((boolean)thrown.getMessage().contains("out of temporal order"), (String)("Wrong message: " + thrown.getMessage()));
        }

        @Test
        void testAddRemoveMetadataAcrossMultipleCalls() {
            Instant now = Instant.now();
            NotificationSenderTest.this.accumulator.metadataValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, null, Collections.singletonMap(NotificationSenderTest.METADATA_KEY, NotificationSenderTest.METADATA_VALUE), now.minusSeconds(10L));
            NotificationSenderTest.this.accumulator.metadataValueUpdate(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Collections.singletonMap(NotificationSenderTest.METADATA_KEY, NotificationSenderTest.METADATA_VALUE), Collections.singletonMap(NotificationSenderTest.METADATA_KEY_2, METADATA_VALUE_2), now);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"METADATA/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isMetadataNotificationWith(NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE, Collections.emptyMap(), Map.of(NotificationSenderTest.METADATA_KEY_2, METADATA_VALUE_2), now)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }
    }

    @Nested
    class ResourceLifecycleTests {
        ResourceLifecycleTests() {
        }

        @Test
        void testAddResource() {
            NotificationSenderTest.this.accumulator.addResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.RESOURCE_CREATED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testRemoveResource() {
            NotificationSenderTest.this.accumulator.removeResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.RESOURCE_DELETED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testAddRemoveResource() {
            NotificationSenderTest.this.accumulator.addResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE);
            NotificationSenderTest.this.accumulator.removeResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE);
            NotificationSenderTest.this.accumulator.completeAndSend();
            Mockito.verifyNoInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testRemoveAddResource() {
            NotificationSenderTest.this.accumulator.removeResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE);
            NotificationSenderTest.this.accumulator.addResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE);
            NotificationSenderTest.this.accumulator.completeAndSend();
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{NotificationSenderTest.this.bus});
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.RESOURCE_DELETED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.RESOURCE_CREATED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testAddAddResource() {
            NotificationSenderTest.this.accumulator.addResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE);
            NotificationSenderTest.this.accumulator.addResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.RESOURCE_CREATED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testRemoveRemoveResource() {
            NotificationSenderTest.this.accumulator.removeResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE);
            NotificationSenderTest.this.accumulator.removeResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.RESOURCE_DELETED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testRemoveAddRemoveResource() {
            NotificationSenderTest.this.accumulator.removeResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE);
            NotificationSenderTest.this.accumulator.addResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE);
            NotificationSenderTest.this.accumulator.removeResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.RESOURCE_DELETED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testAddServices() {
            NotificationSenderTest.this.accumulator.addResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE);
            NotificationSenderTest.this.accumulator.addResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE_2);
            NotificationSenderTest.this.accumulator.addResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE_2, NotificationSenderTest.RESOURCE);
            NotificationSenderTest.this.accumulator.addResource(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER_2, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE);
            NotificationSenderTest.this.accumulator.completeAndSend();
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{NotificationSenderTest.this.bus});
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.RESOURCE_CREATED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service/resource2"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.RESOURCE_CREATED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE_2)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service2/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.RESOURCE_CREATED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE_2, NotificationSenderTest.RESOURCE)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider2/service/resource"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.RESOURCE_CREATED, NotificationSenderTest.PROVIDER_2, NotificationSenderTest.SERVICE, NotificationSenderTest.RESOURCE)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }
    }

    @Nested
    class ServiceLifecycleTests {
        ServiceLifecycleTests() {
        }

        @Test
        void testAddService() {
            NotificationSenderTest.this.accumulator.addService(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.SERVICE_CREATED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testRemoveService() {
            NotificationSenderTest.this.accumulator.removeService(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.SERVICE_DELETED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testAddRemoveService() {
            NotificationSenderTest.this.accumulator.addService(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE);
            NotificationSenderTest.this.accumulator.removeService(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE);
            NotificationSenderTest.this.accumulator.completeAndSend();
            Mockito.verifyNoInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testRemoveAddService() {
            NotificationSenderTest.this.accumulator.removeService(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE);
            NotificationSenderTest.this.accumulator.addService(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE);
            NotificationSenderTest.this.accumulator.completeAndSend();
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{NotificationSenderTest.this.bus});
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.SERVICE_DELETED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.SERVICE_CREATED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testAddAddService() {
            NotificationSenderTest.this.accumulator.addService(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE);
            NotificationSenderTest.this.accumulator.addService(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.SERVICE_CREATED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testRemoveRemoveService() {
            NotificationSenderTest.this.accumulator.removeService(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE);
            NotificationSenderTest.this.accumulator.removeService(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.SERVICE_DELETED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testRemoveAddRemoveService() {
            NotificationSenderTest.this.accumulator.removeService(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE);
            NotificationSenderTest.this.accumulator.addService(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE);
            NotificationSenderTest.this.accumulator.removeService(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.SERVICE_DELETED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testAddServices() {
            NotificationSenderTest.this.accumulator.addService(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE);
            NotificationSenderTest.this.accumulator.addService(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE_2);
            NotificationSenderTest.this.accumulator.addService(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER_2, NotificationSenderTest.SERVICE);
            NotificationSenderTest.this.accumulator.completeAndSend();
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{NotificationSenderTest.this.bus});
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.SERVICE_CREATED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider/service2"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.SERVICE_CREATED, NotificationSenderTest.PROVIDER, NotificationSenderTest.SERVICE_2)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider2/service"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.SERVICE_CREATED, NotificationSenderTest.PROVIDER_2, NotificationSenderTest.SERVICE)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }
    }

    @Nested
    class ProviderLifecycleTests {
        ProviderLifecycleTests() {
        }

        @Test
        void testAddProvider() {
            NotificationSenderTest.this.accumulator.addProvider(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.PROVIDER_CREATED, NotificationSenderTest.PROVIDER)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testRemoveProvider() {
            NotificationSenderTest.this.accumulator.removeProvider(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.PROVIDER_DELETED, NotificationSenderTest.PROVIDER)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testAddRemoveProvider() {
            NotificationSenderTest.this.accumulator.addProvider(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER);
            NotificationSenderTest.this.accumulator.removeProvider(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER);
            NotificationSenderTest.this.accumulator.completeAndSend();
            Mockito.verifyNoInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testRemoveAddProvider() {
            NotificationSenderTest.this.accumulator.removeProvider(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER);
            NotificationSenderTest.this.accumulator.addProvider(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER);
            NotificationSenderTest.this.accumulator.completeAndSend();
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{NotificationSenderTest.this.bus});
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.PROVIDER_DELETED, NotificationSenderTest.PROVIDER)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.PROVIDER_CREATED, NotificationSenderTest.PROVIDER)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testAddAddProvider() {
            NotificationSenderTest.this.accumulator.addProvider(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER);
            NotificationSenderTest.this.accumulator.addProvider(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.PROVIDER_CREATED, NotificationSenderTest.PROVIDER)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testRemoveRemoveProvider() {
            NotificationSenderTest.this.accumulator.removeProvider(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER);
            NotificationSenderTest.this.accumulator.removeProvider(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.PROVIDER_DELETED, NotificationSenderTest.PROVIDER)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testRemoveAddRemoveProvider() {
            NotificationSenderTest.this.accumulator.removeProvider(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER);
            NotificationSenderTest.this.accumulator.addProvider(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER);
            NotificationSenderTest.this.accumulator.removeProvider(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER);
            NotificationSenderTest.this.accumulator.completeAndSend();
            ((TypedEventBus)Mockito.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.PROVIDER_DELETED, NotificationSenderTest.PROVIDER)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }

        @Test
        void testAddProviders() {
            NotificationSenderTest.this.accumulator.addProvider(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER);
            NotificationSenderTest.this.accumulator.addProvider(NotificationSenderTest.this.MODEL_PKG, NotificationSenderTest.MODEL, NotificationSenderTest.PROVIDER_2);
            NotificationSenderTest.this.accumulator.completeAndSend();
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{NotificationSenderTest.this.bus});
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.PROVIDER_CREATED, NotificationSenderTest.PROVIDER)));
            ((TypedEventBus)inOrder.verify((Object)NotificationSenderTest.this.bus)).deliver((String)ArgumentMatchers.eq((Object)"LIFECYCLE/model/provider2"), ArgumentMatchers.argThat(NotificationSenderTest.this.isLifecycleNotificationWith(LifecycleNotification.Status.PROVIDER_CREATED, NotificationSenderTest.PROVIDER_2)));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{NotificationSenderTest.this.bus});
        }
    }
}

