/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.metrics.impl;

import java.util.Hashtable;
import org.eclipse.sensinact.core.metrics.IMetricsListener;
import org.eclipse.sensinact.core.metrics.impl.MetricsConfiguration;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.core.push.dto.BulkGenericDto;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={}, configurationPid={"sensinact.metrics"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class MetricsProviderHandler
implements IMetricsListener {
    @Reference
    private DataUpdate updater;
    private boolean enabled;
    private ServiceRegistration<IMetricsListener> svcReg;

    @Activate
    void activate(BundleContext ctx, MetricsConfiguration config) {
        this.enabled = config.enabled() && config.provider_enabled();
        this.svcReg = this.enabled ? ctx.registerService(IMetricsListener.class, (Object)this, new Hashtable()) : null;
    }

    @Deactivate
    void deactivate() {
        this.enabled = false;
        if (this.svcReg != null) {
            this.svcReg.unregister();
            this.svcReg = null;
        }
    }

    public void onMetricsReport(BulkGenericDto dto) {
        if (this.enabled) {
            this.updater.pushUpdate((Object)dto);
        }
    }
}

