/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.model.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.sensinact.core.emf.model.EMFModel;
import org.eclipse.sensinact.core.emf.model.EMFModelBuilder;
import org.eclipse.sensinact.core.model.ModelBuilder;
import org.eclipse.sensinact.core.model.ServiceBuilder;
import org.eclipse.sensinact.core.model.impl.AbstractBuilderImpl;
import org.eclipse.sensinact.core.model.impl.ModelImpl;
import org.eclipse.sensinact.core.model.impl.NestableBuilderImpl;
import org.eclipse.sensinact.core.model.impl.ServiceBuilderImpl;
import org.eclipse.sensinact.core.model.nexus.ModelNexus;
import org.eclipse.sensinact.core.model.nexus.emf.EMFUtil;

public class ModelBuilderImpl
extends AbstractBuilderImpl<EMFModel>
implements EMFModelBuilder {
    private final ModelNexus nexusImpl;
    private final String name;
    private final List<NestableBuilderImpl<?, ModelImpl, ?>> nested = new ArrayList();
    private Instant creationTime;
    private final EClass modelEClass;
    private String packageUri;

    public ModelBuilderImpl(AtomicBoolean active, ModelNexus nexusImpl, String packageUri, String name) {
        super(active);
        this.nexusImpl = nexusImpl;
        this.packageUri = packageUri;
        this.name = name;
        this.modelEClass = null;
    }

    public ModelBuilderImpl(AtomicBoolean active, ModelNexus nexusImpl, EClass model) {
        super(active);
        this.nexusImpl = nexusImpl;
        this.modelEClass = model;
        this.name = EMFUtil.getModelName(model);
        this.packageUri = model.getEPackage().getNsURI();
    }

    public EMFModelBuilder exclusivelyOwned(boolean exclusive) {
        this.checkValid();
        throw new RuntimeException("Not implemented");
    }

    public EMFModelBuilder withAutoDeletion(boolean autoDelete) {
        this.checkValid();
        throw new RuntimeException("Not implemented");
    }

    public EMFModelBuilder withCreationTime(Instant creationTime) {
        this.checkValid();
        this.creationTime = creationTime;
        return this;
    }

    public ServiceBuilder<ModelBuilder> withService(String name) {
        this.checkValid();
        if (this.modelEClass != null) {
            throw new RuntimeException("Extendable Ecore Models arent supported yet.");
        }
        ServiceBuilderImpl<ModelBuilderImpl> sb = new ServiceBuilderImpl<ModelBuilderImpl>(this.active, this, null, name, this.nexusImpl);
        this.nested.add(sb);
        return sb;
    }

    @Override
    protected EMFModel doBuild() {
        this.checkValid();
        if (this.modelEClass != null) {
            return new ModelImpl(this.active, this.name, this.nexusImpl.registerModel(this.modelEClass, this.creationTime == null ? Instant.now() : this.creationTime, false), this.nexusImpl);
        }
        ModelImpl modelImpl = new ModelImpl(this.active, this.name, this.nexusImpl.createModel(this.packageUri, this.name, this.creationTime == null ? Instant.now() : this.creationTime), this.nexusImpl);
        this.nested.forEach(n -> n.doBuild(modelImpl));
        return modelImpl;
    }
}

