/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.UriInfo;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.core.snapshot.ServiceSnapshot;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.eclipse.sensinact.gateway.geojson.Coordinates;
import org.eclipse.sensinact.gateway.geojson.Feature;
import org.eclipse.sensinact.gateway.geojson.FeatureCollection;
import org.eclipse.sensinact.gateway.geojson.GeoJsonObject;
import org.eclipse.sensinact.gateway.geojson.Geometry;
import org.eclipse.sensinact.gateway.geojson.Point;
import org.eclipse.sensinact.gateway.geojson.Polygon;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.FeatureOfInterest;
import org.eclipse.sensinact.sensorthings.sensing.dto.HistoricalLocation;
import org.eclipse.sensinact.sensorthings.sensing.dto.Id;
import org.eclipse.sensinact.sensorthings.sensing.dto.Location;
import org.eclipse.sensinact.sensorthings.sensing.dto.Observation;
import org.eclipse.sensinact.sensorthings.sensing.dto.ObservedProperty;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.dto.Sensor;
import org.eclipse.sensinact.sensorthings.sensing.dto.Thing;
import org.eclipse.sensinact.sensorthings.sensing.dto.UnitOfMeasurement;
import org.eclipse.sensinact.sensorthings.sensing.rest.ExpansionSettings;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.DatastreamsAccessImpl;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.FeaturesOfInterestAccessImpl;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.RootResourceAccessImpl;

public class DtoMapper {
    private static final String ADMIN = "admin";
    private static final String DESCRIPTION = "description";
    private static final String FRIENDLY_NAME = "friendlyName";
    private static final String LOCATION = "location";
    private static final String DEFAULT_ENCODING_TYPE = "text/plain";
    private static final String ENCODING_TYPE_VND_GEO_JSON = "application/vnd.geo+json";
    private static final String VERSION = "v1.1";
    private static final String NO_DESCRIPTION = "No description";
    private static final String NO_DEFINITION = "No definition";

    private static Optional<ResourceSnapshot> getProviderAdminField(ProviderSnapshot provider, String resource) {
        ServiceSnapshot adminSvc = provider.getServices().stream().filter(s -> ADMIN.equals(s.getName())).findFirst().get();
        return adminSvc.getResources().stream().filter(r -> resource.equals(r.getName())).findFirst();
    }

    private static Optional<Object> getProviderAdminFieldValue(ProviderSnapshot provider, String resource) {
        TimedValue value;
        Optional<ResourceSnapshot> rc = DtoMapper.getProviderAdminField(provider, resource);
        if (rc.isPresent() && (value = rc.get().getValue()) != null) {
            return Optional.ofNullable(value.getValue());
        }
        return Optional.empty();
    }

    private static String toString(Object o) {
        return o == null ? null : String.valueOf(o);
    }

    private static String toString(Optional<?> o) {
        return o == null || o.isEmpty() ? null : String.valueOf(o.get());
    }

    public static Thing toThing(SensiNactSession userSession, Application application, ObjectMapper mapper, UriInfo uriInfo, ExpansionSettings expansions, ProviderSnapshot provider) {
        ResultList list;
        Thing thing = new Thing();
        thing.id = provider.getName();
        String friendlyName = DtoMapper.toString(DtoMapper.getProviderAdminFieldValue(provider, FRIENDLY_NAME));
        thing.name = Objects.requireNonNullElse(friendlyName, provider.getName());
        String description = DtoMapper.toString(DtoMapper.getProviderAdminFieldValue(provider, DESCRIPTION));
        thing.description = Objects.requireNonNullElse(description, NO_DESCRIPTION);
        thing.selfLink = uriInfo.getBaseUriBuilder().path(VERSION).path("Things({id})").resolveTemplate("id", thing.id).build(new Object[0]).toString();
        thing.datastreamsLink = uriInfo.getBaseUriBuilder().uri(thing.selfLink).path("Datastreams").build(new Object[0]).toString();
        thing.historicalLocationsLink = uriInfo.getBaseUriBuilder().uri(thing.selfLink).path("HistoricalLocations").build(new Object[0]).toString();
        thing.locationsLink = uriInfo.getBaseUriBuilder().uri(thing.selfLink).path("Locations").build(new Object[0]).toString();
        if (expansions.shouldExpand("Datastreams", (Id)thing)) {
            expansions.addExpansion("Datastreams", (Id)thing, DatastreamsAccessImpl.getDataStreams(userSession, application, mapper, uriInfo, expansions.getExpansionSettings("Datastreams"), provider));
        }
        if (expansions.shouldExpand("HistoricalLocations", (Id)thing)) {
            list = new ResultList();
            list.value = List.of(DtoMapper.toHistoricalLocation(userSession, application, mapper, uriInfo, expansions.getExpansionSettings("HistoricalLocations"), provider));
            expansions.addExpansion("HistoricalLocations", (Id)thing, (Object)list);
        }
        if (expansions.shouldExpand("Locations", (Id)thing)) {
            list = new ResultList();
            list.value = List.of(DtoMapper.toLocation(userSession, application, mapper, uriInfo, expansions.getExpansionSettings("Locations"), provider));
            expansions.addExpansion("Locations", (Id)thing, (Object)list);
        }
        return thing;
    }

    public static Location toLocation(SensiNactSession userSession, Application application, ObjectMapper mapper, UriInfo uriInfo, ExpansionSettings expansions, ProviderSnapshot provider) {
        ResultList list;
        Location location = new Location();
        String providerName = provider.getName();
        TimedValue<GeoJsonObject> rcLocation = DtoMapper.getLocation(provider, mapper, false);
        Instant time = rcLocation.getTimestamp();
        GeoJsonObject object = (GeoJsonObject)rcLocation.getValue();
        location.id = String.format("%s~%s", providerName, Long.toString(time.toEpochMilli(), 16));
        String friendlyName = DtoMapper.getProperty(object, "name");
        location.name = Objects.requireNonNullElse(friendlyName, providerName);
        String description = DtoMapper.getProperty(object, DESCRIPTION);
        location.description = Objects.requireNonNullElse(description, NO_DESCRIPTION);
        location.encodingType = ENCODING_TYPE_VND_GEO_JSON;
        location.location = object;
        location.selfLink = uriInfo.getBaseUriBuilder().path(VERSION).path("Locations({id})").resolveTemplate("id", location.id).build(new Object[0]).toString();
        location.thingsLink = uriInfo.getBaseUriBuilder().uri(location.selfLink).path("Things").build(new Object[0]).toString();
        location.historicalLocationsLink = uriInfo.getBaseUriBuilder().uri(location.selfLink).path("HistoricalLocations").build(new Object[0]).toString();
        if (expansions.shouldExpand("Things", (Id)location)) {
            list = new ResultList();
            list.value = List.of(DtoMapper.toThing(userSession, application, mapper, uriInfo, expansions.getExpansionSettings("Thing"), provider));
            expansions.addExpansion("Things", (Id)location, (Object)list);
        }
        if (expansions.shouldExpand("HistoricalLocations", (Id)location)) {
            list = new ResultList();
            list.value = List.of(DtoMapper.toHistoricalLocation(userSession, application, mapper, uriInfo, expansions.getExpansionSettings("HistoricalLocations"), provider));
            expansions.addExpansion("HistoricalLocations", (Id)location, (Object)list);
        }
        return location;
    }

    public static HistoricalLocation toHistoricalLocation(SensiNactSession userSession, Application application, ObjectMapper mapper, UriInfo uriInfo, ExpansionSettings expansions, ProviderSnapshot provider) {
        HistoricalLocation historicalLocation = new HistoricalLocation();
        TimedValue<GeoJsonObject> location = DtoMapper.getLocation(provider, mapper, true);
        Instant time = location.getTimestamp() == null ? Instant.EPOCH : location.getTimestamp();
        historicalLocation.id = String.format("%s~%s", provider.getName(), Long.toString(time.toEpochMilli(), 16));
        historicalLocation.time = time;
        historicalLocation.selfLink = uriInfo.getBaseUriBuilder().path(VERSION).path("HistoricalLocations({id})").resolveTemplate("id", historicalLocation.id).build(new Object[0]).toString();
        historicalLocation.thingLink = uriInfo.getBaseUriBuilder().uri(historicalLocation.selfLink).path("Thing").build(new Object[0]).toString();
        historicalLocation.locationsLink = uriInfo.getBaseUriBuilder().uri(historicalLocation.selfLink).path("Locations").build(new Object[0]).toString();
        if (expansions.shouldExpand("Thing", (Id)historicalLocation)) {
            expansions.addExpansion("Thing", (Id)historicalLocation, (Object)DtoMapper.toThing(userSession, application, mapper, uriInfo, expansions.getExpansionSettings("Thing"), provider));
        }
        if (expansions.shouldExpand("Locations", (Id)historicalLocation)) {
            ResultList list = new ResultList();
            list.value = List.of(DtoMapper.toLocation(userSession, application, mapper, uriInfo, expansions.getExpansionSettings("Locations"), provider));
            expansions.addExpansion("Locations", (Id)historicalLocation, (Object)list);
        }
        return historicalLocation;
    }

    public static Datastream toDatastream(SensiNactSession userSession, Application application, ObjectMapper mapper, UriInfo uriInfo, ExpansionSettings expansions, ResourceSnapshot resource) {
        if (resource == null) {
            throw new NotFoundException();
        }
        Datastream datastream = new Datastream();
        ProviderSnapshot provider = resource.getService().getProvider();
        Map metadata = resource.getMetadata();
        datastream.id = String.format("%s~%s~%s", provider.getName(), resource.getService().getName(), resource.getName());
        datastream.name = DtoMapper.toString(metadata.getOrDefault(FRIENDLY_NAME, resource.getName()));
        datastream.description = DtoMapper.toString(metadata.getOrDefault(DESCRIPTION, NO_DESCRIPTION));
        datastream.observationType = "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Observation";
        UnitOfMeasurement unit = new UnitOfMeasurement();
        unit.symbol = Objects.toString(metadata.get("unit"), null);
        unit.name = Objects.toString(metadata.get("sensorthings.unit.name"), null);
        unit.definition = Objects.toString(metadata.get("sensorthings.unit.definition"), null);
        datastream.unitOfMeasurement = unit;
        datastream.observedArea = DtoMapper.getObservedArea((GeoJsonObject)DtoMapper.getLocation(provider, mapper, resource, false).getValue());
        datastream.properties = metadata;
        datastream.selfLink = uriInfo.getBaseUriBuilder().path(VERSION).path("Datastreams({id})").resolveTemplate("id", datastream.id).build(new Object[0]).toString();
        datastream.observationsLink = uriInfo.getBaseUriBuilder().uri(datastream.selfLink).path("Observations").build(new Object[0]).toString();
        datastream.observedPropertyLink = uriInfo.getBaseUriBuilder().uri(datastream.selfLink).path("ObservedProperty").build(new Object[0]).toString();
        datastream.sensorLink = uriInfo.getBaseUriBuilder().uri(datastream.selfLink).path("Sensor").build(new Object[0]).toString();
        datastream.thingLink = uriInfo.getBaseUriBuilder().uri(datastream.selfLink).path("Thing").build(new Object[0]).toString();
        if (expansions.shouldExpand("Observations", (Id)datastream)) {
            expansions.addExpansion("Observations", (Id)datastream, RootResourceAccessImpl.getObservationList(userSession, application, mapper, uriInfo, expansions.getExpansionSettings("Observations"), resource, 25));
        }
        if (expansions.shouldExpand("ObservedProperty", (Id)datastream)) {
            expansions.addExpansion("ObservedProperty", (Id)datastream, (Object)DtoMapper.toObservedProperty(userSession, application, mapper, uriInfo, expansions.getExpansionSettings("ObservedProperty"), resource));
        }
        if (expansions.shouldExpand("Sensor", (Id)datastream)) {
            expansions.addExpansion("Sensor", (Id)datastream, (Object)DtoMapper.toSensor(userSession, application, mapper, uriInfo, expansions.getExpansionSettings("Sensor"), resource));
        }
        if (expansions.shouldExpand("Thing", (Id)datastream)) {
            expansions.addExpansion("Thing", (Id)datastream, (Object)DtoMapper.toThing(userSession, application, mapper, uriInfo, expansions.getExpansionSettings("Thing"), provider));
        }
        return datastream;
    }

    public static Sensor toSensor(SensiNactSession userSession, Application application, ObjectMapper mapper, UriInfo uriInfo, ExpansionSettings expansions, ResourceSnapshot resource) {
        if (resource == null) {
            throw new NotFoundException();
        }
        Sensor sensor = new Sensor();
        ProviderSnapshot providerSnapshot = resource.getService().getProvider();
        String provider = providerSnapshot.getName();
        Map metadata = resource.getMetadata();
        sensor.id = String.format("%s~%s~%s", provider, resource.getService().getName(), resource.getName());
        sensor.name = DtoMapper.toString(metadata.getOrDefault(FRIENDLY_NAME, resource.getName()));
        sensor.description = DtoMapper.toString(metadata.getOrDefault(DESCRIPTION, NO_DESCRIPTION));
        sensor.properties = metadata;
        sensor.metadata = metadata.getOrDefault("sensorthings.sensor.metadata", "No metadata");
        sensor.encodingType = DtoMapper.toString(metadata.getOrDefault("sensorthings.sensor.encodingType", DEFAULT_ENCODING_TYPE));
        sensor.selfLink = uriInfo.getBaseUriBuilder().path(VERSION).path("Sensors({id})").resolveTemplate("id", sensor.id).build(new Object[0]).toString();
        sensor.datastreamsLink = uriInfo.getBaseUriBuilder().uri(sensor.selfLink).path("Datastreams").build(new Object[0]).toString();
        if (expansions.shouldExpand("Datastreams", (Id)sensor)) {
            expansions.addExpansion("Datastreams", (Id)sensor, DatastreamsAccessImpl.getDataStreams(userSession, application, mapper, uriInfo, expansions.getExpansionSettings("Datastreams"), providerSnapshot));
        }
        return sensor;
    }

    public static List<Observation> toObservationList(SensiNactSession userSession, Application application, ObjectMapper mapper, UriInfo uriInfo, ExpansionSettings expansions, ResourceSnapshot resourceSnapshot, List<TimedValue<?>> observations) {
        if (resourceSnapshot == null) {
            throw new NotFoundException();
        }
        ArrayList<Observation> list = new ArrayList<Observation>(observations.size());
        for (TimedValue<?> tv : observations) {
            list.add(DtoMapper.toObservation(userSession, application, mapper, uriInfo, expansions, resourceSnapshot, Optional.of(tv)));
        }
        return list;
    }

    public static Observation toObservation(SensiNactSession userSession, Application application, ObjectMapper mapper, UriInfo uriInfo, ExpansionSettings expansions, ResourceSnapshot resource) {
        return DtoMapper.toObservation(userSession, application, mapper, uriInfo, expansions, resource, Optional.ofNullable(resource.getValue()));
    }

    public static Observation toObservation(SensiNactSession userSession, Application application, ObjectMapper mapper, UriInfo uriInfo, ExpansionSettings expansions, ResourceSnapshot resource, Optional<TimedValue<?>> t) {
        if (resource == null) {
            throw new NotFoundException();
        }
        Observation observation = new Observation();
        Instant timestamp = t.map(TimedValue::getTimestamp).orElse(null);
        ProviderSnapshot providerSnapshot = resource.getService().getProvider();
        observation.id = String.format("%s~%s~%s~%s", providerSnapshot.getName(), resource.getService().getName(), resource.getName(), Long.toString(timestamp.toEpochMilli(), 16));
        observation.resultTime = timestamp;
        observation.result = t.map(TimedValue::getValue).orElse(null);
        observation.phenomenonTime = timestamp;
        observation.resultQuality = resource.getMetadata().get("sensorthings.observation.quality");
        observation.selfLink = uriInfo.getBaseUriBuilder().path(VERSION).path("Observations({id})").resolveTemplate("id", observation.id).build(new Object[0]).toString();
        observation.datastreamLink = uriInfo.getBaseUriBuilder().uri(observation.selfLink).path("Datastream").build(new Object[0]).toString();
        observation.featureOfInterestLink = uriInfo.getBaseUriBuilder().uri(observation.selfLink).path("FeatureOfInterest").build(new Object[0]).toString();
        if (expansions.shouldExpand("Datastream", (Id)observation)) {
            expansions.addExpansion("Datastream", (Id)observation, (Object)DtoMapper.toDatastream(userSession, application, mapper, uriInfo, expansions.getExpansionSettings("Datastream"), resource));
        }
        if (expansions.shouldExpand("FeatureOfInterest", (Id)observation)) {
            expansions.addExpansion("FeatureOfInterest", (Id)observation, (Object)DtoMapper.toFeatureOfInterest(userSession, application, mapper, uriInfo, expansions.getExpansionSettings("FeatureOfInterest"), providerSnapshot));
        }
        return observation;
    }

    public static ObservedProperty toObservedProperty(SensiNactSession userSession, Application application, ObjectMapper mapper, UriInfo uriInfo, ExpansionSettings expansions, ResourceSnapshot resource) {
        ObservedProperty observedProperty = new ObservedProperty();
        Map metadata = resource.getMetadata();
        ProviderSnapshot providerSnapshot = resource.getService().getProvider();
        observedProperty.id = String.format("%s~%s~%s", providerSnapshot.getName(), resource.getService().getName(), resource.getName());
        observedProperty.name = DtoMapper.toString(metadata.getOrDefault(FRIENDLY_NAME, resource.getName()));
        observedProperty.description = DtoMapper.toString(metadata.getOrDefault(DESCRIPTION, NO_DESCRIPTION));
        observedProperty.properties = metadata;
        observedProperty.definition = DtoMapper.toString(metadata.getOrDefault("sensorthings.observedproperty.definition", NO_DEFINITION));
        observedProperty.selfLink = uriInfo.getBaseUriBuilder().path(VERSION).path("ObservedProperties({id})").resolveTemplate("id", observedProperty.id).build(new Object[0]).toString();
        observedProperty.datastreamsLink = uriInfo.getBaseUriBuilder().uri(observedProperty.selfLink).path("Datastreams").build(new Object[0]).toString();
        if (expansions.shouldExpand("Datastreams", (Id)observedProperty)) {
            expansions.addExpansion("Datastreams", (Id)observedProperty, DatastreamsAccessImpl.getDataStreams(userSession, application, mapper, uriInfo, expansions.getExpansionSettings("Datastreams"), providerSnapshot));
        }
        return observedProperty;
    }

    public static FeatureOfInterest toFeatureOfInterest(SensiNactSession userSession, Application application, ObjectMapper mapper, UriInfo uriInfo, ExpansionSettings expansions, ProviderSnapshot provider) {
        FeatureOfInterest featureOfInterest = new FeatureOfInterest();
        String providerName = provider.getName();
        TimedValue<GeoJsonObject> location = DtoMapper.getLocation(provider, mapper, false);
        GeoJsonObject object = (GeoJsonObject)location.getValue();
        featureOfInterest.id = providerName;
        String friendlyName = DtoMapper.getProperty(object, "name");
        featureOfInterest.name = Objects.requireNonNullElse(friendlyName, providerName);
        String description = DtoMapper.getProperty(object, DESCRIPTION);
        featureOfInterest.description = Objects.requireNonNullElse(description, NO_DESCRIPTION);
        featureOfInterest.encodingType = ENCODING_TYPE_VND_GEO_JSON;
        featureOfInterest.feature = object;
        featureOfInterest.selfLink = uriInfo.getBaseUriBuilder().path(VERSION).path("FeaturesOfInterest({id})").resolveTemplate("id", featureOfInterest.id).build(new Object[0]).toString();
        featureOfInterest.observationsLink = uriInfo.getBaseUriBuilder().uri(featureOfInterest.selfLink).path("Observations").build(new Object[0]).toString();
        if (expansions.shouldExpand("Observations", (Id)featureOfInterest)) {
            expansions.addExpansion("Observations", (Id)featureOfInterest, FeaturesOfInterestAccessImpl.getLiveObservations(userSession, application, mapper, uriInfo, expansions.getExpansionSettings("Observations"), provider));
        }
        return featureOfInterest;
    }

    public static String extractFirstIdSegment(String id) {
        if (id.isEmpty()) {
            throw new BadRequestException("Invalid id");
        }
        int idx = id.indexOf(126);
        if (idx == -1) {
            return id;
        }
        if (idx == 0 || idx == id.length() - 1) {
            throw new BadRequestException("Invalid id");
        }
        return id.substring(0, idx);
    }

    public static Instant getTimestampFromId(String id) {
        int idx = id.lastIndexOf(126);
        if (idx < 0 || idx == id.length() - 1) {
            throw new BadRequestException("Invalid id");
        }
        try {
            return Instant.ofEpochMilli(Long.parseLong(id.substring(idx + 1), 16));
        }
        catch (Exception e) {
            throw new BadRequestException("Invalid id");
        }
    }

    public static void validatedProviderId(String id) {
        if (id.contains("~")) {
            throw new BadRequestException("Multi-segments ID found");
        }
    }

    private static Polygon getObservedArea(GeoJsonObject location) {
        Geometry geometry = null;
        if (location instanceof Feature) {
            geometry = ((Feature)location).geometry;
        } else if (location instanceof FeatureCollection) {
            geometry = ((FeatureCollection)location).features.stream().map(f -> f.geometry).filter(Polygon.class::isInstance).map(Polygon.class::cast).findFirst().orElse(null);
        }
        return geometry instanceof Polygon ? (Polygon)geometry : null;
    }

    private static String getProperty(GeoJsonObject location, String propName) {
        if (location instanceof Feature) {
            Feature f2 = (Feature)location;
            return DtoMapper.toString(f2.properties.get(propName));
        }
        if (location instanceof FeatureCollection) {
            FeatureCollection fc = (FeatureCollection)location;
            return fc.features.stream().map(f -> DtoMapper.toString(f.properties.get(propName))).filter(p -> p != null).findFirst().orElse(null);
        }
        return null;
    }

    private static TimedValue<GeoJsonObject> getLocation(ProviderSnapshot provider, ObjectMapper mapper, ResourceSnapshot resource, boolean allowNull) {
        Optional<ResourceSnapshot> optRS = resource.getService().getResources().stream().filter(r -> r.getMetadata().keySet().contains("sensorthings.observedArea")).findFirst();
        TimedValue<GeoJsonObject> location = null;
        if (optRS.isPresent()) {
            ResourceSnapshot rs = optRS.get();
            location = DtoMapper.getLocation(mapper, rs.getValue().getValue(), rs.getValue().getTimestamp(), allowNull);
        }
        if (location == null) {
            location = DtoMapper.getLocation(provider, mapper, allowNull);
        }
        return location;
    }

    private static TimedValue<GeoJsonObject> getLocation(ProviderSnapshot provider, ObjectMapper mapper, boolean allowNull) {
        Object rawValue;
        Instant time;
        Optional<ResourceSnapshot> locationResource = DtoMapper.getProviderAdminField(provider, LOCATION);
        if (locationResource.isEmpty()) {
            time = Instant.EPOCH;
            rawValue = null;
        } else {
            TimedValue timedValue = locationResource.get().getValue();
            if (timedValue == null) {
                time = Instant.EPOCH;
                rawValue = null;
            } else {
                time = timedValue.getTimestamp() != null ? timedValue.getTimestamp() : Instant.EPOCH;
                rawValue = timedValue.getValue();
            }
        }
        return DtoMapper.getLocation(mapper, rawValue, time, allowNull);
    }

    private static TimedValue<GeoJsonObject> getLocation(ObjectMapper mapper, Object rawValue, final Instant time, boolean allowNull) {
        GeoJsonObject parsedLocation;
        if (rawValue == null) {
            if (allowNull) {
                parsedLocation = null;
            } else {
                Point point = new Point();
                point.coordinates = new Coordinates();
                parsedLocation = point;
            }
        } else if (rawValue instanceof GeoJsonObject) {
            parsedLocation = (GeoJsonObject)rawValue;
        } else if (rawValue instanceof String) {
            try {
                parsedLocation = (GeoJsonObject)mapper.readValue((String)rawValue, GeoJsonObject.class);
            }
            catch (JsonProcessingException ex) {
                if (allowNull) {
                    return null;
                }
                throw new RuntimeException("Invalid resource location content", ex);
            }
        } else {
            parsedLocation = (GeoJsonObject)mapper.convertValue(rawValue, GeoJsonObject.class);
        }
        return new TimedValue<GeoJsonObject>(){

            public Instant getTimestamp() {
                return time;
            }

            public GeoJsonObject getValue() {
                return parsedLocation;
            }
        };
    }
}

