/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.impl;

import jakarta.ws.rs.NotFoundException;
import java.util.List;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.Observation;
import org.eclipse.sensinact.sensorthings.sensing.dto.ObservedProperty;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.dto.Sensor;
import org.eclipse.sensinact.sensorthings.sensing.dto.Thing;
import org.eclipse.sensinact.sensorthings.sensing.rest.SensorsAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.annotation.PaginationLimit;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.AbstractAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.DtoMapper;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.RootResourceAccessImpl;

public class SensorsAccessImpl
extends AbstractAccess
implements SensorsAccess {
    public Sensor getSensor(String id) {
        return DtoMapper.toSensor(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetResourceSnapshot(id));
    }

    public ResultList<Datastream> getSensorDatastreams(String id) {
        ResultList list = new ResultList();
        list.value = List.of(this.getSensorDatastream(id, id));
        return list;
    }

    public Datastream getSensorDatastream(String id, String id2) {
        if (!id.equals(id2)) {
            throw new NotFoundException();
        }
        return DtoMapper.toDatastream(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetResourceSnapshot(id));
    }

    @PaginationLimit(value=500)
    public ResultList<Observation> getSensorDatastreamObservations(String id, String id2) {
        if (!id.equals(id2)) {
            throw new NotFoundException();
        }
        return RootResourceAccessImpl.getObservationList(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), this.validateAndGetResourceSnapshot(id), 0);
    }

    public ObservedProperty getSensorDatastreamObservedProperty(String id, String id2) {
        if (!id.equals(id2)) {
            throw new NotFoundException();
        }
        ResourceSnapshot resource = this.validateAndGetResourceSnapshot(id);
        ObservedProperty o = DtoMapper.toObservedProperty(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), resource);
        if (!id.equals(o.id)) {
            throw new NotFoundException();
        }
        return o;
    }

    public Sensor getSensorDatastreamSensor(String id, String id2) {
        if (!id.equals(id2)) {
            throw new NotFoundException();
        }
        return this.getSensor(id);
    }

    public Thing getSensorDatastreamThing(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        ProviderSnapshot providerSnapshot = this.validateAndGetProvider(provider);
        Thing t = DtoMapper.toThing(this.getSession(), this.application, this.getMapper(), this.uriInfo, this.getExpansions(), providerSnapshot);
        if (!provider.equals(t.id)) {
            throw new NotFoundException();
        }
        return t;
    }
}

