/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgitech.rest.factories;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.osgitech.rest.factories.InjectableFactory;
import org.eclipse.osgitech.rest.runtime.application.JerseyApplicationContentProvider;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.osgi.framework.ServiceObjects;

public class JerseyResourceInstanceFactory<T>
implements InjectableFactory<T> {
    private volatile Set<Object> instanceCache = new HashSet<Object>();
    private JerseyApplicationContentProvider provider;
    private ServiceObjects<Object> serviceObjects;
    private InjectionManager injectionManager;

    public JerseyResourceInstanceFactory(JerseyApplicationContentProvider provider) {
        this.provider = provider;
        this.serviceObjects = (ServiceObjects)provider.getProviderObject();
    }

    public void dispose(T object) {
        this.disposeInstance(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T provide() {
        try {
            if (this.serviceObjects == null) {
                return null;
            }
            Object instance = this.serviceObjects.getService();
            if (instance == null) {
                return null;
            }
            if (this.injectionManager != null) {
                this.injectionManager.inject(instance);
            }
            Set<Object> set = this.instanceCache;
            synchronized (set) {
                this.instanceCache.add(instance);
            }
            return (T)instance;
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException) {
                throw e;
            }
            throw new IllegalStateException("Cannot create prototype instance for class " + this.provider.getId(), e);
        }
    }

    public void dispose() {
        if (this.serviceObjects != null) {
            this.instanceCache.forEach(i -> this.serviceObjects.ungetService(i));
        }
        this.instanceCache.clear();
    }

    public int getCacheInstanceCount() {
        return this.instanceCache.size();
    }

    private void disposeInstance(T instance) {
        if (instance == null) {
            return;
        }
        if (this.instanceCache.remove(instance)) {
            try {
                this.serviceObjects.ungetService(instance);
            }
            catch (Exception e) {
                if (e instanceof IllegalStateException) {
                    throw e;
                }
                throw new IllegalStateException("Error disposing instance " + instance, e);
            }
        }
    }

    @Override
    public void setInjectionManager(InjectionManager injectionManager) {
        this.injectionManager = injectionManager;
    }
}

