/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgitech.rest.runtime.common;

import aQute.bnd.annotation.service.ServiceCapability;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.osgitech.rest.provider.jakartars.RuntimeDelegateService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.condition.Condition;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@ServiceCapability(value=Condition.class)
public class JerseyBundleTracker
implements BundleTrackerCustomizer<Boolean> {
    private static final Logger logger = Logger.getLogger("runtime.check");
    private final Map<String, Boolean> bsns = new HashMap<String, Boolean>(5);
    private final boolean isClientOnly;
    private final BundleTracker<Boolean> tracker;
    private final BundleContext context;
    private ServiceRegistration<Condition> jerseyRuntimeCondition;
    private Consumer<BundleContext> upConsumer;
    private Consumer<BundleContext> downConsumer;

    public JerseyBundleTracker(BundleContext context) {
        this(context, false);
    }

    public JerseyBundleTracker(BundleContext context, boolean isClientOnly) {
        this.context = context;
        this.isClientOnly = isClientOnly;
        this.bsns.put("org.glassfish.hk2.osgi-resource-locator", Boolean.FALSE);
        this.bsns.put("org.glassfish.jersey.inject.jersey-hk2", Boolean.FALSE);
        this.bsns.put("org.glassfish.jersey.core.jersey-common", Boolean.FALSE);
        this.bsns.put("org.glassfish.jersey.core.jersey-client", Boolean.FALSE);
        if (isClientOnly) {
            this.bsns.put("org.glassfish.jersey.core.jersey-server", Boolean.FALSE);
        }
        this.startBundles();
        this.tracker = new BundleTracker(context, 32, (BundleTrackerCustomizer)this);
    }

    public void open() {
        this.tracker.open();
    }

    public void close() {
        this.tracker.close();
    }

    public JerseyBundleTracker onJerseyUp(Consumer<BundleContext> upConsumer) {
        this.upConsumer = upConsumer;
        return this;
    }

    public JerseyBundleTracker onJerseyDown(Consumer<BundleContext> downConsumer) {
        this.downConsumer = downConsumer;
        return this;
    }

    public Boolean addingBundle(Bundle bundle, BundleEvent event) {
        String bsn = bundle.getSymbolicName();
        if (this.bsns.containsKey(bsn)) {
            this.bsns.put(bsn, Boolean.TRUE);
            this.updateCondition();
            return true;
        }
        return false;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Boolean object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Boolean object) {
        String bsn = bundle.getSymbolicName();
        if (this.bsns.containsKey(bsn)) {
            this.bsns.put(bsn, Boolean.FALSE);
            logger.log(Level.WARNING, () -> "Removed Jersey bundle: " + bsn);
            this.updateCondition();
        }
    }

    private void startBundles() {
        for (Bundle bundle : this.context.getBundles()) {
            String bsn = bundle.getSymbolicName();
            if (!this.bsns.containsKey(bsn)) continue;
            try {
                bundle.start();
            }
            catch (BundleException e) {
                logger.log(Level.WARNING, e, () -> "Cannot start Jersey bundle: " + bsn);
            }
        }
    }

    private synchronized void updateCondition() {
        if (!this.bsns.containsValue(Boolean.FALSE)) {
            if (this.jerseyRuntimeCondition != null) {
                logger.info(() -> "Jersey runtime condition is already registered! This should not happen! Doing nothing ...");
            }
            RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateService());
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            ((Dictionary)properties).put("osgi.condition.id", "jersey.runtime");
            ((Dictionary)properties).put("jersey.clientOnly", this.isClientOnly);
            this.jerseyRuntimeCondition = this.context.registerService(Condition.class, (Object)Condition.INSTANCE, properties);
            logger.info(() -> "Registered Jersey runtime condition");
            if (this.upConsumer != null) {
                try {
                    this.upConsumer.accept(this.context);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error in onJerseyUp runnable", e);
                }
            }
        } else {
            if (this.downConsumer != null) {
                try {
                    this.downConsumer.accept(this.context);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error in onJerseyUp runnable", e);
                }
            }
            if (this.jerseyRuntimeCondition != null) {
                this.jerseyRuntimeCondition.unregister();
                this.jerseyRuntimeCondition = null;
                logger.info(() -> "Un-registered Jersey runtime condition");
            }
        }
    }
}

