/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.http.callback.integration;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.sensinact.gateway.southbound.http.callback.api.HttpCallback;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.verification.VerificationMode;
import org.osgi.framework.BundleContext;
import org.osgi.test.common.annotation.InjectBundleContext;
import org.osgi.test.common.annotation.Property;
import org.osgi.test.common.annotation.config.WithConfiguration;
import org.osgi.test.common.annotation.config.WithConfigurations;

@MockitoSettings
public class HttpCallbackWhiteboardTest {
    @Mock
    HttpCallback callback;

    @WithConfigurations(value={@WithConfiguration(pid="org.apache.felix.http", location="?", properties={@Property(key="org.osgi.service.http.port", value={"8234"}), @Property(key="org.apache.felix.http.host", value={"127.0.0.1"})}), @WithConfiguration(pid="sensinact.http.callback.whiteboard", location="?", properties={})})
    @Test
    void basicWhiteboard(@InjectBundleContext BundleContext context) throws Exception {
        context.registerService(HttpCallback.class, (Object)this.callback, null);
        ArgumentCaptor stringCaptor = ArgumentCaptor.forClass(String.class);
        ((HttpCallback)Mockito.verify((Object)this.callback, (VerificationMode)Mockito.timeout((long)1000L))).activate((String)stringCaptor.capture());
        String uri = (String)stringCaptor.getValue();
        AtomicReference message = new AtomicReference();
        ((HttpCallback)Mockito.doAnswer(i -> {
            BufferedReader br = (BufferedReader)i.getArgument(2, BufferedReader.class);
            StringWriter sw = new StringWriter();
            br.transferTo(sw);
            message.compareAndSet(null, sw.toString());
            return null;
        }).when((Object)this.callback)).call((String)Mockito.eq((Object)uri), Mockito.anyMap(), (Reader)Mockito.any());
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder(URI.create(uri)).POST(HttpRequest.BodyPublishers.ofString("Hello World")).timeout(Duration.ofSeconds(2L)).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        Assertions.assertEquals((int)204, (int)response.statusCode());
        Assertions.assertEquals((Object)"Hello World", message.get());
    }

    @WithConfigurations(value={@WithConfiguration(pid="org.apache.felix.http", location="?", properties={@Property(key="org.osgi.service.http.port", value={"8235"}), @Property(key="org.apache.felix.http.host", value={"127.0.0.1"})}), @WithConfiguration(pid="sensinact.http.callback.whiteboard", location="?", properties={@Property(key="base.uri", value={"http://foo.com/bar"})})})
    @Test
    void customBaseUri(@InjectBundleContext BundleContext context) throws Exception {
        context.registerService(HttpCallback.class, (Object)this.callback, null);
        ArgumentCaptor stringCaptor = ArgumentCaptor.forClass(String.class);
        ((HttpCallback)Mockito.verify((Object)this.callback, (VerificationMode)Mockito.timeout((long)1000L))).activate((String)stringCaptor.capture());
        String uri = (String)stringCaptor.getValue();
        Assertions.assertTrue((boolean)uri.startsWith("http://foo.com/bar/"));
        String path = uri.substring("http://foo.com/bar/".length());
        AtomicReference message = new AtomicReference();
        ((HttpCallback)Mockito.doAnswer(i -> {
            BufferedReader br = (BufferedReader)i.getArgument(2, BufferedReader.class);
            StringWriter sw = new StringWriter();
            br.transferTo(sw);
            message.compareAndSet(null, sw.toString());
            return null;
        }).when((Object)this.callback)).call((String)Mockito.eq((Object)uri), Mockito.anyMap(), (Reader)Mockito.any());
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder(URI.create("http://localhost:8235/" + path)).POST(HttpRequest.BodyPublishers.ofString("Hello World")).timeout(Duration.ofSeconds(2L)).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        Assertions.assertEquals((int)204, (int)response.statusCode());
        Assertions.assertEquals((Object)"Hello World", message.get());
    }
}

