/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.sensinact.gateway.geojson.Coordinates;
import org.eclipse.sensinact.gateway.geojson.GeoJsonObject;
import org.eclipse.sensinact.gateway.geojson.GeoJsonType;
import org.eclipse.sensinact.gateway.geojson.LineString;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.ODataFilterBaseVisitor;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.ODataFilterParser;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.CommonExprVisitor;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.InvalidResultTypeException;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.ResourceValueFilterInputHolder;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.UnsupportedRuleException;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.distance.DistanceCalculator;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.ShapeFactory;

public class MethodCallExprVisitor
extends ODataFilterBaseVisitor<Function<ResourceValueFilterInputHolder, Object>> {
    final Parser parser;
    final CommonExprVisitor visitor;

    public MethodCallExprVisitor(Parser parser) {
        this.parser = parser;
        this.visitor = new CommonExprVisitor(parser);
    }

    @Override
    public Function<ResourceValueFilterInputHolder, Object> visitMethodcallexpr(ODataFilterParser.MethodcallexprContext ctx) {
        ParserRuleContext child = (ParserRuleContext)ctx.getChild(ParserRuleContext.class, 0);
        switch (child.getRuleIndex()) {
            case 67: 
            case 70: 
            case 71: 
            case 72: {
                return this.runSingleString(child);
            }
            case 68: 
            case 73: {
                return this.runDualString(child);
            }
            case 69: {
                return this.runSubstring((ODataFilterParser.SubstringmethodcallexprContext)child);
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: {
                return this.runDateMethod(child);
            }
            case 85: {
                return x -> Instant.EPOCH;
            }
            case 86: {
                return x -> Instant.MAX;
            }
            case 87: {
                Instant parseTime = Instant.now();
                return x -> parseTime;
            }
            case 88: 
            case 89: 
            case 90: {
                return this.runMathOps(child);
            }
            case 53: {
                return this.runGeoLength(child);
            }
            case 52: {
                return this.runGeoDistance(child);
            }
        }
        throw new UnsupportedRuleException("Unsupported method call", this.parser, child);
    }

    private <T> T convert(ParserRuleContext ctx, Object object, Class<T> type, boolean allowNull, String placeDescription) {
        if (object == null) {
            if (allowNull) {
                return null;
            }
            throw new InvalidResultTypeException(placeDescription + " is null", type.getSimpleName(), object);
        }
        if (!type.isAssignableFrom(object.getClass())) {
            throw new InvalidResultTypeException("Unsupported " + placeDescription + " for \"" + ctx.getText() + "\"", type.getSimpleName(), object);
        }
        return (T)object;
    }

    private Function<ResourceValueFilterInputHolder, Object> runSingleString(ParserRuleContext ctx) {
        Function<String, Object> operation;
        ODataFilterParser.CommonexprContext subExpr = (ODataFilterParser.CommonexprContext)ctx.getChild(ODataFilterParser.CommonexprContext.class, 0);
        Object targetExpr = this.visitor.visitCommonexpr(subExpr);
        switch (ctx.getRuleIndex()) {
            case 70: {
                operation = s -> s.toLowerCase();
                break;
            }
            case 71: {
                operation = s -> s.toUpperCase();
                break;
            }
            case 67: {
                operation = s -> s.length();
                break;
            }
            case 72: {
                operation = s -> s.trim();
                break;
            }
            default: {
                throw new RuntimeException("Unsupported rule: " + this.parser.getRuleNames()[ctx.getRuleIndex()]);
            }
        }
        return arg_0 -> MethodCallExprVisitor.lambda$runSingleString$7((Function)targetExpr, operation, arg_0);
    }

    private Function<ResourceValueFilterInputHolder, Object> runDualString(ParserRuleContext ctx) {
        BiFunction<String, String, Object> operation;
        ODataFilterParser.CommonexprContext leftExpr = (ODataFilterParser.CommonexprContext)ctx.getChild(ODataFilterParser.CommonexprContext.class, 0);
        ODataFilterParser.CommonexprContext rightExpr = (ODataFilterParser.CommonexprContext)ctx.getChild(ODataFilterParser.CommonexprContext.class, 1);
        Object leftFun = this.visitor.visitCommonexpr(leftExpr);
        Object rightFun = this.visitor.visitCommonexpr(rightExpr);
        switch (ctx.getRuleIndex()) {
            case 73: {
                operation = (l, r) -> l + r;
                break;
            }
            case 68: {
                operation = (l, r) -> l.indexOf((String)r);
                break;
            }
            default: {
                throw new UnsupportedRuleException(this.parser, ctx);
            }
        }
        return arg_0 -> this.lambda$runDualString$10(ctx, (Function)leftFun, (Function)rightFun, operation, arg_0);
    }

    private Function<ResourceValueFilterInputHolder, Object> runSubstring(ODataFilterParser.SubstringmethodcallexprContext ctx) {
        Object stringFun = this.visitor.visitCommonexpr(ctx.commonexpr(0));
        Object startPosFun = this.visitor.visitCommonexpr(ctx.commonexpr(1));
        if (ctx.commonexpr().size() == 2) {
            return arg_0 -> this.lambda$runSubstring$11(ctx, (Function)stringFun, (Function)startPosFun, arg_0);
        }
        Object lengthFun = this.visitor.visitCommonexpr(ctx.commonexpr(2));
        return arg_0 -> this.lambda$runSubstring$12(ctx, (Function)stringFun, (Function)startPosFun, (Function)lengthFun, arg_0);
    }

    private Function<ResourceValueFilterInputHolder, Object> runDateMethod(ParserRuleContext ctx) {
        Function<Temporal, Object> operation;
        ODataFilterParser.CommonexprContext subExpr = (ODataFilterParser.CommonexprContext)ctx.getChild(ODataFilterParser.CommonexprContext.class, 0);
        Object targetExpr = this.visitor.visitCommonexpr(subExpr);
        switch (ctx.getRuleIndex()) {
            case 74: {
                operation = t -> t.get(ChronoField.YEAR);
                break;
            }
            case 75: {
                operation = t -> t.get(ChronoField.MONTH_OF_YEAR);
                break;
            }
            case 76: {
                operation = t -> t.get(ChronoField.DAY_OF_MONTH);
                break;
            }
            case 77: {
                operation = t -> t.get(ChronoField.HOUR_OF_DAY);
                break;
            }
            case 78: {
                operation = t -> t.get(ChronoField.MINUTE_OF_HOUR);
                break;
            }
            case 79: {
                operation = t -> t.get(ChronoField.SECOND_OF_MINUTE);
                break;
            }
            case 80: {
                operation = t -> t.get(ChronoField.NANO_OF_SECOND);
                break;
            }
            case 82: {
                operation = o -> {
                    if (o instanceof Instant) {
                        return ((Instant)o).atOffset(ZoneOffset.UTC).toLocalDate();
                    }
                    return (LocalDate)o;
                };
                break;
            }
            case 83: {
                operation = t -> {
                    if (t instanceof OffsetDateTime) {
                        return ((OffsetDateTime)t).toLocalTime();
                    }
                    if (t instanceof LocalTime) {
                        return (LocalTime)t;
                    }
                    if (t instanceof Instant) {
                        return OffsetDateTime.ofInstant((Instant)t, ZoneOffset.UTC).toLocalTime();
                    }
                    throw new InvalidResultTypeException("Can't extract time", "datetime, time or instant", t);
                };
                break;
            }
            case 84: {
                operation = t -> {
                    if (t instanceof OffsetDateTime) {
                        return ((OffsetDateTime)t).getOffset().getTotalSeconds() / 60;
                    }
                    return 0;
                };
                break;
            }
            default: {
                throw new UnsupportedRuleException("Unsupported date method call", this.parser, ctx);
            }
        }
        return arg_0 -> MethodCallExprVisitor.lambda$runDateMethod$23((Function)targetExpr, operation, arg_0);
    }

    private Function<ResourceValueFilterInputHolder, Object> runMathOps(ParserRuleContext ctx) {
        Function<Number, Integer> operation;
        ODataFilterParser.CommonexprContext subExpr = (ODataFilterParser.CommonexprContext)ctx.getChild(ODataFilterParser.CommonexprContext.class, 0);
        Object targetExpr = this.visitor.visitCommonexpr(subExpr);
        switch (ctx.getRuleIndex()) {
            case 88: {
                operation = n -> (int)Math.round(n.doubleValue());
                break;
            }
            case 89: {
                operation = n -> (int)Math.floor(n.doubleValue());
                break;
            }
            case 90: {
                operation = n -> (int)Math.ceil(n.doubleValue());
                break;
            }
            default: {
                throw new RuntimeException("Unsupported math method: " + this.parser.getRuleNames()[ctx.getRuleIndex()]);
            }
        }
        return arg_0 -> this.lambda$runMathOps$27(ctx, (Function)targetExpr, operation, arg_0);
    }

    private Function<ResourceValueFilterInputHolder, Object> runGeoLength(ParserRuleContext ctx) {
        SpatialContext spatialContext = SpatialContext.GEO;
        ODataFilterParser.CommonexprContext subExpr = (ODataFilterParser.CommonexprContext)ctx.getChild(ODataFilterParser.CommonexprContext.class, 0);
        Object exprFun = this.visitor.visitCommonexpr(subExpr);
        return arg_0 -> this.lambda$runGeoLength$28(ctx, (Function)exprFun, spatialContext, arg_0);
    }

    private Point spatialPoint(ShapeFactory shpFactory, org.eclipse.sensinact.gateway.geojson.Point geoPoint) {
        return this.spatialPoint(shpFactory, geoPoint.coordinates);
    }

    private Point spatialPoint(ShapeFactory shpFactory, Coordinates geoCoords) {
        return shpFactory.pointLatLon(geoCoords.latitude, geoCoords.longitude);
    }

    private Function<ResourceValueFilterInputHolder, Object> runGeoDistance(ParserRuleContext ctx) {
        SpatialContext spatialContext = SpatialContext.GEO;
        ShapeFactory shpFactory = spatialContext.getShapeFactory();
        ODataFilterParser.CommonexprContext leftExpr = (ODataFilterParser.CommonexprContext)ctx.getChild(ODataFilterParser.CommonexprContext.class, 0);
        ODataFilterParser.CommonexprContext rightExpr = (ODataFilterParser.CommonexprContext)ctx.getChild(ODataFilterParser.CommonexprContext.class, 1);
        Object leftFun = this.visitor.visitCommonexpr(leftExpr);
        Object rightFun = this.visitor.visitCommonexpr(rightExpr);
        return arg_0 -> this.lambda$runGeoDistance$29(ctx, (Function)leftFun, (Function)rightFun, spatialContext, shpFactory, arg_0);
    }

    private /* synthetic */ Object lambda$runGeoDistance$29(ParserRuleContext ctx, Function leftFun, Function rightFun, SpatialContext spatialContext, ShapeFactory shpFactory, ResourceValueFilterInputHolder x) {
        org.eclipse.sensinact.gateway.geojson.Point left = this.convert(ctx, leftFun.apply(x), org.eclipse.sensinact.gateway.geojson.Point.class, false, "left");
        org.eclipse.sensinact.gateway.geojson.Point right = this.convert(ctx, rightFun.apply(x), org.eclipse.sensinact.gateway.geojson.Point.class, false, "right");
        return spatialContext.calcDistance(this.spatialPoint(shpFactory, left), this.spatialPoint(shpFactory, right));
    }

    private /* synthetic */ Object lambda$runGeoLength$28(ParserRuleContext ctx, Function exprFun, SpatialContext spatialContext, ResourceValueFilterInputHolder x) {
        GeoJsonObject obj = this.convert(ctx, exprFun.apply(x), GeoJsonObject.class, false, "line");
        ShapeFactory shpFactory = spatialContext.getShapeFactory();
        ArrayList<Point> allPoints = new ArrayList<Point>();
        if (obj.type == GeoJsonType.LineString) {
            List allCoordinates = ((LineString)obj).coordinates;
            if (allCoordinates == null) {
                throw new InvalidResultTypeException("Null coordinates given to geo.length");
            }
            for (Coordinates coordinates : allCoordinates) {
                allPoints.add(shpFactory.pointLatLon(coordinates.latitude, coordinates.longitude));
            }
        } else {
            throw new InvalidResultTypeException("Unsupported input for geo.length", "geography linestring", obj);
        }
        DistanceCalculator distCalc = spatialContext.getDistCalc();
        double length = 0.0;
        Point previousPoint = null;
        for (Point nextPoint : allPoints) {
            if (previousPoint == null) {
                previousPoint = nextPoint;
                continue;
            }
            double arcLength = distCalc.distance(previousPoint, nextPoint);
            double mLength = DistanceUtils.degrees2Dist((double)arcLength, (double)6371008.7714);
            length += mLength;
            previousPoint = nextPoint;
        }
        return length;
    }

    private /* synthetic */ Object lambda$runMathOps$27(ParserRuleContext ctx, Function targetExpr, Function operation, ResourceValueFilterInputHolder x) {
        Number res = this.convert(ctx, targetExpr.apply(x), Number.class, false, "number");
        return operation.apply(res);
    }

    private static /* synthetic */ Object lambda$runDateMethod$23(Function targetExpr, Function operation, ResourceValueFilterInputHolder x) {
        Object res = targetExpr.apply(x);
        if (res instanceof Temporal) {
            return operation.apply((Temporal)res);
        }
        throw new InvalidResultTypeException("Can't execute date method", "temporal", res);
    }

    private /* synthetic */ Object lambda$runSubstring$12(ODataFilterParser.SubstringmethodcallexprContext ctx, Function stringFun, Function startPosFun, Function lengthFun, ResourceValueFilterInputHolder x) {
        String string = this.convert(ctx, stringFun.apply(x), String.class, false, "string");
        Integer startPos = this.convert(ctx, startPosFun.apply(x), Integer.class, false, "start");
        Integer length = this.convert(ctx, lengthFun.apply(x), Integer.class, false, "length");
        int endPos = startPos + length;
        return string.substring(startPos, endPos);
    }

    private /* synthetic */ Object lambda$runSubstring$11(ODataFilterParser.SubstringmethodcallexprContext ctx, Function stringFun, Function startPosFun, ResourceValueFilterInputHolder x) {
        String string = this.convert(ctx, stringFun.apply(x), String.class, false, "string");
        Integer startPos = this.convert(ctx, startPosFun.apply(x), Integer.class, false, "start");
        return string.substring(startPos);
    }

    private /* synthetic */ Object lambda$runDualString$10(ParserRuleContext ctx, Function leftFun, Function rightFun, BiFunction operation, ResourceValueFilterInputHolder x) {
        String left = this.convert(ctx, leftFun.apply(x), String.class, false, "arg1");
        String right = this.convert(ctx, rightFun.apply(x), String.class, false, "arg2");
        return operation.apply(left, right);
    }

    private static /* synthetic */ Object lambda$runSingleString$7(Function targetExpr, Function operation, ResourceValueFilterInputHolder x) {
        Object res = targetExpr.apply(x);
        if (res instanceof String) {
            return operation.apply((String)res);
        }
        throw new InvalidResultTypeException("Error calling string method", "string", res);
    }
}

