/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.UnsupportedRuleException;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths.ObservationPathHandler;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths.ObservedPropertyPathHandler;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths.PathUtils;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths.SensorPathHandler;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths.ThingPathHandler;

public class DatastreamPathHandler {
    private final ProviderSnapshot provider;
    private final ResourceSnapshot resource;
    private final Map<String, Function<String, Object>> subPartHandlers = Map.of("observations", this::subObservations, "observedproperty", this::subObservedProperty, "sensor", this::subSensor, "thing", this::subThing);

    public DatastreamPathHandler(ProviderSnapshot provider, ResourceSnapshot resource) {
        this.provider = provider;
        this.resource = resource;
    }

    public Object handle(String path) {
        String[] parts = path.toLowerCase().split("/");
        if (parts.length == 1) {
            switch (parts[0]) {
                case "id": {
                    return String.join((CharSequence)"~", this.provider.getName(), this.resource.getService().getName(), this.resource.getName());
                }
            }
            return PathUtils.getResourceLevelField(this.provider, this.resource, parts[0]);
        }
        Function<String, Object> handler = this.subPartHandlers.get(parts[0]);
        if (handler == null) {
            throw new UnsupportedRuleException("Unsupported path: " + path);
        }
        return handler.apply(String.join((CharSequence)"/", Arrays.copyOfRange(parts, 1, parts.length)));
    }

    private Object subObservations(String path) {
        return new ObservationPathHandler(this.provider, this.resource).handle(path);
    }

    private Object subObservedProperty(String path) {
        return new ObservedPropertyPathHandler(this.provider, this.resource).handle(path);
    }

    private Object subSensor(String path) {
        return new SensorPathHandler(this.provider, this.resource).handle(path);
    }

    private Object subThing(String path) {
        return new ThingPathHandler(this.provider, List.of(this.resource)).handle(path);
    }
}

