/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.ldap.antlr.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceValueFilter;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.AbstractCriterion;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.Constants;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.IStringValue;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.LdapComparator;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.PureString;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.SensiNactPath;

public class CriterionResourceOperator
extends AbstractCriterion {
    private static final double EPSILON = 1.0E-4;
    private final SensiNactPath rcPath;
    private final Object expected;
    private final LdapComparator operator;
    private final boolean isNumericValue;
    private final boolean isBooleanValue;
    private final boolean isPresence;

    public CriterionResourceOperator(SensiNactPath rcPath, Object value, LdapComparator operator) {
        this.rcPath = rcPath;
        this.expected = value;
        this.operator = operator;
        this.isNumericValue = this.expected instanceof Number;
        this.isBooleanValue = this.expected instanceof Boolean;
        this.isPresence = this.expected == Constants.ANY;
    }

    public String toString() {
        String content = String.format("(%s%s%s)", new Object[]{this.rcPath, this.operator, this.expected});
        if (this.isNegative()) {
            content = String.format("(!%s)", content);
        }
        return content;
    }

    private boolean testNumericValue(Number otherNumber) {
        double testedValue = otherNumber.doubleValue();
        double expectedValue = ((Number)this.expected).doubleValue();
        switch (this.operator) {
            case EQUAL: {
                return expectedValue == testedValue;
            }
            case APPROX: {
                return Math.abs(expectedValue - testedValue) < 1.0E-4;
            }
            case GREATER_EQ: {
                return testedValue >= expectedValue;
            }
            case LESS_EQ: {
                return testedValue <= expectedValue;
            }
        }
        return false;
    }

    private boolean testBooleanValue(Object testedValue) {
        if (testedValue instanceof Boolean) {
            return this.expected.equals(testedValue);
        }
        if (testedValue instanceof Number) {
            return this.expected.equals(((Number)testedValue).doubleValue() != 0.0);
        }
        return false;
    }

    private boolean testStringValue(String testedValue) {
        String strTestedValue = testedValue;
        IStringValue expectedValue = this.expected instanceof IStringValue ? (IStringValue)this.expected : new PureString(String.valueOf(this.expected));
        switch (this.operator) {
            case EQUAL: {
                return expectedValue.matches(strTestedValue, false);
            }
            case APPROX: {
                return expectedValue.matches(strTestedValue.strip(), true);
            }
            case GREATER_EQ: {
                if (!expectedValue.isRegex()) {
                    return strTestedValue.compareTo(expectedValue.getString()) >= 0;
                }
                return false;
            }
            case LESS_EQ: {
                if (!expectedValue.isRegex()) {
                    return strTestedValue.compareTo(expectedValue.getString()) <= 0;
                }
                return false;
            }
        }
        return false;
    }

    private boolean testInArray(Object testedValue) {
        int size = Array.getLength(testedValue);
        for (int i = 0; i < size; ++i) {
            if (!this.testValue(Array.get(testedValue, i))) continue;
            return true;
        }
        return false;
    }

    private boolean testInCollection(Collection<?> testedCollection) {
        for (Object object : testedCollection) {
            if (!this.testValue(object)) continue;
            return true;
        }
        return false;
    }

    private boolean testValue(Object rawValue) {
        if (rawValue == null) {
            return this.expected == null || Boolean.FALSE.equals(this.expected);
        }
        if (this.expected == null) {
            return false;
        }
        if (this.isPresence) {
            return true;
        }
        if (rawValue.getClass().isArray()) {
            return this.testInArray(rawValue);
        }
        if (rawValue instanceof Collection) {
            return this.testInCollection((Collection)rawValue);
        }
        if (this.isNumericValue && rawValue instanceof Number) {
            return this.testNumericValue((Number)rawValue);
        }
        if (this.isBooleanValue) {
            return this.testBooleanValue(rawValue);
        }
        return this.testStringValue(String.valueOf(rawValue));
    }

    @Override
    public ResourceValueFilter getResourceValueFilter() {
        boolean negative = this.isNegative();
        return (p, rs) -> rs.stream().anyMatch(r -> {
            if (!this.rcPath.accept((ResourceSnapshot)r)) {
                return false;
            }
            boolean test = r.getValue() == null || r.getValue().getTimestamp() == null ? false : this.testValue(r.getValue().getValue());
            if (negative) {
                return !test;
            }
            return test;
        });
    }
}

