/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.ws.impl;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import org.eclipse.jetty.websocket.server.JettyWebSocketCreator;
import org.eclipse.jetty.websocket.server.JettyWebSocketServerContainer;
import org.eclipse.jetty.websocket.server.JettyWebSocketServlet;
import org.eclipse.jetty.websocket.server.JettyWebSocketServletFactory;
import org.eclipse.sensinact.northbound.query.api.IQueryHandler;
import org.eclipse.sensinact.northbound.security.api.Authenticator;
import org.eclipse.sensinact.northbound.security.api.UserInfo;
import org.eclipse.sensinact.northbound.session.SensiNactSessionManager;
import org.eclipse.sensinact.northbound.ws.impl.WebSocketCreator;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.whiteboard.annotations.RequireHttpWhiteboard;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterPattern;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletAsyncSupported;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class, Filter.class}, configurationPid={"sensinact.northbound.websocket"})
@RequireHttpWhiteboard
@HttpWhiteboardServletPattern(value={"/ws/sensinact"})
@HttpWhiteboardFilterPattern(value={"/ws/sensinact"})
@HttpWhiteboardServletAsyncSupported
public class WebSocketJettyRegistrar
extends JettyWebSocketServlet
implements Filter {
    static final String SENSINACT_USER_INFO = "sensinact.user.info";
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketJettyRegistrar.class);
    private static final long serialVersionUID = 1L;
    @Reference
    SensiNactSessionManager sessionManager;
    @Reference
    IQueryHandler queryHandler;
    @Reference(policy=ReferencePolicy.DYNAMIC)
    private final Set<Authenticator> authenticators = new CopyOnWriteArraySet<Authenticator>();
    private WebSocketCreator sessionPool;
    private Config config;
    private final AtomicBoolean initCalled = new AtomicBoolean(false);
    private final CountDownLatch initComplete = new CountDownLatch(1);

    @Activate
    void activate(Config config) {
        this.config = config;
        this.sessionPool = new WebSocketCreator(this.sessionManager, this.queryHandler);
    }

    @Deactivate
    void stop() {
        this.sessionPool.close();
        this.sessionManager = null;
    }

    public void init() throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        if (this.initCalled.getAndSet(true)) {
            try {
                this.initComplete.await();
            }
            catch (InterruptedException e) {
                throw new ServletException((Throwable)e);
            }
        }
        try {
            ServletContext servletContext = this.getServletContext();
            ServletContextHandler contextHandler = ServletContextHandler.getServletContextHandler((ServletContext)servletContext, (String)"Jetty WebSocket init");
            WebSocketServerComponents.ensureWebSocketComponents((Server)contextHandler.getServer(), (ServletContext)servletContext);
            JettyWebSocketServerContainer.ensureContainer((ServletContext)servletContext);
            super.init();
        }
        finally {
            this.initComplete.countDown();
        }
        super.service((ServletRequest)new HttpServletRequestWrapper((HttpServletRequest)req){

            public ServletContext getServletContext() {
                return ContextHandler.getCurrentContext();
            }
        }, res);
    }

    protected void configure(JettyWebSocketServletFactory factory) {
        factory.setCreator((JettyWebSocketCreator)this.sessionPool);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String authHeader = req.getHeader("Authorization");
        if (authHeader == null) {
            if (!this.config.allow_anonymous()) {
                this.unauthorizedResponse(resp);
            } else {
                req.setAttribute(SENSINACT_USER_INFO, (Object)UserInfo.ANONYMOUS);
                chain.doFilter(request, response);
            }
        } else {
            String[] headerChunks = authHeader.split(" ", 2);
            if (headerChunks.length != 2) {
                resp.sendError(400);
            } else {
                String credential;
                String userid;
                Authenticator.Scheme authScheme;
                if ("Bearer".equals(headerChunks[0])) {
                    authScheme = Authenticator.Scheme.TOKEN;
                    userid = null;
                    credential = headerChunks[1];
                } else if ("Basic".equals(headerChunks[0])) {
                    authScheme = Authenticator.Scheme.USER_PASSWORD;
                    String cred = new String(Base64.getMimeDecoder().decode(headerChunks[1]), StandardCharsets.UTF_8);
                    String[] credChunks = cred.split(":", 2);
                    userid = credChunks[0];
                    credential = credChunks[1];
                } else {
                    authScheme = null;
                    userid = null;
                    credential = null;
                }
                Optional<UserInfo> user = Set.copyOf(this.authenticators).stream().filter(a -> a.getScheme() == authScheme).map(a -> this.tryAuth((Authenticator)a, userid, credential)).filter(u -> u != null).findFirst();
                if (user.isEmpty()) {
                    this.unauthorizedResponse(resp);
                } else {
                    req.setAttribute(SENSINACT_USER_INFO, (Object)user.get());
                    chain.doFilter(request, response);
                }
            }
        }
    }

    private void unauthorizedResponse(HttpServletResponse response) throws IOException {
        Set<Authenticator> authenticators = Set.copyOf(this.authenticators);
        if (authenticators.isEmpty()) {
            response.sendError(503);
        } else {
            response.setHeader("WWW-Authenticate", this.getAuthHeader(authenticators));
            response.sendError(401);
        }
    }

    private String getAuthHeader(Collection<Authenticator> authenticators) {
        return authenticators.stream().map(a -> String.format("%s realm=%s", a.getScheme().getHttpScheme(), a.getRealm())).collect(Collectors.joining(", "));
    }

    private UserInfo tryAuth(Authenticator a, String user, String credential) {
        UserInfo ui = null;
        try {
            ui = a.authenticate(user, credential);
        }
        catch (Exception e) {
            LOG.warn("Failed to authenticate user {}", (Object)user, (Object)e);
        }
        return ui;
    }

    static @interface Config {
        public boolean allow_anonymous() default false;
    }
}

