/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.query.dto.result.jackson;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.sensinact.northbound.query.api.EResultType;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseDescribeProviderDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseDescribeResourceDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseDescribeServiceDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseGetDTO;
import org.eclipse.sensinact.northbound.query.dto.result.ResponseSetDTO;
import org.eclipse.sensinact.northbound.query.dto.result.SubResult;
import org.eclipse.sensinact.northbound.query.dto.result.TypedResponse;

public class TypedResponseDeserializer
extends StdDeserializer<TypedResponse> {
    private static final long serialVersionUID = -2337413302718463311L;

    public TypedResponseDeserializer() {
        super(TypedResponse.class);
    }

    public TypedResponse<SubResult> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        EResultType resultType;
        SubResult response;
        JsonNode root = ctxt.readTree(p);
        JsonNode typeNode = root.get("type");
        if (typeNode == null || !typeNode.isTextual()) {
            ctxt.reportWrongTokenException((JsonDeserializer)this, JsonToken.VALUE_STRING, "Unable to find the type property to identify this typed response", new Object[0]);
        }
        String typeId = typeNode.asText();
        JsonNode responseNode = root.get("response");
        switch (typeId) {
            case "DESCRIBE_PROVIDER": {
                response = (SubResult)ctxt.readTreeAsValue(responseNode, ResponseDescribeProviderDTO.class);
                resultType = EResultType.DESCRIBE_PROVIDER;
                break;
            }
            case "DESCRIBE_SERVICE": {
                response = (SubResult)ctxt.readTreeAsValue(responseNode, ResponseDescribeServiceDTO.class);
                resultType = EResultType.DESCRIBE_SERVICE;
                break;
            }
            case "DESCRIBE_RESOURCE": {
                response = (SubResult)ctxt.readTreeAsValue(responseNode, ResponseDescribeResourceDTO.class);
                resultType = EResultType.DESCRIBE_RESOURCE;
                break;
            }
            case "GET_RESPONSE": {
                response = (SubResult)ctxt.readTreeAsValue(responseNode, ResponseGetDTO.class);
                resultType = EResultType.GET_RESPONSE;
                break;
            }
            case "SET_RESPONSE": {
                response = (SubResult)ctxt.readTreeAsValue(responseNode, ResponseSetDTO.class);
                resultType = EResultType.SET_RESPONSE;
                break;
            }
            case "ERROR": {
                Object response2 = null;
                EResultType resultType2 = EResultType.ERROR;
            }
            default: {
                throw ctxt.invalidTypeIdException(ctxt.getContextualType(), typeId, "Unrecognized type id - unable to identify a suitable SubResult type");
            }
        }
        TypedResponse<SubResult> tr = new TypedResponse<SubResult>(resultType);
        tr.response = response;
        Iterator fields = ((ObjectNode)root).fields();
        boolean hasStatus = false;
        boolean hasUri = false;
        block31: while (fields.hasNext()) {
            Map.Entry next = (Map.Entry)fields.next();
            switch ((String)next.getKey()) {
                case "type": 
                case "response": {
                    continue block31;
                }
                case "error": {
                    tr.error = (String)ctxt.readTreeAsValue((JsonNode)next.getValue(), String.class);
                    continue block31;
                }
                case "requestId": {
                    tr.requestId = (String)ctxt.readTreeAsValue((JsonNode)next.getValue(), String.class);
                    continue block31;
                }
                case "statusCode": {
                    Integer status = (Integer)ctxt.readTreeAsValue((JsonNode)next.getValue(), Integer.class);
                    if (status == null) {
                        throw ctxt.wrongTokenException(ctxt.getParser(), Integer.class, JsonToken.VALUE_NUMBER_INT, "The status code must be a number");
                    }
                    tr.statusCode = status;
                    hasStatus = true;
                    continue block31;
                }
                case "uri": {
                    tr.uri = (String)ctxt.readTreeAsValue((JsonNode)next.getValue(), String.class);
                    hasUri = true;
                    continue block31;
                }
            }
            if (ctxt.handleUnknownProperty(p, (JsonDeserializer)this, TypedResponse.class, (String)next.getKey())) continue;
            ctxt.reportPropertyInputMismatch(TypedResponse.class, (String)next.getKey(), "Unable to deserialize property {} for a TypedResponse", new Object[]{next.getKey()});
        }
        if (!hasStatus) {
            ctxt.reportPropertyInputMismatch(TypedResponse.class, "statusCode", "No status code was present for this TypedResponse", new Object[0]);
        }
        if (!hasUri) {
            ctxt.reportPropertyInputMismatch(TypedResponse.class, "uri", "No uri was present for this TypedResponse", new Object[0]);
        }
        return tr;
    }
}

