/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.push;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sensinact.core.push.DataUpdateException;

public class FailedUpdatesException
extends Exception {
    private static final long serialVersionUID = 558905737809687311L;
    private final List<DataUpdateException> failedUpdates;

    public FailedUpdatesException(DataUpdateException failedUpdate) {
        Objects.requireNonNull(failedUpdate);
        this.failedUpdates = List.of(failedUpdate);
        this.addSuppressed(failedUpdate);
    }

    public FailedUpdatesException(Stream<? extends DataUpdateException> failedUpdates) {
        Objects.requireNonNull(failedUpdates);
        this.failedUpdates = failedUpdates.collect(Collectors.toUnmodifiableList());
        this.failedUpdates.forEach(this::addSuppressed);
    }

    public List<DataUpdateException> getFailedUpdates() {
        return this.failedUpdates;
    }
}

