/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.stream.Stream;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.notification.LifecycleNotification;
import org.eclipse.sensinact.core.notification.ResourceMetaDataNotification;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.SensorthingsMapper;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers.DtoMapper;
import org.eclipse.sensinact.sensorthings.sensing.dto.Sensor;
import org.osgi.util.promise.Promise;

public class SensorsMapper
extends SensorthingsMapper<Sensor> {
    public SensorsMapper(String topicFilter, ObjectMapper mapper, GatewayThread thread) {
        super(topicFilter, mapper, thread);
    }

    @Override
    public Promise<Stream<Sensor>> toPayload(LifecycleNotification notification) {
        if (notification.resource != null && notification.status != LifecycleNotification.Status.RESOURCE_DELETED) {
            return this.getSensor(this.getResource(notification.provider, notification.service, notification.resource));
        }
        return this.emptyStream();
    }

    @Override
    public Promise<Stream<Sensor>> toPayload(ResourceMetaDataNotification notification) {
        return this.getSensor(this.getResource(notification.provider, notification.service, notification.resource));
    }

    protected Promise<Stream<Sensor>> getSensor(Promise<ResourceSnapshot> resourceSnapshot) {
        return this.decorate(resourceSnapshot.map(DtoMapper::toSensor));
    }

    @Override
    protected Class<Sensor> getPayloadType() {
        return Sensor.class;
    }
}

