/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.stream.Stream;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.notification.LifecycleNotification;
import org.eclipse.sensinact.core.notification.ResourceDataNotification;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.SensorthingsMapper;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers.DtoMapper;
import org.eclipse.sensinact.sensorthings.sensing.dto.Thing;
import org.osgi.util.promise.Promise;

public class ThingsMapper
extends SensorthingsMapper<Thing> {
    public ThingsMapper(String topicFilter, ObjectMapper mapper, GatewayThread thread) {
        super(topicFilter, mapper, thread);
    }

    @Override
    public Promise<Stream<Thing>> toPayload(LifecycleNotification notification) {
        if (notification.service == null && notification.status != LifecycleNotification.Status.PROVIDER_DELETED) {
            return this.getThing(notification.provider);
        }
        return this.emptyStream();
    }

    @Override
    public Promise<Stream<Thing>> toPayload(ResourceDataNotification notification) {
        if ("admin".equals(notification.service) && ("friendlyName".equals(notification.resource) || "description".equals(notification.resource))) {
            return this.getThing(notification.provider);
        }
        return this.emptyStream();
    }

    private Promise<Stream<Thing>> getThing(String id) {
        return this.decorate(this.getProvider(id).map(DtoMapper::toThing));
    }

    @Override
    protected Class<Thing> getPayloadType() {
        return Thing.class;
    }
}

