/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.whiteboard.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sensinact.core.annotation.dto.NullAction;
import org.eclipse.sensinact.core.annotation.verb.ACT;
import org.eclipse.sensinact.core.annotation.verb.GET;
import org.eclipse.sensinact.core.annotation.verb.SET;
import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.metrics.IMetricTimer;
import org.eclipse.sensinact.core.metrics.IMetricsManager;
import org.eclipse.sensinact.core.model.Model;
import org.eclipse.sensinact.core.model.Resource;
import org.eclipse.sensinact.core.model.ResourceBuilder;
import org.eclipse.sensinact.core.model.ResourceType;
import org.eclipse.sensinact.core.model.SensinactModelManager;
import org.eclipse.sensinact.core.model.Service;
import org.eclipse.sensinact.core.model.nexus.ModelNexus;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.eclipse.sensinact.core.whiteboard.WhiteboardAct;
import org.eclipse.sensinact.core.whiteboard.WhiteboardActDescription;
import org.eclipse.sensinact.core.whiteboard.WhiteboardGet;
import org.eclipse.sensinact.core.whiteboard.WhiteboardHandler;
import org.eclipse.sensinact.core.whiteboard.WhiteboardResourceDescription;
import org.eclipse.sensinact.core.whiteboard.WhiteboardSet;
import org.eclipse.sensinact.core.whiteboard.impl.AbstractResourceMethod;
import org.eclipse.sensinact.core.whiteboard.impl.ActMethod;
import org.eclipse.sensinact.core.whiteboard.impl.GetMethod;
import org.eclipse.sensinact.core.whiteboard.impl.RegistryKey;
import org.eclipse.sensinact.core.whiteboard.impl.SetMethod;
import org.eclipse.sensinact.core.whiteboard.impl.WhiteboardContext;
import org.osgi.util.promise.Deferred;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensinactWhiteboard {
    private static final Logger LOG = LoggerFactory.getLogger(ModelNexus.class);
    private final GatewayThread gatewayThread;
    private final IMetricsManager metrics;
    private final Map<Long, List<RegistryKey>> serviceIdToActMethods = new ConcurrentHashMap<Long, List<RegistryKey>>();
    private final Map<Long, List<RegistryKey>> serviceIdToGetMethods = new ConcurrentHashMap<Long, List<RegistryKey>>();
    private final Map<Long, List<RegistryKey>> serviceIdToSetMethods = new ConcurrentHashMap<Long, List<RegistryKey>>();
    private final Map<RegistryKey, List<WhiteboardContext<WhiteboardAct<?>>>> actMethodRegistry = new ConcurrentHashMap();
    private final Map<RegistryKey, List<WhiteboardContext<WhiteboardGet<?>>>> getMethodRegistry = new ConcurrentHashMap();
    private final Map<RegistryKey, List<WhiteboardContext<WhiteboardSet<?>>>> setMethodRegistry = new ConcurrentHashMap();
    private final PromiseFactory promiseFactory = new PromiseFactory((Executor)Executors.newCachedThreadPool(r -> new Thread(r, "Eclipse sensiNact Whiteboard Worker")), Executors.newScheduledThreadPool(5, r -> new Thread(r, "Eclipse sensiNact Whiteboard Scheduler")));
    private final Map<RegistryKey, Promise<TimedValue<?>>> concurrentGetHolder = new ConcurrentHashMap();

    public SensinactWhiteboard(GatewayThread gatewayThread, IMetricsManager metrics) {
        this.gatewayThread = gatewayThread;
        this.metrics = metrics;
    }

    private RegistryKey keyFromServiceProperties(Map<String, Object> props) {
        return new RegistryKey((String)props.get("sensiNact.whiteboard.modelPackageUri"), (String)props.get("sensiNact.whiteboard.model"), (String)props.get("sensiNact.whiteboard.service"), (String)props.get("sensiNact.whiteboard.resource"));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addWhiteboardHandler(WhiteboardHandler handler, Map<String, Object> props) {
        WhiteboardContext<WhiteboardAct> ctx;
        Long serviceId = (Long)props.get("service.id");
        Set<String> providers = this.toSet(props.get("sensiNact.provider.name"));
        RegistryKey key = this.keyFromServiceProperties(props);
        boolean isGet = handler instanceof WhiteboardGet;
        boolean isSet = handler instanceof WhiteboardSet;
        boolean isValue = isGet || isSet;
        boolean isAct = handler instanceof WhiteboardAct;
        if (!isAct && !isValue) {
            LOG.error("Whiteboard handler service {} for {} doesn't provider meaningful interfaces", (Object)serviceId, (Object)key);
            return;
        }
        Boolean createResource = (Boolean)props.get("sensiNact.whiteboard.create");
        if (createResource != null && createResource.booleanValue()) {
            WhiteboardResourceDescription description;
            if (isAct && isValue) {
                LOG.error("Can't create a resource if its handler is both made for action and value resources");
                return;
            }
            if (isValue) {
                if (!(handler instanceof WhiteboardResourceDescription)) {
                    LOG.error("Can't create resource as whiteboard handler is not a WhiteboardResourceDescription");
                    return;
                }
                description = (WhiteboardResourceDescription)handler;
                this.makeResource(key, type -> type != ResourceType.ACTION, b -> {
                    ResourceBuilder builder = b.withType(description.getResourceType()).withGetter().withGetterCache(description.getCacheDuration()).withSetter();
                    builder.buildAll();
                });
            } else if (isAct) {
                if (!(handler instanceof WhiteboardActDescription)) {
                    LOG.error("Can't create action resource as whiteboard handler is not a WhiteboardActDescription");
                    return;
                }
                description = (WhiteboardActDescription)handler;
                this.makeResource(key, type -> type == ResourceType.ACTION, arg_0 -> SensinactWhiteboard.lambda$addWhiteboardHandler$5((WhiteboardActDescription)description, arg_0));
            }
        }
        if (isAct) {
            ctx = new WhiteboardContext<WhiteboardAct>(serviceId, (WhiteboardAct)handler, providers);
            this.storeWhiteboardHandler(ctx, key, this.serviceIdToActMethods, this.actMethodRegistry);
        }
        if (isGet) {
            ctx = new WhiteboardContext<WhiteboardGet>(serviceId, (WhiteboardGet)handler, providers);
            this.storeWhiteboardHandler(ctx, key, this.serviceIdToGetMethods, this.getMethodRegistry);
        }
        if (isSet) {
            ctx = new WhiteboardContext<WhiteboardSet>(serviceId, (WhiteboardSet)handler, providers);
            this.storeWhiteboardHandler(ctx, key, this.serviceIdToSetMethods, this.setMethodRegistry);
        }
    }

    public void updatedWhiteboardHandler(WhiteboardHandler handler, Map<String, Object> props) {
        Long serviceId = (Long)props.get("service.id");
        Set<String> providers = this.toSet(props.get("sensiNact.provider.name"));
        this.updateServiceReferences("act", serviceId, providers, this.serviceIdToActMethods, this.actMethodRegistry);
        this.updateServiceReferences("get", serviceId, providers, this.serviceIdToGetMethods, this.getMethodRegistry);
        this.updateServiceReferences("set", serviceId, providers, this.serviceIdToSetMethods, this.setMethodRegistry);
    }

    public void removeWhiteboardHandler(WhiteboardHandler handler, Map<String, Object> props) {
        Long serviceId = (Long)props.get("service.id");
        this.clearServiceReferences(serviceId, this.serviceIdToActMethods, this.actMethodRegistry);
        this.clearServiceReferences(serviceId, this.serviceIdToGetMethods, this.getMethodRegistry);
        this.clearServiceReferences(serviceId, this.serviceIdToSetMethods, this.setMethodRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends WhiteboardHandler> void storeWhiteboardHandler(WhiteboardContext<T> ctx, RegistryKey key, Map<Long, List<RegistryKey>> keyRegistry, Map<RegistryKey, List<WhiteboardContext<T>>> methodRegistry) {
        Map<Object, List<Object>> map = keyRegistry;
        synchronized (map) {
            keyRegistry.merge(ctx.serviceId, List.of(key), (a, b) -> Stream.concat(a.stream(), b.stream()).collect(Collectors.toList()));
        }
        map = methodRegistry;
        synchronized (map) {
            methodRegistry.merge(key, List.of(ctx), (a, b) -> Stream.concat(b.stream(), a.stream()).collect(Collectors.toList()));
        }
    }

    public void addWhiteboardService(Object service, Map<String, Object> props) {
        Long serviceId = (Long)props.get("service.id");
        Set<String> providers = this.toSet(props.get("sensiNact.provider.name"));
        Class<?> clz = service.getClass();
        List<Method> actMethods = this.findMethods(clz, List.of(ACT.class, ACT.ACTs.class));
        this.handleActMethods(serviceId, service, providers, actMethods);
        List<Method> getMethods = this.findMethods(clz, List.of(GET.class, GET.GETs.class));
        List<Method> setMethods = this.findMethods(clz, List.of(SET.class, SET.SETs.class));
        this.handlePullMethods(serviceId, service, providers, getMethods, setMethods);
    }

    private List<Method> findMethods(Class<?> clz, Collection<Class<? extends Annotation>> annotations) {
        return Stream.concat(Arrays.stream(clz.getMethods()), Arrays.stream(clz.getInterfaces()).flatMap(c -> Arrays.stream(c.getMethods()))).filter(m -> annotations.stream().anyMatch(a -> m.isAnnotationPresent((Class<? extends Annotation>)a))).collect(Collectors.toList());
    }

    private <T extends WhiteboardHandler> void updateServiceReferences(String kind, Long serviceId, Set<String> providers, Map<Long, List<RegistryKey>> serviceKeysHolder, Map<RegistryKey, List<WhiteboardContext<T>>> methodRegistry) {
        for (RegistryKey key : serviceKeysHolder.getOrDefault(serviceId, List.of())) {
            methodRegistry.computeIfPresent(key, (x, v) -> {
                for (int i = 0; i < v.size(); ++i) {
                    WhiteboardContext context = (WhiteboardContext)v.get(i);
                    if (!context.serviceId.equals(serviceId)) continue;
                    if (providers.equals(context.providers) || !providers.isEmpty() && !context.providers.isEmpty()) {
                        LOG.debug("The update to the whiteboard {} service {} did not change the resource {}", new Object[]{kind, serviceId, key});
                        return v;
                    }
                    LOG.debug("The update to the whiteboard {} service {} changed the resource {} from providers {} to providers {}", new Object[]{kind, serviceId, key, context.providers, providers});
                    ArrayList result = new ArrayList(v.size());
                    result.addAll(v.subList(0, i));
                    result.addAll(v.subList(i + 1, v.size()));
                    result.add(context);
                    return result.isEmpty() ? null : result;
                }
                LOG.warn("No match for the act method {} was found for service {}", (Object)key, (Object)serviceId);
                return v;
            });
        }
    }

    public void updatedWhiteboardService(Object service, Map<String, Object> props) {
        Long serviceId = (Long)props.get("service.id");
        Set<String> providers = this.toSet(props.get("sensiNact.provider.name"));
        this.updateServiceReferences("act", serviceId, providers, this.serviceIdToActMethods, this.actMethodRegistry);
        this.updateServiceReferences("get", serviceId, providers, this.serviceIdToGetMethods, this.getMethodRegistry);
        this.updateServiceReferences("set", serviceId, providers, this.serviceIdToSetMethods, this.setMethodRegistry);
    }

    private <T extends WhiteboardHandler> void clearServiceReferences(Long serviceId, Map<Long, List<RegistryKey>> serviceKeysHolder, Map<RegistryKey, List<WhiteboardContext<T>>> methodRegistry) {
        List<RegistryKey> keys = serviceKeysHolder.remove(serviceId);
        if (keys != null) {
            for (RegistryKey key : keys) {
                methodRegistry.computeIfPresent(key, (x, v) -> {
                    List l = v.stream().filter(a -> !serviceId.equals(a.serviceId)).collect(Collectors.toList());
                    if (l.equals(v)) {
                        return v;
                    }
                    return l.isEmpty() ? null : l;
                });
            }
        }
    }

    public void removeWhiteboardService(Object service, Map<String, Object> props) {
        Long serviceId = (Long)props.get("service.id");
        this.clearServiceReferences(serviceId, this.serviceIdToActMethods, this.actMethodRegistry);
        this.clearServiceReferences(serviceId, this.serviceIdToGetMethods, this.getMethodRegistry);
        this.clearServiceReferences(serviceId, this.serviceIdToSetMethods, this.setMethodRegistry);
    }

    private Set<String> toSet(Object object) {
        Set<String> set;
        if (object == null) {
            set = Collections.emptySet();
        } else {
            if (object.getClass().isArray()) {
                int length = Array.getLength(object);
                HashSet<String> set2 = new HashSet<String>(length);
                for (int i = 0; i < length; ++i) {
                    set2.addAll(this.toSet(Array.get(object, i)));
                }
                return set2;
            }
            set = object instanceof Collection ? ((Collection)object).stream().flatMap(o -> this.toSet(o).stream()).collect(Collectors.toSet()) : Collections.singleton(object.toString());
        }
        return set;
    }

    private void handleActMethods(Long serviceId, Object service, Set<String> providers, List<Method> actMethods) {
        for (Method actMethod : actMethods) {
            ActMethod am = new ActMethod(actMethod, service, serviceId, providers);
            WhiteboardContext<ActMethod> ctx = new WhiteboardContext<ActMethod>(serviceId, am);
            if (actMethod.isAnnotationPresent(ACT.class)) {
                ACT act = actMethod.getAnnotation(ACT.class);
                this.processActMethod(ctx, act);
            }
            if (!actMethod.isAnnotationPresent(ACT.ACTs.class)) continue;
            ACT.ACTs acts = actMethod.getAnnotation(ACT.ACTs.class);
            for (ACT act : acts.value()) {
                this.processActMethod(ctx, act);
            }
        }
    }

    private void handlePullMethods(Long serviceId, Object service, Set<String> providers, List<Method> getMethods, List<Method> setMethods) {
        LinkedHashSet resources = new LinkedHashSet();
        HashMap listGetMethods = new HashMap();
        HashMap listSetMethods = new HashMap();
        for (Method annotatedMethod : getMethods) {
            HashMap cachedMethod = new HashMap();
            Stream getStream = Optional.ofNullable(annotatedMethod.getAnnotation(GET.class)).map(Stream::of).orElse(Stream.empty());
            Stream getsStream = Optional.ofNullable(annotatedMethod.getAnnotation(GET.GETs.class)).map(GET.GETs::value).map(Arrays::stream).orElse(Stream.empty());
            Stream.concat(getStream, getsStream).forEach(get -> {
                RegistryKey key = new RegistryKey(get.modelPackageUri(), get.model(), get.service(), get.resource());
                resources.add(key);
                GetMethod getMethod = cachedMethod.computeIfAbsent(get.onNull(), onNull -> new GetMethod(annotatedMethod, service, serviceId, providers, (NullAction)onNull));
                listGetMethods.computeIfAbsent(key, k -> new ArrayList()).add(new MethodHolder<GET, GetMethod>((GET)get, new WhiteboardContext<GetMethod>(serviceId, getMethod, providers)));
            });
        }
        for (Method annotatedMethod : setMethods) {
            SetMethod setMethod = new SetMethod(annotatedMethod, service, serviceId, providers);
            Stream setStream = Optional.ofNullable(annotatedMethod.getAnnotation(SET.class)).map(Stream::of).orElse(Stream.empty());
            Stream setsStream = Optional.ofNullable(annotatedMethod.getAnnotation(SET.SETs.class)).map(SET.SETs::value).map(Arrays::stream).orElse(Stream.empty());
            Stream.concat(setStream, setsStream).forEach(set -> {
                RegistryKey key = new RegistryKey(set.modelPackageUri(), set.model(), set.service(), set.resource());
                resources.add(key);
                MethodHolder<SET, SetMethod> setHolder = new MethodHolder<SET, SetMethod>((SET)set, new WhiteboardContext<SetMethod>(serviceId, setMethod, providers));
                listSetMethods.computeIfAbsent(key, k -> new ArrayList()).add(setHolder);
            });
        }
        for (RegistryKey key : resources) {
            boolean hasSet;
            List definedGetMethods = (List)listGetMethods.get(key);
            List definedSetMethods = (List)listSetMethods.get(key);
            boolean hasGet = definedGetMethods != null && !definedGetMethods.isEmpty();
            boolean bl = hasSet = definedSetMethods != null && !definedSetMethods.isEmpty();
            if (hasGet) {
                for (MethodHolder getHolder : definedGetMethods) {
                    this.processGetMethod(key, getHolder.rcMethod, (GET)getHolder.annotation, hasSet);
                }
            }
            if (!hasSet) continue;
            for (MethodHolder setHolder : definedSetMethods) {
                this.processSetMethod(key, setHolder.rcMethod, (SET)setHolder.annotation, hasGet);
            }
        }
    }

    private <M extends AbstractResourceMethod, T extends WhiteboardHandler> void processAnnotatedMethod(RegistryKey key, Predicate<ResourceType> validateResourceType, Consumer<ResourceBuilder<?, Object>> builderCaller, WhiteboardContext<M> ctx, Map<RegistryKey, List<WhiteboardContext<T>>> methodsRegistry, Map<Long, List<RegistryKey>> serviceIdRegistry) {
        serviceIdRegistry.merge(ctx.serviceId, List.of(key), (a, b) -> Stream.concat(a.stream(), b.stream()).collect(Collectors.toList()));
        Class comparableType = ctx.getType();
        methodsRegistry.merge(key, List.of(ctx), (k, v) -> {
            Stream stream;
            if (((AbstractResourceMethod)ctx.handler).isCatchAll()) {
                WhiteboardContext previous = (WhiteboardContext)k.get(k.size() - 1);
                if (comparableType.isAssignableFrom(previous.handler.getClass()) && ((AbstractResourceMethod)comparableType.cast(previous.handler)).isCatchAll()) {
                    LOG.warn("There are two catch all services {} and {} defined for GET resource {}", new Object[]{previous.serviceId, ctx.serviceId, key});
                }
                stream = Stream.concat(k.stream(), v.stream());
            } else {
                if (k.stream().anyMatch(a -> comparableType.isAssignableFrom(a.handler.getClass()) && ((AbstractResourceMethod)comparableType.cast(a.handler)).overlaps((AbstractResourceMethod)ctx.handler))) {
                    LOG.warn("There are overlapping services defined for GET resource {}: {}", (Object)key, (Object)ctx);
                }
                stream = Stream.concat(v.stream(), k.stream());
            }
            return stream.collect(Collectors.toList());
        });
        this.makeResource(key, validateResourceType, builderCaller);
    }

    private void makeResource(final RegistryKey key, final Predicate<ResourceType> validateResourceType, final Consumer<ResourceBuilder<?, Object>> builderCaller) {
        this.gatewayThread.execute((AbstractSensinactCommand)new AbstractSensinactCommand<Void>(){

            protected Promise<Void> call(SensinactDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory promiseFactory) {
                ResourceType type;
                ResourceBuilder builder = null;
                Resource resource = null;
                Model model = modelMgr.getModel(key.getModel());
                if (model == null) {
                    builder = modelMgr.createModel(key.getModelPackageUri(), key.getModel()).withService(key.getService()).withResource(key.getResource());
                } else {
                    Service service = (Service)model.getServices().get(key.getService());
                    if (service == null) {
                        builder = model.createService(key.getService()).withResource(key.getResource());
                    } else {
                        resource = (Resource)service.getResources().get(key.getResource());
                        if (resource == null) {
                            builder = service.createResource(key.getResource());
                        }
                    }
                }
                if (builder != null) {
                    builderCaller.accept(builder);
                } else if (resource != null && !validateResourceType.test(type = resource.getResourceType())) {
                    LOG.error("The resource {} in service {} already exists for the model {} as type {}", new Object[]{key.getResource(), key.getService(), key.getModel(), type});
                    return promiseFactory.failed((Throwable)new IllegalStateException("Updating resource of type " + type + " is not allowed"));
                }
                return promiseFactory.resolved(null);
            }
        });
    }

    private Class<?> getType(Class<?> methodReturnType, Class<?> givenType) {
        return givenType != null ? givenType : methodReturnType;
    }

    private void processActMethod(WhiteboardContext<ActMethod> ctx, ACT annotation) {
        RegistryKey key = new RegistryKey(annotation.modelPackageUri(), annotation.model(), annotation.service(), annotation.resource());
        this.processAnnotatedMethod(key, type -> type == ResourceType.ACTION, b -> b.withType(((ActMethod)ctx.handler).getReturnType()).withAction(((ActMethod)ctx.handler).getNamedParameterTypes()).buildAll(), ctx, this.actMethodRegistry, this.serviceIdToActMethods);
    }

    private void processGetMethod(RegistryKey key, WhiteboardContext<GetMethod> ctx, GET annotation, boolean hasSet) {
        this.processAnnotatedMethod(key, type -> type != ResourceType.ACTION, b -> {
            ResourceBuilder builder = b.withType(this.getType(((GetMethod)ctx.handler).getReturnType(), annotation.type())).withGetter().withGetterCache(Duration.of(annotation.cacheDuration(), annotation.cacheDurationUnit()));
            if (hasSet) {
                builder = builder.withSetter();
            }
            builder.buildAll();
        }, ctx, this.getMethodRegistry, this.serviceIdToGetMethods);
    }

    private void processSetMethod(RegistryKey key, WhiteboardContext<SetMethod> ctx, SET annotation, boolean hasGet) {
        this.processAnnotatedMethod(key, type -> type != ResourceType.ACTION, b -> {
            ResourceBuilder builder = b.withType(this.getType(((SetMethod)ctx.handler).getReturnType(), annotation.type())).withSetter();
            if (hasGet) {
                builder = builder.withGetter();
            }
            builder.buildAll();
        }, ctx, this.setMethodRegistry, this.serviceIdToSetMethods);
    }

    public Promise<Object> act(String modelPackageUri, String model, String provider, String service, String resource, Map<String, Object> arguments) {
        RegistryKey key = new RegistryKey(modelPackageUri, model, service, resource);
        Optional opt = this.lookupContext(key, provider, this.actMethodRegistry);
        if (opt.isEmpty()) {
            return this.promiseFactory.failed((Throwable)new NoSuchElementException(String.format("No suitable whiteboard handler for %s/%s/%s/%s", model, provider, service, resource)));
        }
        Deferred d = this.promiseFactory.deferred();
        WhiteboardContext ctx = opt.get();
        IMetricTimer overallTimer = this.metrics.withTimers(new String[]{"sensinact.whiteboard.act.request", "sensinact.whiteboard.act.request." + String.join((CharSequence)".", modelPackageUri, model, service, resource), "sensinact.whiteboard.act.request." + String.join((CharSequence)".", provider, service, resource)});
        this.promiseFactory.executor().execute(() -> {
            try (IMetricTimer timer = this.metrics.withTimers(new String[]{"sensinact.whiteboard.act.task", "sensinact.whiteboard.act.task." + String.join((CharSequence)".", modelPackageUri, model, service, resource), "sensinact.whiteboard.act.task." + String.join((CharSequence)".", provider, service, resource)});){
                Promise result = ((WhiteboardAct)ctx.handler).act(this.promiseFactory, modelPackageUri, model, provider, service, resource, arguments);
                if (result == null) {
                    d.fail((Throwable)new NullPointerException(String.format("Whiteboard action handler returned no promise for resource %s/%s/%s/%s", model, provider, service, resource)));
                } else {
                    d.resolveWith(result);
                }
            }
            catch (Exception e) {
                d.fail((Throwable)e);
            }
        });
        return d.getPromise().onResolve(() -> overallTimer.close());
    }

    private <T extends WhiteboardHandler> Optional<WhiteboardContext<T>> lookupContext(RegistryKey key, String provider, Map<RegistryKey, List<WhiteboardContext<T>>> registry) {
        Optional<Object> opt = Optional.empty();
        RegistryKey lookupKey = key;
        while ((opt = registry.getOrDefault(lookupKey, List.of()).stream().filter(a -> a.providers.isEmpty() || a.providers.contains(provider)).sorted((a, b) -> {
            if (a.providers.isEmpty()) {
                if (b.providers.isEmpty()) {
                    return 0;
                }
                return 1;
            }
            if (b.providers.isEmpty()) {
                return -1;
            }
            return Integer.compare(a.providers.size(), b.providers.size());
        }).findFirst()).isEmpty() && (lookupKey = lookupKey.levelUp()) != null) {
        }
        return opt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Promise<TimedValue<T>> pullValue(String modelPackageUri, String model, String provider, String service, String resource, Class<T> type, TimedValue<T> cachedValue, Consumer<TimedValue<T>> gatewayUpdate) {
        RegistryKey key = new RegistryKey(modelPackageUri, model, service, resource);
        Optional<WhiteboardContext<T>> opt = this.lookupContext(key, provider, this.getMethodRegistry);
        if (opt.isEmpty()) {
            return this.promiseFactory.failed((Throwable)new NoSuchElementException(String.format("No suitable whiteboard handler for %s/%s/%s/%s", model, provider, service, resource)));
        }
        WhiteboardContext<T> ctx = opt.get();
        Map<RegistryKey, Promise<TimedValue<?>>> map = this.concurrentGetHolder;
        synchronized (map) {
            Promise<TimedValue<?>> currentPromise = this.concurrentGetHolder.get(key);
            if (currentPromise != null) {
                return currentPromise.map(tv -> tv);
            }
            Deferred d = this.promiseFactory.deferred();
            IMetricTimer overallTimer = this.metrics.withTimers(new String[]{"sensinact.whiteboard.pull.request", "sensinact.whiteboard.pull.request." + String.join((CharSequence)".", modelPackageUri, model, service, resource), "sensinact.whiteboard.pull.request." + String.join((CharSequence)".", provider, service, resource)});
            this.promiseFactory.executor().execute(() -> {
                try (IMetricTimer timer = this.metrics.withTimers(new String[]{"sensinact.whiteboard.pull.task", "sensinact.whiteboard.pull.task." + String.join((CharSequence)".", modelPackageUri, model, service, resource), "sensinact.whiteboard.pull.task." + String.join((CharSequence)".", provider, service, resource)});){
                    d.resolveWith(((WhiteboardGet)ctx.handler).pullValue(this.promiseFactory, modelPackageUri, model, provider, service, resource, type, cachedValue));
                }
                catch (Exception e) {
                    d.fail((Throwable)e);
                }
            });
            Consumer<TimedValue<T>> coCall = v -> {
                try {
                    if (gatewayUpdate != null) {
                        gatewayUpdate.accept((TimedValue)v);
                    }
                }
                finally {
                    this.concurrentGetHolder.remove(key);
                }
            };
            Promise promise = d.getPromise().onResolve(() -> overallTimer.close());
            return this.runOnGateway(promise, coCall, cachedValue);
        }
    }

    public <T> Promise<TimedValue<T>> pushValue(String modelPackageUri, String model, String provider, String service, String resource, Class<T> type, TimedValue<T> cachedValue, TimedValue<T> newValue, Consumer<TimedValue<T>> gatewayUpdate) {
        RegistryKey key = new RegistryKey(modelPackageUri, model, service, resource);
        Optional<WhiteboardContext<T>> opt = this.lookupContext(key, provider, this.setMethodRegistry);
        if (opt.isEmpty()) {
            return this.promiseFactory.failed((Throwable)new NoSuchElementException(String.format("No suitable whiteboard handler for %s/%s/%s/%s", model, provider, service, resource)));
        }
        Deferred d = this.promiseFactory.deferred();
        WhiteboardContext<T> ctx = opt.get();
        IMetricTimer overallTimer = this.metrics.withTimers(new String[]{"sensinact.whiteboard.pull.request", "sensinact.whiteboard.pull.request." + String.join((CharSequence)".", modelPackageUri, model, service, resource), "sensinact.whiteboard.pull.request." + String.join((CharSequence)".", provider, service, resource)});
        this.promiseFactory.executor().execute(() -> {
            try (IMetricTimer timer = this.metrics.withTimers(new String[]{"sensinact.whiteboard.push.task", "sensinact.whiteboard.push.task." + String.join((CharSequence)".", modelPackageUri, model, service, resource), "sensinact.whiteboard.push.task." + String.join((CharSequence)".", provider, service, resource)});){
                d.resolveWith(((WhiteboardSet)ctx.handler).pushValue(this.promiseFactory, modelPackageUri, model, provider, service, resource, type, cachedValue, newValue));
            }
            catch (Exception e) {
                d.fail((Throwable)e);
            }
        });
        Promise promise = d.getPromise().onResolve(() -> overallTimer.close());
        return this.runOnGateway(promise, gatewayUpdate, cachedValue);
    }

    private <T> Promise<TimedValue<T>> runOnGateway(Promise<TimedValue<T>> promisedValue, final Consumer<TimedValue<T>> gatewayUpdate, final TimedValue<T> cachedValue) {
        PromiseFactory gatewayPromiseFactory = this.gatewayThread.getPromiseFactory();
        Deferred deferred = gatewayPromiseFactory.deferred();
        if (gatewayUpdate == null) {
            deferred.resolveWith(promisedValue);
        } else {
            promisedValue.onResolve(() -> {
                try {
                    Throwable t = promisedValue.getFailure();
                    if (t == null) {
                        final TimedValue value = (TimedValue)promisedValue.getValue();
                        deferred.resolveWith(this.gatewayThread.execute(new AbstractSensinactCommand<TimedValue<T>>(){

                            protected Promise<TimedValue<T>> call(SensinactDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory pf) {
                                try {
                                    gatewayUpdate.accept(value);
                                    return pf.resolved((Object)(value == null ? cachedValue : value));
                                }
                                catch (Exception e) {
                                    return pf.failed((Throwable)e);
                                }
                            }
                        }));
                    } else {
                        deferred.fail(t);
                    }
                }
                catch (InterruptedException e) {
                    deferred.fail((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    deferred.fail(e.getCause());
                }
            });
        }
        return deferred.getPromise();
    }

    private static /* synthetic */ void lambda$addWhiteboardHandler$5(WhiteboardActDescription description, ResourceBuilder b) {
        b.withType(description.getReturnType()).withAction(description.getNamedParameterTypes()).buildAll();
    }

    static final class MethodHolder<A extends Annotation, RM extends AbstractResourceMethod> {
        final A annotation;
        final WhiteboardContext<RM> rcMethod;

        public MethodHolder(A annotation, WhiteboardContext<RM> rcMethod) {
            this.annotation = annotation;
            this.rcMethod = rcMethod;
        }
    }
}

