/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.filters;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.sensinact.sensorthings.sensing.rest.filters.ExpansionSettingsImpl;

@Priority(value=5000)
public class ExpandFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    @Context
    Providers providers;

    private ObjectMapper getMapper() {
        return (ObjectMapper)this.providers.getContextResolver(ObjectMapper.class, MediaType.WILDCARD_TYPE).getContext(null);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        ExpansionSettingsImpl es = (ExpansionSettingsImpl)requestContext.getProperty("sensinact.sensorthings.expand");
        if (es == null || es.isEmpty()) {
            return;
        }
        JsonNode json = es.processExpansions(this.getMapper(), responseContext.getEntity());
        responseContext.setEntity((Object)json);
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        List fields = (List)requestContext.getUriInfo().getQueryParameters().getOrDefault((Object)"$expand", List.of());
        requestContext.setProperty("sensinact.sensorthings.expand", (Object)new ExpansionSettingsImpl(fields.stream().flatMap(s -> Arrays.stream(s.split(",")))));
    }
}

