/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.filters;

import jakarta.annotation.Priority;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;

@Priority(value=4003)
public class OrderByFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String ORDERBY_PROP = "org.eclipse.sensinact.sensorthings.sensing.rest.orderby";
    private static final Comparator<Comparable<Object>> BASE_COMPARATOR = Comparator.nullsFirst(Comparator.naturalOrder());

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Comparator comparator = (Comparator)requestContext.getProperty(ORDERBY_PROP);
        if (comparator == null) {
            return;
        }
        Object entity = responseContext.getEntity();
        if (entity instanceof ResultList) {
            ResultList resultList = (ResultList)entity;
            ArrayList sortedList = new ArrayList(resultList.value);
            sortedList.sort(comparator);
            resultList.value = List.copyOf(sortedList);
        }
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        List list = (List)requestContext.getUriInfo().getQueryParameters().getOrDefault((Object)"$orderby", List.of());
        try {
            Comparator comparator = list.stream().flatMap(s -> Arrays.stream(s.split(","))).map(this::toComparator).reduce(Comparator::thenComparing).orElseGet(() -> this.toComparator("id"));
            requestContext.setProperty(ORDERBY_PROP, (Object)comparator);
        }
        catch (Exception e) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Not a valid orderby definition " + list)).build());
        }
    }

    private Comparator<Object> toComparator(String s) {
        boolean ascending;
        String clause = s.trim();
        if (clause.endsWith("asc")) {
            ascending = true;
            clause = clause.substring(0, clause.length() - 3).trim();
        } else if (clause.endsWith("desc")) {
            ascending = false;
            clause = clause.substring(0, clause.length() - 4).trim();
        } else {
            ascending = true;
        }
        String[] path = clause.split("/");
        Comparator<Object> result = (a, b) -> BASE_COMPARATOR.compare(this.get(a, path), this.get(b, path));
        return ascending ? result : result.reversed();
    }

    public Comparable<Object> get(Object o, String[] path) {
        Object result = o;
        for (String s : path) {
            if (result == null) break;
            try {
                result = result.getClass().getField(s).get(result);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new BadRequestException("Failed to order objects by " + Arrays.toString(path));
            }
        }
        return (Comparable)result;
    }
}

