/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.filters;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.util.Map;
import org.eclipse.sensinact.sensorthings.sensing.rest.annotation.PropFilter;

@PropFilter
public class PropFilterImpl
implements WriterInterceptor {
    @Context
    UriInfo uriInfo;

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        Object entity = context.getEntity();
        String propName = (String)this.uriInfo.getPathParameters().getFirst((Object)"prop");
        if (propName == null || propName.isEmpty()) {
            throw new BadRequestException("Invalid property filter");
        }
        boolean rawValue = this.uriInfo.getPath().endsWith("/$value");
        try {
            Map<String, Object> prop = entity.getClass().getField(propName).get(entity);
            context.setEntity((Object)(rawValue ? prop : Map.of(propName, prop)));
        }
        catch (Exception e) {
            throw new BadRequestException("Failed to locate property " + propName, (Throwable)e);
        }
        context.proceed();
    }
}

