/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.launcher;

import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.eclipse.sensinact.gateway.launcher.ConfigurationManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@ExtendWith(value={MockitoExtension.class})
class ConfigurationManagerTest {
    @Mock
    ConfigurationAdmin configAdmin;
    @InjectMocks
    ConfigurationManager manager;
    private final Map<String, Configuration> configs = new HashMap<String, Configuration>();
    private final Map<String, Configuration> activeConfigs = new HashMap<String, Configuration>();
    private final Semaphore semaphore = new Semaphore(0);

    ConfigurationManagerTest() {
    }

    @BeforeEach
    void start() throws Exception {
        Mockito.lenient().when((Object)this.configAdmin.getConfiguration(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenAnswer(i -> {
            final String pid = (String)i.getArgument(0, String.class);
            Configuration mock = (Configuration)Mockito.mock(Configuration.class, (String)pid);
            Mockito.when((Object)mock.getPid()).thenReturn((Object)pid);
            ((Configuration)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    ConfigurationManagerTest.this.activeConfigs.remove(pid);
                    return null;
                }
            }).when((Object)mock)).delete();
            this.configs.put(pid, mock);
            this.activeConfigs.put(pid, mock);
            this.semaphore.release();
            return mock;
        });
        Mockito.lenient().when((Object)this.configAdmin.getFactoryConfiguration(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenAnswer(i -> {
            String factoryPid = (String)i.getArgument(0, String.class);
            final String pid = factoryPid + "~" + (String)i.getArgument(1, String.class);
            Configuration mock = (Configuration)Mockito.mock(Configuration.class, (String)pid);
            Mockito.when((Object)mock.getFactoryPid()).thenReturn((Object)factoryPid);
            Mockito.when((Object)mock.getPid()).thenReturn((Object)pid);
            ((Configuration)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    ConfigurationManagerTest.this.activeConfigs.remove(pid);
                    return null;
                }
            }).when((Object)mock)).delete();
            this.configs.put(pid, mock);
            this.activeConfigs.put(pid, mock);
            this.semaphore.release();
            return mock;
        });
        Mockito.lenient().when((Object)this.configAdmin.listConfigurations((String)ArgumentMatchers.eq((Object)"(.sensinact.config=true)"))).then(i -> this.activeConfigs.values().toArray(Configuration[]::new));
    }

    @AfterEach
    void stop() {
        this.configs.clear();
        this.activeConfigs.clear();
        if (this.manager != null) {
            this.manager.stop();
        }
    }

    ArgumentMatcher<Dictionary<String, Object>> isConfig(final Map<String, Object> config) {
        return new ArgumentMatcher<Dictionary<String, Object>>(){

            public boolean matches(Dictionary<String, Object> arg) {
                HashSet<String> keySet = new HashSet<String>();
                Enumeration<String> keys = arg.keys();
                while (keys.hasMoreElements()) {
                    keySet.add(keys.nextElement());
                }
                if (config.keySet().equals(keySet)) {
                    return keySet.stream().allMatch(s -> arg.get(s).equals(config.get(s)));
                }
                return false;
            }

            public String toString() {
                return "Expected config " + config;
            }
        };
    }

    @Nested
    class InvalidConfig {
        InvalidConfig() {
        }

        @Test
        void testNullValue() throws Exception {
            Path path = Paths.get("target/test-classes/configs/invalid", new String[0]);
            System.setProperty("sensinact.config.dir", path.toString());
            Path configFile = path.resolve("configuration.json");
            if (Files.exists(configFile, new LinkOption[0])) {
                Files.delete(configFile);
            }
            ConfigurationManagerTest.this.manager.start();
            Thread.sleep(500L);
            ((ConfigurationAdmin)Mockito.verify((Object)ConfigurationManagerTest.this.configAdmin)).listConfigurations(ArgumentMatchers.anyString());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{ConfigurationManagerTest.this.configAdmin});
            Files.copy(path.resolve("configuration-null.json"), configFile, new CopyOption[0]);
            Assertions.assertTrue((boolean)ConfigurationManagerTest.this.semaphore.tryAcquire(2, 15L, TimeUnit.SECONDS));
            ((ConfigurationAdmin)Mockito.verify((Object)ConfigurationManagerTest.this.configAdmin)).getConfiguration((String)ArgumentMatchers.eq((Object)"test.valid"), ArgumentMatchers.anyString());
            ((Configuration)Mockito.verify((Object)ConfigurationManagerTest.this.configs.get("test.valid"), (VerificationMode)Mockito.timeout((long)500L))).update((Dictionary)ArgumentMatchers.argThat(ConfigurationManagerTest.this.isConfig(Map.of("valid", 1L, ".sensinact.config", true))));
            ((ConfigurationAdmin)Mockito.verify((Object)ConfigurationManagerTest.this.configAdmin)).getConfiguration((String)ArgumentMatchers.eq((Object)"test.null"), ArgumentMatchers.anyString());
            ((Configuration)Mockito.verify((Object)ConfigurationManagerTest.this.configs.get("test.null"), (VerificationMode)Mockito.timeout((long)500L))).update((Dictionary)ArgumentMatchers.argThat(ConfigurationManagerTest.this.isConfig(Map.of("valid", 42L, "test", "{\"titi\":null}", ".sensinact.config", true))));
        }
    }

    @Nested
    class ConfigFileUpdate {
        Path tmpFolder;
        Path configFile;

        ConfigFileUpdate() {
        }

        @BeforeEach
        void setup() throws Exception {
            this.tmpFolder = Files.createTempDirectory("sensinact-config-test", new FileAttribute[0]);
            System.setProperty("sensinact.config.dir", this.tmpFolder.toString());
            this.configFile = this.tmpFolder.resolve("configuration.json");
            if (Files.exists(this.configFile, new LinkOption[0])) {
                Files.delete(this.configFile);
            }
            ConfigurationManagerTest.this.manager.start();
        }

        @AfterEach
        void cleanup() throws Exception {
            if (this.configFile != null && Files.exists(this.configFile, new LinkOption[0])) {
                Files.delete(this.configFile);
            }
            Files.delete(this.tmpFolder);
        }

        @Test
        void testNullProtection() throws Exception {
            ConfigurationManagerTest.this.manager.updateConfigurations(null, null);
            Assertions.assertTrue((boolean)ConfigurationManagerTest.this.activeConfigs.isEmpty());
        }

        @Test
        void testAddition() throws Exception {
            Map<String, Hashtable<String, Integer>> addedConfs = Map.of("test1", new Hashtable<String, Integer>(Map.of("txt", "A", "value", 21)), "test2", new Hashtable<String, Integer>(Map.of("txt", "B", "value", 42)));
            ConfigurationManagerTest.this.manager.updateConfigurations(addedConfs, null);
            Assertions.assertTrue((boolean)ConfigurationManagerTest.this.semaphore.tryAcquire(2, 1L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)ConfigurationManagerTest.this.activeConfigs.containsKey("test1"));
            Assertions.assertTrue((boolean)ConfigurationManagerTest.this.activeConfigs.containsKey("test2"));
            Assertions.assertEquals((int)2, (int)ConfigurationManagerTest.this.activeConfigs.size());
        }
    }

    @Nested
    class ConfigFileWatching {
        ConfigFileWatching() {
        }

        @Test
        void testSimpleConfig() throws Exception {
            System.setProperty("sensinact.config.dir", "target/test-classes/configs/a");
            ConfigurationManagerTest.this.manager.start();
            Assertions.assertTrue((boolean)ConfigurationManagerTest.this.semaphore.tryAcquire(2, 1L, TimeUnit.SECONDS));
            ((ConfigurationAdmin)Mockito.verify((Object)ConfigurationManagerTest.this.configAdmin)).getConfiguration((String)ArgumentMatchers.eq((Object)"test.pid"), ArgumentMatchers.anyString());
            ((ConfigurationAdmin)Mockito.verify((Object)ConfigurationManagerTest.this.configAdmin)).getFactoryConfiguration((String)ArgumentMatchers.eq((Object)"test.factory.pid"), (String)ArgumentMatchers.eq((Object)"boo"), ArgumentMatchers.anyString());
            ((Configuration)Mockito.verify((Object)ConfigurationManagerTest.this.configs.get("test.pid"), (VerificationMode)Mockito.timeout((long)500L))).update((Dictionary)ArgumentMatchers.argThat(ConfigurationManagerTest.this.isConfig(Map.of("foo", "bar", "fizzbuzz", 42L, ".sensinact.config", true))));
            ((Configuration)Mockito.verify((Object)ConfigurationManagerTest.this.configs.get("test.factory.pid~boo"), (VerificationMode)Mockito.timeout((long)500L))).update((Dictionary)ArgumentMatchers.argThat(ConfigurationManagerTest.this.isConfig(Map.of("fizz", "buzz", "foobar", 24L, ".sensinact.config", true))));
        }

        @Test
        void testSimpleUpdate() throws Exception {
            Path path = Paths.get("target/test-classes/configs/b", new String[0]);
            System.setProperty("sensinact.config.dir", path.toString());
            Path configFile = path.resolve("configuration.json");
            if (Files.exists(configFile, new LinkOption[0])) {
                Files.delete(configFile);
            }
            ConfigurationManagerTest.this.manager.start();
            Thread.sleep(500L);
            ((ConfigurationAdmin)Mockito.verify((Object)ConfigurationManagerTest.this.configAdmin)).listConfigurations(ArgumentMatchers.anyString());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{ConfigurationManagerTest.this.configAdmin});
            Files.copy(path.resolve("configuration-initial.json"), configFile, new CopyOption[0]);
            Assertions.assertTrue((boolean)ConfigurationManagerTest.this.semaphore.tryAcquire(3, 15L, TimeUnit.SECONDS));
            ((ConfigurationAdmin)Mockito.verify((Object)ConfigurationManagerTest.this.configAdmin)).getConfiguration((String)ArgumentMatchers.eq((Object)"test.pid"), ArgumentMatchers.anyString());
            ((ConfigurationAdmin)Mockito.verify((Object)ConfigurationManagerTest.this.configAdmin)).getConfiguration((String)ArgumentMatchers.eq((Object)"test.pid.temp"), ArgumentMatchers.anyString());
            ((ConfigurationAdmin)Mockito.verify((Object)ConfigurationManagerTest.this.configAdmin)).getFactoryConfiguration((String)ArgumentMatchers.eq((Object)"test.factory.pid"), (String)ArgumentMatchers.eq((Object)"boo"), ArgumentMatchers.anyString());
            ((Configuration)Mockito.verify((Object)ConfigurationManagerTest.this.configs.get("test.pid"), (VerificationMode)Mockito.timeout((long)500L))).update((Dictionary)ArgumentMatchers.argThat(ConfigurationManagerTest.this.isConfig(Map.of("foo", "bar", "fizzbuzz", 42L, ".sensinact.config", true))));
            ((Configuration)Mockito.verify((Object)ConfigurationManagerTest.this.configs.get("test.pid.temp"), (VerificationMode)Mockito.timeout((long)500L))).update((Dictionary)ArgumentMatchers.argThat(ConfigurationManagerTest.this.isConfig(Map.of("ttl", 1L, ".sensinact.config", true))));
            ((Configuration)Mockito.verify((Object)ConfigurationManagerTest.this.configs.get("test.factory.pid~boo"), (VerificationMode)Mockito.timeout((long)500L))).update((Dictionary)ArgumentMatchers.argThat(ConfigurationManagerTest.this.isConfig(Map.of("fizz", "buzz", "foobar", 24L, ".sensinact.config", true))));
            Files.newInputStream(path.resolve("configuration-update.json"), new OpenOption[0]).transferTo(Files.newOutputStream(configFile, new OpenOption[0]));
            ((Configuration)Mockito.verify((Object)ConfigurationManagerTest.this.configs.get("test.pid"), (VerificationMode)Mockito.timeout((long)25000L).atLeast(1))).updateIfDifferent((Dictionary)ArgumentMatchers.argThat(ConfigurationManagerTest.this.isConfig(Map.of("bar", "foo", "fizzbuzz", 84L, ".sensinact.config", true))));
            ((Configuration)Mockito.verify((Object)ConfigurationManagerTest.this.configs.get("test.pid.temp"), (VerificationMode)Mockito.timeout((long)500L))).delete();
            ((Configuration)Mockito.verify((Object)ConfigurationManagerTest.this.configs.get("test.factory.pid~boo"), (VerificationMode)Mockito.timeout((long)500L).atLeast(1))).updateIfDifferent((Dictionary)ArgumentMatchers.argThat(ConfigurationManagerTest.this.isConfig(Map.of("buzz", "fizz", "foobar", 48L, ".sensinact.config", true))));
        }
    }
}

