/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.dto;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.geojson.Coordinates;
import org.eclipse.sensinact.gateway.geojson.Point;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.FeatureOfInterest;
import org.eclipse.sensinact.sensorthings.sensing.dto.HistoricalLocation;
import org.eclipse.sensinact.sensorthings.sensing.dto.Location;
import org.eclipse.sensinact.sensorthings.sensing.dto.Observation;
import org.eclipse.sensinact.sensorthings.sensing.dto.ObservedProperty;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.dto.RootResponse;
import org.eclipse.sensinact.sensorthings.sensing.dto.Sensor;
import org.eclipse.sensinact.sensorthings.sensing.dto.Thing;
import org.eclipse.sensinact.sensorthings.sensing.dto.UnitOfMeasurement;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class JsonMappingTest {
    JsonMappingTest() {
    }

    ObjectMapper getObjectMapper() {
        return new ObjectMapper().registerModule((Module)new JavaTimeModule());
    }

    File getFile(String path) {
        return new File("src/test/resources/toronto-bike-snapshot.sensorup.com", path);
    }

    @Nested
    class ResourceSerialization {
        ResourceSerialization() {
        }

        @Test
        void testThing() throws Exception {
            Thing thing = new Thing();
            thing.id = 206047;
            thing.selfLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/Things(206047)";
            thing.name = "7061:Bloor St / Brunswick Ave";
            thing.description = "Bloor St / Brunswick Ave Toronto bike share station with data of available bikes and available docks";
            thing.properties = Map.of();
            thing.datastreamsLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/Things(206047)/Datastreams";
            thing.historicalLocationsLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/Things(206047)/HistoricalLocations";
            thing.locationsLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/Things(206047)/Locations";
            Assertions.assertEquals((Object)JsonMappingTest.this.getObjectMapper().readTree(JsonMappingTest.this.getFile("Datastreams(206051)/Thing.json")), (Object)JsonMappingTest.this.getObjectMapper().valueToTree((Object)thing));
        }

        @Test
        void testLocation() throws Exception {
            Location location = new Location();
            location.id = 206048;
            location.selfLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/Locations(206048)";
            location.name = "7061:Bloor St / Brunswick Ave";
            location.description = "The geographic location with coordinates for the Toronto bike share station Bloor St / Brunswick Ave";
            location.encodingType = "application/vnd.geo+json";
            location.thingsLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/Locations(206048)/Things";
            location.historicalLocationsLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/Locations(206048)/HistoricalLocations";
            Point point = new Point();
            point.coordinates = new Coordinates();
            point.coordinates.longitude = -79.407224;
            point.coordinates.latitude = 43.665876;
            location.location = point;
            ResultList list = new ResultList();
            list.value = List.of(location);
            list.count = 1;
            Assertions.assertEquals((Object)JsonMappingTest.this.getObjectMapper().readTree(JsonMappingTest.this.getFile("HistoricalLocations(206049)/Locations.json")), (Object)JsonMappingTest.this.getObjectMapper().valueToTree((Object)list));
        }

        @Test
        void testHistoricalLocation() throws Exception {
            HistoricalLocation historicalLocation = new HistoricalLocation();
            historicalLocation.id = 206049;
            historicalLocation.selfLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/HistoricalLocations(206049)";
            historicalLocation.time = Instant.parse("2017-02-04T15:50:10.489Z");
            historicalLocation.locationsLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/HistoricalLocations(206049)/Locations";
            historicalLocation.thingLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/HistoricalLocations(206049)/Thing";
            ResultList list = new ResultList();
            list.value = List.of(historicalLocation);
            list.count = 1;
            Assertions.assertEquals((Object)JsonMappingTest.this.getObjectMapper().readTree(JsonMappingTest.this.getFile("Locations(206048)/HistoricalLocations.json")), (Object)JsonMappingTest.this.getObjectMapper().valueToTree((Object)list));
        }

        @Test
        void testDatastream() throws Exception {
            Datastream datastream = new Datastream();
            datastream.id = 1512;
            datastream.selfLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/Datastreams(1512)";
            datastream.name = "7203:Harrison/Dovercourt:available_bikes";
            datastream.description = "The datastream of available bikes count for the Toronto bike share station Harrison/Dovercourt";
            datastream.observationType = "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CountObservation";
            UnitOfMeasurement unit = new UnitOfMeasurement();
            unit.symbol = "{TOT}";
            unit.name = "bike count";
            unit.definition = "http://unitsofmeasure.org/ucum.html#para-50";
            datastream.unitOfMeasurement = unit;
            datastream.observationsLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/Datastreams(1512)/Observations";
            datastream.observedPropertyLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/Datastreams(1512)/ObservedProperty";
            datastream.sensorLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/Datastreams(1512)/Sensor";
            datastream.thingLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/Datastreams(1512)/Thing";
            Assertions.assertEquals((Object)JsonMappingTest.this.getObjectMapper().readTree(JsonMappingTest.this.getFile("Observations(1595550)/Datastream.json")), (Object)JsonMappingTest.this.getObjectMapper().valueToTree((Object)datastream));
        }

        @Test
        void testSensor() throws Exception {
            Sensor sensor = new Sensor();
            sensor.id = 4;
            sensor.selfLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/Sensors(4)";
            sensor.name = "available_docks";
            sensor.description = "A sensor for tracking how many docks are available in a bike station";
            sensor.encodingType = "text/plan";
            sensor.metadata = "https://member.bikesharetoronto.com/stations";
            sensor.datastreamsLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/Sensors(4)/Datastreams";
            Assertions.assertEquals((Object)JsonMappingTest.this.getObjectMapper().readTree(JsonMappingTest.this.getFile("Datastreams(206051)/Sensor.json")), (Object)JsonMappingTest.this.getObjectMapper().valueToTree((Object)sensor));
        }

        @Test
        void testObservation() throws Exception {
            Observation observation = new Observation();
            observation.id = 1595550;
            observation.selfLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/Observations(1595550)";
            observation.phenomenonTime = Instant.parse("2017-02-16T21:55:12.841Z");
            observation.result = "7";
            observation.datastreamLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/Observations(1595550)/Datastream";
            observation.featureOfInterestLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/Observations(1595550)/FeatureOfInterest";
            Assertions.assertEquals((Object)JsonMappingTest.this.getObjectMapper().readTree(JsonMappingTest.this.getFile("Observations(1595550)/root.json")), (Object)JsonMappingTest.this.getObjectMapper().valueToTree((Object)observation));
        }

        @Test
        void testObservedProperty() throws Exception {
            ObservedProperty observedProperty = new ObservedProperty();
            observedProperty.id = 2;
            observedProperty.selfLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/ObservedProperties(2)";
            observedProperty.name = "available_docks";
            observedProperty.description = "The total number count of available docks in a bike station";
            observedProperty.definition = "https://member.bikesharetoronto.com/stations";
            observedProperty.datastreamsLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/ObservedProperties(2)/Datastreams";
            Assertions.assertEquals((Object)JsonMappingTest.this.getObjectMapper().readTree(JsonMappingTest.this.getFile("Datastreams(206051)/ObservedProperty.json")), (Object)JsonMappingTest.this.getObjectMapper().valueToTree((Object)observedProperty));
        }

        @Test
        void testFeatureOfInterest() throws Exception {
            FeatureOfInterest featureOfInterest = new FeatureOfInterest();
            featureOfInterest.id = 1514;
            featureOfInterest.selfLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/FeaturesOfInterest(1514)";
            featureOfInterest.name = "7203:Harrison/Dovercourt";
            featureOfInterest.description = "Generated using location details: The geographic location with coordinates for the Toronto bike share station Harrison/Dovercourt";
            featureOfInterest.encodingType = "application/vnd.geo+json";
            featureOfInterest.observationsLink = "https://toronto-bike-snapshot.sensorup.com/v1.0/FeaturesOfInterest(1514)/Observations";
            Point point = new Point();
            point.coordinates = new Coordinates();
            point.coordinates.longitude = -79.424557;
            point.coordinates.latitude = 43.650978;
            featureOfInterest.feature = point;
            Assertions.assertEquals((Object)JsonMappingTest.this.getObjectMapper().readTree(JsonMappingTest.this.getFile("Observations(1595550)/FeatureOfInterest.json")), (Object)JsonMappingTest.this.getObjectMapper().valueToTree((Object)featureOfInterest));
        }
    }

    @Nested
    class ResourceParsing {
        ResourceParsing() {
        }

        @Test
        void testRootResponse() throws IOException {
            RootResponse response = (RootResponse)JsonMappingTest.this.getObjectMapper().readValue(JsonMappingTest.this.getFile("v1.0.json"), RootResponse.class);
            Assertions.assertEquals((int)8, (int)response.value.size());
            List<String> expected = List.of("Things", "https://toronto-bike-snapshot.sensorup.com/v1.0/Things", "Locations", "https://toronto-bike-snapshot.sensorup.com/v1.0/Locations", "HistoricalLocations", "https://toronto-bike-snapshot.sensorup.com/v1.0/HistoricalLocations", "Datastreams", "https://toronto-bike-snapshot.sensorup.com/v1.0/Datastreams", "Sensors", "https://toronto-bike-snapshot.sensorup.com/v1.0/Sensors", "Observations", "https://toronto-bike-snapshot.sensorup.com/v1.0/Observations", "ObservedProperties", "https://toronto-bike-snapshot.sensorup.com/v1.0/ObservedProperties", "FeaturesOfInterest", "https://toronto-bike-snapshot.sensorup.com/v1.0/FeaturesOfInterest");
            Iterator<String> it = expected.iterator();
            for (RootResponse.NameUrl nu : response.value) {
                Assertions.assertEquals((Object)it.next(), (Object)nu.name);
                Assertions.assertEquals((Object)it.next(), (Object)nu.url);
            }
        }

        @Test
        void testThings() throws IOException {
            ResultList things = (ResultList)JsonMappingTest.this.getObjectMapper().readValue(JsonMappingTest.this.getFile("Things.json"), (TypeReference)new TypeReference<ResultList<Thing>>(){});
            Assertions.assertEquals((int)199, (Integer)things.count);
            Assertions.assertEquals((Object)"https://toronto-bike-snapshot.sensorup.com/v1.0/Things?$top=100&$skip=100", (Object)things.nextLink);
            Assertions.assertEquals((int)100, (int)things.value.size());
            this.assertThing((Thing)things.value.get(0), 206047, "https://toronto-bike-snapshot.sensorup.com/v1.0/Things(206047)", "Bloor St / Brunswick Ave Toronto bike share station with data of available bikes and available docks", "7061:Bloor St / Brunswick Ave", "https://toronto-bike-snapshot.sensorup.com/v1.0/Things(206047)/Datastreams", "https://toronto-bike-snapshot.sensorup.com/v1.0/Things(206047)/HistoricalLocations", "https://toronto-bike-snapshot.sensorup.com/v1.0/Things(206047)/Locations");
            this.assertThing((Thing)things.value.get(1), 1581, "https://toronto-bike-snapshot.sensorup.com/v1.0/Things(1581)", "Wellington Dog Park Toronto bike share station with data of available bikes and available docks", "7216:Wellington Dog Park", "https://toronto-bike-snapshot.sensorup.com/v1.0/Things(1581)/Datastreams", "https://toronto-bike-snapshot.sensorup.com/v1.0/Things(1581)/HistoricalLocations", "https://toronto-bike-snapshot.sensorup.com/v1.0/Things(1581)/Locations");
            this.assertThing((Thing)things.value.get(2), 1573, "https://toronto-bike-snapshot.sensorup.com/v1.0/Things(1573)", "Fort York/Garrison Toronto bike share station with data of available bikes and available docks", "7211:Fort York/Garrison", "https://toronto-bike-snapshot.sensorup.com/v1.0/Things(1573)/Datastreams", "https://toronto-bike-snapshot.sensorup.com/v1.0/Things(1573)/HistoricalLocations", "https://toronto-bike-snapshot.sensorup.com/v1.0/Things(1573)/Locations");
        }

        void assertThing(Thing thing, Integer id, String selfLink, String description, String name, String datastreams, String historicalLocations, String locations) {
            Assertions.assertEquals((Object)id, (Object)thing.id);
            Assertions.assertEquals((Object)selfLink, (Object)thing.selfLink);
            Assertions.assertEquals((Object)description, (Object)thing.description);
            Assertions.assertEquals((Object)name, (Object)thing.name);
            Assertions.assertEquals(Map.of(), (Object)thing.properties);
            Assertions.assertEquals((Object)datastreams, (Object)thing.datastreamsLink);
            Assertions.assertEquals((Object)historicalLocations, (Object)thing.historicalLocationsLink);
            Assertions.assertEquals((Object)locations, (Object)thing.locationsLink);
        }

        @Test
        void testLocations() throws IOException {
            ResultList locations = (ResultList)JsonMappingTest.this.getObjectMapper().readValue(JsonMappingTest.this.getFile("Locations.json"), (TypeReference)new TypeReference<ResultList<Location>>(){});
            Assertions.assertEquals((int)199, (Integer)locations.count);
            Assertions.assertEquals((Object)"https://toronto-bike-snapshot.sensorup.com/v1.0/Locations?$top=100&$skip=100", (Object)locations.nextLink);
            Assertions.assertEquals((int)100, (int)locations.value.size());
            this.assertLocation((Location)locations.value.get(0), 206048, "https://toronto-bike-snapshot.sensorup.com/v1.0/Locations(206048)", "The geographic location with coordinates for the Toronto bike share station Bloor St / Brunswick Ave", "7061:Bloor St / Brunswick Ave", -79.407224, 43.665876, "https://toronto-bike-snapshot.sensorup.com/v1.0/Locations(206048)/Things", "https://toronto-bike-snapshot.sensorup.com/v1.0/Locations(206048)/HistoricalLocations");
            this.assertLocation((Location)locations.value.get(1), 1582, "https://toronto-bike-snapshot.sensorup.com/v1.0/Locations(1582)", "The geographic location with coordinates for the Toronto bike share station Wellington Dog Park", "7216:Wellington Dog Park", -79.409339, 43.641281, "https://toronto-bike-snapshot.sensorup.com/v1.0/Locations(1582)/Things", "https://toronto-bike-snapshot.sensorup.com/v1.0/Locations(1582)/HistoricalLocations");
            this.assertLocation((Location)locations.value.get(2), 1574, "https://toronto-bike-snapshot.sensorup.com/v1.0/Locations(1574)", "The geographic location with coordinates for the Toronto bike share station Fort York/Garrison", "7211:Fort York/Garrison", -79.4061111111111, 43.6375, "https://toronto-bike-snapshot.sensorup.com/v1.0/Locations(1574)/Things", "https://toronto-bike-snapshot.sensorup.com/v1.0/Locations(1574)/HistoricalLocations");
        }

        void assertLocation(Location location, Integer id, String selfLink, String description, String name, double longitude, double latitude, String things, String historicalLocations) {
            Assertions.assertEquals((Object)id, (Object)location.id);
            Assertions.assertEquals((Object)selfLink, (Object)location.selfLink);
            Assertions.assertEquals((Object)description, (Object)location.description);
            Assertions.assertEquals((Object)name, (Object)location.name);
            Assertions.assertEquals((Object)"application/vnd.geo+json", (Object)location.encodingType);
            Assertions.assertInstanceOf(Point.class, (Object)location.location);
            Assertions.assertEquals((double)longitude, (double)((Point)location.location).coordinates.longitude);
            Assertions.assertEquals((double)latitude, (double)((Point)location.location).coordinates.latitude);
            Assertions.assertEquals((Object)things, (Object)location.thingsLink);
            Assertions.assertEquals((Object)historicalLocations, (Object)location.historicalLocationsLink);
        }

        @Test
        void testHistoricalLocations() throws IOException {
            ResultList locations = (ResultList)JsonMappingTest.this.getObjectMapper().readValue(JsonMappingTest.this.getFile("HistoricalLocations.json"), (TypeReference)new TypeReference<ResultList<HistoricalLocation>>(){});
            Assertions.assertEquals((int)199, (Integer)locations.count);
            Assertions.assertEquals((Object)"https://toronto-bike-snapshot.sensorup.com/v1.0/HistoricalLocations?$top=100&$skip=100", (Object)locations.nextLink);
            Assertions.assertEquals((int)100, (int)locations.value.size());
            this.assertHistoricalLocation((HistoricalLocation)locations.value.get(0), 206049, "https://toronto-bike-snapshot.sensorup.com/v1.0/HistoricalLocations(206049)", "2017-02-04T15:50:10.489Z", "https://toronto-bike-snapshot.sensorup.com/v1.0/HistoricalLocations(206049)/Locations", "https://toronto-bike-snapshot.sensorup.com/v1.0/HistoricalLocations(206049)/Thing");
            this.assertHistoricalLocation((HistoricalLocation)locations.value.get(1), 1583, "https://toronto-bike-snapshot.sensorup.com/v1.0/HistoricalLocations(1583)", "2017-02-02T20:45:24.966Z", "https://toronto-bike-snapshot.sensorup.com/v1.0/HistoricalLocations(1583)/Locations", "https://toronto-bike-snapshot.sensorup.com/v1.0/HistoricalLocations(1583)/Thing");
            this.assertHistoricalLocation((HistoricalLocation)locations.value.get(2), 1575, "https://toronto-bike-snapshot.sensorup.com/v1.0/HistoricalLocations(1575)", "2017-02-02T20:45:24.906Z", "https://toronto-bike-snapshot.sensorup.com/v1.0/HistoricalLocations(1575)/Locations", "https://toronto-bike-snapshot.sensorup.com/v1.0/HistoricalLocations(1575)/Thing");
        }

        void assertHistoricalLocation(HistoricalLocation historicalLocation, Integer id, String selfLink, String time, String locations, String thing) {
            Assertions.assertEquals((Object)id, (Object)historicalLocation.id);
            Assertions.assertEquals((Object)selfLink, (Object)historicalLocation.selfLink);
            Assertions.assertEquals((Object)Instant.parse(time), (Object)historicalLocation.time);
            Assertions.assertEquals((Object)locations, (Object)historicalLocation.locationsLink);
            Assertions.assertEquals((Object)thing, (Object)historicalLocation.thingLink);
        }

        @Test
        void testDatastreams() throws IOException {
            ResultList streams = (ResultList)JsonMappingTest.this.getObjectMapper().readValue(JsonMappingTest.this.getFile("Datastreams.json"), (TypeReference)new TypeReference<ResultList<Datastream>>(){});
            Assertions.assertEquals((int)398, (Integer)streams.count);
            Assertions.assertEquals((Object)"https://toronto-bike-snapshot.sensorup.com/v1.0/Datastreams?$top=100&$skip=100", (Object)streams.nextLink);
            Assertions.assertEquals((int)100, (int)streams.value.size());
            this.assertDatastream((Datastream)streams.value.get(0), 206051, "https://toronto-bike-snapshot.sensorup.com/v1.0/Datastreams(206051)", "7061:Bloor St / Brunswick Ave:available_docks", "The datastream of available docks count for the Toronto bike share station Bloor St / Brunswick Ave", "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CountObservation", "dock count", "https://toronto-bike-snapshot.sensorup.com/v1.0/Datastreams(206051)/Observations", "https://toronto-bike-snapshot.sensorup.com/v1.0/Datastreams(206051)/ObservedProperty", "https://toronto-bike-snapshot.sensorup.com/v1.0/Datastreams(206051)/Sensor", "https://toronto-bike-snapshot.sensorup.com/v1.0/Datastreams(206051)/Thing");
            this.assertDatastream((Datastream)streams.value.get(1), 206050, "https://toronto-bike-snapshot.sensorup.com/v1.0/Datastreams(206050)", "7061:Bloor St / Brunswick Ave:available_bikes", "The datastream of available bikes count for the Toronto bike share station Bloor St / Brunswick Ave", "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CountObservation", "bike count", "https://toronto-bike-snapshot.sensorup.com/v1.0/Datastreams(206050)/Observations", "https://toronto-bike-snapshot.sensorup.com/v1.0/Datastreams(206050)/ObservedProperty", "https://toronto-bike-snapshot.sensorup.com/v1.0/Datastreams(206050)/Sensor", "https://toronto-bike-snapshot.sensorup.com/v1.0/Datastreams(206050)/Thing");
            this.assertDatastream((Datastream)streams.value.get(2), 1585, "https://toronto-bike-snapshot.sensorup.com/v1.0/Datastreams(1585)", "7216:Wellington Dog Park:available_docks", "The datastream of available docks count for the Toronto bike share station Wellington Dog Park", "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CountObservation", "dock count", "https://toronto-bike-snapshot.sensorup.com/v1.0/Datastreams(1585)/Observations", "https://toronto-bike-snapshot.sensorup.com/v1.0/Datastreams(1585)/ObservedProperty", "https://toronto-bike-snapshot.sensorup.com/v1.0/Datastreams(1585)/Sensor", "https://toronto-bike-snapshot.sensorup.com/v1.0/Datastreams(1585)/Thing");
        }

        void assertDatastream(Datastream datastream, Integer id, String selfLink, String name, String description, String observationType, String unitName, String observations, String observedProperty, String sensor, String thing) {
            Assertions.assertEquals((Object)id, (Object)datastream.id);
            Assertions.assertEquals((Object)selfLink, (Object)datastream.selfLink);
            Assertions.assertEquals((Object)name, (Object)datastream.name);
            Assertions.assertEquals((Object)description, (Object)datastream.description);
            Assertions.assertEquals((Object)observationType, (Object)datastream.observationType);
            Assertions.assertNull((Object)datastream.observedArea);
            Assertions.assertEquals((Object)"{TOT}", (Object)datastream.unitOfMeasurement.symbol);
            Assertions.assertEquals((Object)unitName, (Object)datastream.unitOfMeasurement.name);
            Assertions.assertEquals((Object)"http://unitsofmeasure.org/ucum.html#para-50", (Object)datastream.unitOfMeasurement.definition);
            Assertions.assertEquals((Object)observations, (Object)datastream.observationsLink);
            Assertions.assertEquals((Object)observedProperty, (Object)datastream.observedPropertyLink);
            Assertions.assertEquals((Object)sensor, (Object)datastream.sensorLink);
            Assertions.assertEquals((Object)thing, (Object)datastream.thingLink);
        }

        @Test
        void testSensors() throws IOException {
            ResultList streams = (ResultList)JsonMappingTest.this.getObjectMapper().readValue(JsonMappingTest.this.getFile("Sensors.json"), (TypeReference)new TypeReference<ResultList<Sensor>>(){});
            Assertions.assertEquals((int)2, (Integer)streams.count);
            Assertions.assertNull((Object)streams.nextLink);
            Assertions.assertEquals((int)2, (int)streams.value.size());
            this.assertSensor((Sensor)streams.value.get(0), 4, "https://toronto-bike-snapshot.sensorup.com/v1.0/Sensors(4)", "available_docks", "A sensor for tracking how many docks are available in a bike station", "text/plan", "https://member.bikesharetoronto.com/stations", "https://toronto-bike-snapshot.sensorup.com/v1.0/Sensors(4)/Datastreams");
            this.assertSensor((Sensor)streams.value.get(1), 3, "https://toronto-bike-snapshot.sensorup.com/v1.0/Sensors(3)", "available_bikes", "A sensor for tracking how many bikes are available in a bike station", "text/plan", "https://member.bikesharetoronto.com/stations", "https://toronto-bike-snapshot.sensorup.com/v1.0/Sensors(3)/Datastreams");
        }

        void assertSensor(Sensor datastream, Integer id, String selfLink, String name, String description, String encodingType, String metadata, String datastreams) {
            Assertions.assertEquals((Object)id, (Object)datastream.id);
            Assertions.assertEquals((Object)selfLink, (Object)datastream.selfLink);
            Assertions.assertEquals((Object)name, (Object)datastream.name);
            Assertions.assertEquals((Object)description, (Object)datastream.description);
            Assertions.assertEquals((Object)encodingType, (Object)datastream.encodingType);
            Assertions.assertEquals((Object)metadata, (Object)datastream.metadata);
            Assertions.assertEquals((Object)datastreams, (Object)datastream.datastreamsLink);
        }

        @Test
        void testObservations() throws IOException {
            ResultList observations = (ResultList)JsonMappingTest.this.getObjectMapper().readValue(JsonMappingTest.this.getFile("Observations.json"), (TypeReference)new TypeReference<ResultList<Observation>>(){});
            Assertions.assertEquals((int)1594349, (Integer)observations.count);
            Assertions.assertEquals((Object)"https://toronto-bike-snapshot.sensorup.com/v1.0/Observations?$top=100&$skip=100", (Object)observations.nextLink);
            Assertions.assertEquals((int)100, (int)observations.value.size());
            this.assertObservation((Observation)observations.value.get(0), 1595550, "https://toronto-bike-snapshot.sensorup.com/v1.0/Observations(1595550)", "2017-02-16T21:55:12.841Z", "7", "https://toronto-bike-snapshot.sensorup.com/v1.0/Observations(1595550)/Datastream", "https://toronto-bike-snapshot.sensorup.com/v1.0/Observations(1595550)/FeatureOfInterest");
            this.assertObservation((Observation)observations.value.get(1), 1595551, "https://toronto-bike-snapshot.sensorup.com/v1.0/Observations(1595551)", "2017-02-16T21:55:12.841Z", "4", "https://toronto-bike-snapshot.sensorup.com/v1.0/Observations(1595551)/Datastream", "https://toronto-bike-snapshot.sensorup.com/v1.0/Observations(1595551)/FeatureOfInterest");
            this.assertObservation((Observation)observations.value.get(2), 1595549, "https://toronto-bike-snapshot.sensorup.com/v1.0/Observations(1595549)", "2017-02-16T21:55:12.830Z", "8", "https://toronto-bike-snapshot.sensorup.com/v1.0/Observations(1595549)/Datastream", "https://toronto-bike-snapshot.sensorup.com/v1.0/Observations(1595549)/FeatureOfInterest");
        }

        void assertObservation(Observation observation, Integer id, String selfLink, String time, String result, String datastream, String featureOfInterest) {
            Assertions.assertEquals((Object)id, (Object)observation.id);
            Assertions.assertEquals((Object)selfLink, (Object)observation.selfLink);
            Assertions.assertEquals((Object)Instant.parse(time), (Object)observation.phenomenonTime);
            Assertions.assertEquals((Object)result, (Object)observation.result);
            Assertions.assertNull((Object)observation.resultTime);
            Assertions.assertNull((Object)observation.resultQuality);
            Assertions.assertEquals((Object)datastream, (Object)observation.datastreamLink);
            Assertions.assertEquals((Object)featureOfInterest, (Object)observation.featureOfInterestLink);
        }

        @Test
        void testObservedProperties() throws IOException {
            ResultList observedProps = (ResultList)JsonMappingTest.this.getObjectMapper().readValue(JsonMappingTest.this.getFile("ObservedProperties.json"), (TypeReference)new TypeReference<ResultList<ObservedProperty>>(){});
            Assertions.assertEquals((int)2, (Integer)observedProps.count);
            Assertions.assertNull((Object)observedProps.nextLink);
            Assertions.assertEquals((int)2, (int)observedProps.value.size());
            this.assertObservedProperty((ObservedProperty)observedProps.value.get(0), 2, "https://toronto-bike-snapshot.sensorup.com/v1.0/ObservedProperties(2)", "available_docks", "The total number count of available docks in a bike station", "https://member.bikesharetoronto.com/stations", "https://toronto-bike-snapshot.sensorup.com/v1.0/ObservedProperties(2)/Datastreams");
            this.assertObservedProperty((ObservedProperty)observedProps.value.get(1), 1, "https://toronto-bike-snapshot.sensorup.com/v1.0/ObservedProperties(1)", "available_bikes", "The total number count of available bikes in a bike station", "https://member.bikesharetoronto.com/stations", "https://toronto-bike-snapshot.sensorup.com/v1.0/ObservedProperties(1)/Datastreams");
        }

        void assertObservedProperty(ObservedProperty observation, Integer id, String selfLink, String name, String description, String definition, String datastreams) {
            Assertions.assertEquals((Object)id, (Object)observation.id);
            Assertions.assertEquals((Object)selfLink, (Object)observation.selfLink);
            Assertions.assertEquals((Object)name, (Object)observation.name);
            Assertions.assertEquals((Object)description, (Object)observation.description);
            Assertions.assertEquals((Object)definition, (Object)observation.definition);
            Assertions.assertEquals((Object)datastreams, (Object)observation.datastreamsLink);
        }

        @Test
        void testFeaturesOfInterest() throws IOException {
            ResultList observedProps = (ResultList)JsonMappingTest.this.getObjectMapper().readValue(JsonMappingTest.this.getFile("FeaturesOfInterest.json"), (TypeReference)new TypeReference<ResultList<FeatureOfInterest>>(){});
            Assertions.assertEquals((int)199, (Integer)observedProps.count);
            Assertions.assertEquals((Object)"https://toronto-bike-snapshot.sensorup.com/v1.0/FeaturesOfInterest?$top=100&$skip=100", (Object)observedProps.nextLink);
            Assertions.assertEquals((int)100, (int)observedProps.value.size());
            this.assertFeatureOfInterest((FeatureOfInterest)observedProps.value.get(0), 206052, "https://toronto-bike-snapshot.sensorup.com/v1.0/FeaturesOfInterest(206052)", "7061:Bloor St / Brunswick Ave", "Generated using location details: The geographic location with coordinates for the Toronto bike share station Bloor St / Brunswick Ave", -79.407224, 43.665876, "https://toronto-bike-snapshot.sensorup.com/v1.0/FeaturesOfInterest(206052)/Observations");
            this.assertFeatureOfInterest((FeatureOfInterest)observedProps.value.get(1), 1586, "https://toronto-bike-snapshot.sensorup.com/v1.0/FeaturesOfInterest(1586)", "7216:Wellington Dog Park", "Generated using location details: The geographic location with coordinates for the Toronto bike share station Wellington Dog Park", -79.409339, 43.641281, "https://toronto-bike-snapshot.sensorup.com/v1.0/FeaturesOfInterest(1586)/Observations");
            this.assertFeatureOfInterest((FeatureOfInterest)observedProps.value.get(2), 1578, "https://toronto-bike-snapshot.sensorup.com/v1.0/FeaturesOfInterest(1578)", "7211:Fort York/Garrison", "Generated using location details: The geographic location with coordinates for the Toronto bike share station Fort York/Garrison", -79.4061111111111, 43.6375, "https://toronto-bike-snapshot.sensorup.com/v1.0/FeaturesOfInterest(1578)/Observations");
        }

        void assertFeatureOfInterest(FeatureOfInterest featureOfInterest, Integer id, String selfLink, String name, String description, double longitude, double latitude, String observations) {
            Assertions.assertEquals((Object)id, (Object)featureOfInterest.id);
            Assertions.assertEquals((Object)selfLink, (Object)featureOfInterest.selfLink);
            Assertions.assertEquals((Object)name, (Object)featureOfInterest.name);
            Assertions.assertEquals((Object)description, (Object)featureOfInterest.description);
            Assertions.assertEquals((Object)"application/vnd.geo+json", (Object)featureOfInterest.encodingType);
            Assertions.assertInstanceOf(Point.class, (Object)featureOfInterest.feature);
            Assertions.assertEquals((double)longitude, (double)((Point)featureOfInterest.feature).coordinates.longitude);
            Assertions.assertEquals((double)latitude, (double)((Point)featureOfInterest.feature).coordinates.latitude);
            Assertions.assertEquals((Object)observations, (Object)featureOfInterest.observationsLink);
        }
    }
}

