/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.test;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Map;
import org.eclipse.sensinact.gateway.app.api.exception.ApplicationFactoryException;
import org.eclipse.sensinact.gateway.app.api.plugin.PluginInstaller;
import org.eclipse.sensinact.gateway.app.manager.application.Application;
import org.eclipse.sensinact.gateway.app.manager.application.ApplicationService;
import org.eclipse.sensinact.gateway.app.manager.component.Component;
import org.eclipse.sensinact.gateway.app.manager.component.property.RegisterPropertyBlock;
import org.eclipse.sensinact.gateway.app.manager.factory.ApplicationFactory;
import org.eclipse.sensinact.gateway.app.manager.json.AppContainer;
import org.eclipse.sensinact.gateway.app.manager.json.AppFunction;
import org.eclipse.sensinact.gateway.app.manager.osgi.AppServiceMediator;
import org.eclipse.sensinact.gateway.app.manager.test.AppModelInstance;
import org.eclipse.sensinact.gateway.app.manager.test.MockComponentIncrement;
import org.eclipse.sensinact.gateway.app.manager.test.TestUtils;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.core.ActionResource;
import org.eclipse.sensinact.gateway.core.InvalidResourceException;
import org.eclipse.sensinact.gateway.core.ModelConfiguration;
import org.eclipse.sensinact.gateway.core.ModelInstance;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.ResourceBuilder;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.core.ResourceDescriptor;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.ServiceImpl;
import org.eclipse.sensinact.gateway.core.ServiceProviderImpl;
import org.eclipse.sensinact.gateway.core.Session;
import org.eclipse.sensinact.gateway.core.TypeConfig;
import org.eclipse.sensinact.gateway.core.method.GetResponse;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.osgi.framework.ServiceReference;

public class TestComponentFactory {
    private AppModelInstance modelInstance = (AppModelInstance)((Object)Mockito.mock(AppModelInstance.class));
    private ModelConfiguration modelConfiguration = (ModelConfiguration)Mockito.mock(ModelConfiguration.class);
    private ServiceProviderImpl device = (ServiceProviderImpl)Mockito.mock(ServiceProviderImpl.class);
    private AppServiceMediator mediator = (AppServiceMediator)Mockito.mock(AppServiceMediator.class);
    private Resource resource = (Resource)Mockito.mock(Resource.class);

    @BeforeEach
    public void init() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        GetResponse getResponse = (GetResponse)Mockito.mock(GetResponse.class);
        ServiceReference serviceReference = (ServiceReference)Mockito.mock(ServiceReference.class);
        ServiceReference[] serviceReferences = new ServiceReference[]{serviceReference};
        Session session = (Session)Mockito.mock(Session.class);
        PluginInstaller installer = (PluginInstaller)Mockito.mock(PluginInstaller.class);
        ServiceImpl adminService = (ServiceImpl)Mockito.mock(ServiceImpl.class);
        Mockito.when((Object)adminService.getName()).thenReturn((Object)"admin");
        Mockito.when((Object)adminService.getPath()).thenReturn((Object)UriUtils.getUri((String[])new String[]{"TestAppDevice", "admin"}));
        Mockito.when((Object)this.mediator.getClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
        Mockito.when((Object)this.modelInstance.mediator()).thenReturn((Object)this.mediator);
        Mockito.when((Object)adminService.getModelInstance()).thenReturn((Object)this.modelInstance);
        Mockito.when((Object)this.device.getModelInstance()).thenReturn((Object)this.modelInstance);
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.setTypeConfig(new TypeConfig(ActionResource.class));
        ResourceBuilder builder = new ResourceBuilder((Mediator)this.mediator, resourceConfig);
        builder.configureName("UNINSTALL");
        Mockito.when((Object)this.device.getAdminService()).thenReturn((Object)adminService);
        Mockito.when((Object)this.device.getName()).thenReturn((Object)"TestAppDevice");
        Mockito.when((Object)this.device.getPath()).thenReturn((Object)UriUtils.getUri((String[])new String[]{"TestAppDevice"}));
        ResourceImpl uninstallResource = builder.build((ModelInstance)this.modelInstance, adminService);
        Mockito.when((Object)adminService.getResource("UNINSTALL")).thenReturn((Object)uninstallResource);
        Mockito.when((Object)getResponse.getResponse("type")).thenReturn((Object)"int");
        Mockito.when((Object)this.resource.get("value", new Object[0])).thenReturn((Object)getResponse);
        Mockito.when((Object)session.resource(Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)this.resource);
        Mockito.when((Object)this.device.getName()).thenReturn((Object)"TestAppDevice");
        Mockito.when((Object)installer.getFunction((AppFunction)Mockito.any(AppFunction.class))).thenReturn((Object)new MockComponentIncrement(this.mediator));
        Mockito.when((Object)this.mediator.getService(serviceReference)).thenReturn((Object)installer);
        Mockito.when((Object)this.mediator.getServiceReferences(Mockito.anyString())).thenReturn((Object)serviceReferences);
        Mockito.when((Object)this.modelConfiguration.getResourceDescriptor()).thenReturn((Object)new ResourceDescriptor());
        Mockito.when((Object)this.modelInstance.configuration()).thenReturn((Object)this.modelConfiguration);
        Mockito.when((Object)this.modelInstance.getResourceBuilder((ResourceDescriptor)Mockito.any(ResourceDescriptor.class), Mockito.anyByte())).then((Answer)new Answer<ResourceBuilder>(){

            public ResourceBuilder answer(InvocationOnMock invocation) throws Throwable {
                return TestUtils.createResourceBuilder(TestComponentFactory.this.mediator, (ResourceDescriptor)invocation.getArguments()[0]);
            }
        });
        Mockito.when((Object)this.modelInstance.createResourceBuilder((ResourceDescriptor)Mockito.any(ResourceDescriptor.class))).then((Answer)new Answer<ResourceBuilder>(){

            public ResourceBuilder answer(InvocationOnMock invocation) throws Throwable {
                return TestUtils.createResourceBuilder(TestComponentFactory.this.mediator, (ResourceDescriptor)invocation.getArguments()[0]);
            }
        });
    }

    @Test
    public void testComponentCreation() {
        String content = null;
        try {
            content = TestUtils.readFile(this.getClass().getResourceAsStream("/test_factory.json"), Charset.defaultCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (content != null) {
            String name = new JSONObject(content).getJSONArray("parameters").getJSONObject(0).getString("value");
            JSONObject json = new JSONObject(content).getJSONArray("parameters").getJSONObject(1).getJSONObject("value");
            AppContainer container = new AppContainer(this.mediator, name, json);
            Assertions.assertNotNull((Object)container);
            ApplicationService service = null;
            try {
                service = new ApplicationService((ModelInstance)this.modelInstance, "Test", this.device);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Assertions.assertNotNull(service);
            Application application = null;
            try {
                application = ApplicationFactory.createApplication((AppServiceMediator)this.mediator, (AppContainer)container, (ServiceImpl)service);
            }
            catch (ApplicationFactoryException e) {
                e.printStackTrace();
            }
            Assertions.assertNotNull((Object)application);
            try {
                service.createSnaService(container, application);
            }
            catch (InvalidResourceException e) {
                e.printStackTrace();
            }
            catch (InvalidValueException e) {
                e.printStackTrace();
            }
            try {
                Field componentsField = Application.class.getDeclaredField("components");
                componentsField.setAccessible(true);
                Map components = (Map)componentsField.get(application);
                Assertions.assertTrue((components.size() == 1 ? 1 : 0) != 0);
                Assertions.assertNotNull(components.get("/simple_test/component1"));
                Assertions.assertTrue((boolean)(((Component)components.get("/simple_test/component1")).getProperty("register") instanceof RegisterPropertyBlock));
                Assertions.assertNotNull((Object)container.getResourceUris());
                Assertions.assertTrue((container.getResourceUris().size() == 2 ? 1 : 0) != 0);
                Assertions.assertTrue((boolean)container.getInitialize().getOptions().getAutoStart());
                Assertions.assertTrue((boolean)container.getInitialize().getOptions().getResetOnStop());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

