/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.application.dependency;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sensinact.gateway.app.manager.application.Application;
import org.eclipse.sensinact.gateway.app.manager.application.dependency.DependencyManagerAbstract;
import org.eclipse.sensinact.gateway.app.manager.application.dependency.DependencyManagerCallback;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.core.Core;
import org.eclipse.sensinact.gateway.core.message.MidAgentCallback;
import org.eclipse.sensinact.gateway.core.message.SnaFilter;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessage;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponse;
import org.eclipse.sensinact.gateway.core.method.DescribeResponse;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyManager
extends DependencyManagerAbstract {
    private static Logger LOG = LoggerFactory.getLogger(DependencyManager.class);
    private final Application application;
    private final Mediator mediator;
    private final Map<String, Boolean> dependenciesURIMap = new HashMap<String, Boolean>();
    private final Map<String, String> agentsIdDependency = new HashMap<String, String>();
    private final DependencyManagerCallback callback;
    private Boolean active = true;
    protected Core core;

    public DependencyManager(Application application, Mediator mediator, Collection<String> dependenciesURI, DependencyManagerCallback callback) {
        super(String.format("%s-dependencies", application.getName()));
        this.application = application;
        this.mediator = mediator;
        this.callback = callback;
        for (final String resourceUri : dependenciesURI) {
            mediator.callService(Core.class, (Executable)new Executable<Core, Void>(){

                public Void execute(Core core) {
                    DependencyManager.this.core = core;
                    String[] uriSplit = resourceUri.split("/");
                    String provider = uriSplit[1];
                    String service = uriSplit[2];
                    String resource = uriSplit[3];
                    DescribeResponse response = DependencyManager.this.application.getSession().getResource(provider, service, resource);
                    DependencyManager.this.dependenciesURIMap.put(resourceUri, response.getStatus() == AccessMethodResponse.Status.SUCCESS);
                    DependencyManager.this.evaluateDependencySatisfied();
                    return null;
                }
            });
        }
    }

    private Boolean isAllDependenciesAvailable() {
        for (Map.Entry<String, Boolean> entryDependency : this.dependenciesURIMap.entrySet()) {
            if (entryDependency.getValue().booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected void evaluateDependencySatisfied() {
        if (this.active.booleanValue()) {
            if (this.isAllDependenciesAvailable().booleanValue()) {
                try {
                    LOG.debug("Application '{}', all dependencies satisfied, notifying manager to start Application", (Object)this.application.getName());
                    this.callback.ready(this.application.getName());
                }
                catch (Exception e) {
                    LOG.warn("Application dependencies satistied, notification reception failed.", (Throwable)e);
                }
            } else {
                try {
                    LOG.debug("Application '{}', some dependencies are missing, notifying manager to stop Application", (Object)this.application.getName());
                    this.callback.unready(this.application.getName());
                }
                catch (Exception e) {
                    LOG.warn("Application dependencies NOT satistied any longer, notification reception failed.", (Throwable)e);
                }
            }
        }
    }

    public void doHandle(SnaLifecycleMessageImpl message) {
        LOG.debug("Application deployed '{}' reading event {}", (Object)this.application.getName(), (Object)message.getJSON());
        JSONObject messageJson = new JSONObject(message.getJSON());
        String messageType = messageJson.getString("type");
        if (messageType.equals(SnaLifecycleMessage.Lifecycle.RESOURCE_APPEARING.toString())) {
            LOG.debug("Application '{}' taking into account the availability of resource '{}'", (Object)this.application.getName(), (Object)message.getPath());
            this.dependenciesURIMap.put(message.getPath(), true);
            this.evaluateDependencySatisfied();
        } else if (messageType.equals(SnaLifecycleMessage.Lifecycle.RESOURCE_DISAPPEARING.toString())) {
            LOG.debug("Application '{}' taking into account the unavailability of resource '{}'", (Object)this.application.getName(), (Object)message.getPath());
            this.dependenciesURIMap.put(message.getPath(), false);
            this.evaluateDependencySatisfied();
        }
    }

    public void stop() {
        this.active = false;
        LOG.debug("Stopping Application Dependency Manager for application '{}'", (Object)this.application.getName());
    }

    public void start() {
        this.active = true;
        LOG.debug("Starting to Application Dependency Manager for application '{}'", (Object)this.application.getName());
        for (String resourceUri : this.dependenciesURIMap.keySet()) {
            SnaFilter filter = new SnaFilter(this.mediator, resourceUri, false, false);
            filter.addHandledType(SnaMessage.Type.LIFECYCLE);
            if (this.agentsIdDependency.get(resourceUri) == null) {
                LOG.debug("Application '{}' creating agent to monitor resource {} availability", (Object)this.application.getName(), (Object)resourceUri);
                String agentId = this.core.registerAgent(this.mediator, (MidAgentCallback)this, filter);
                this.agentsIdDependency.put(resourceUri, agentId);
                continue;
            }
            LOG.debug("Application '{}' agent to monitor resource {} availability already exist, skipping creation", (Object)this.application.getName(), (Object)resourceUri);
        }
    }
}

