/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.test;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.sensinact.gateway.app.api.exception.InvalidApplicationException;
import org.eclipse.sensinact.gateway.app.api.exception.ValidationException;
import org.eclipse.sensinact.gateway.app.manager.checker.ArchitectureChecker;
import org.eclipse.sensinact.gateway.app.manager.checker.JsonValidator;
import org.eclipse.sensinact.gateway.app.manager.json.AppComponent;
import org.eclipse.sensinact.gateway.app.manager.osgi.AppServiceMediator;
import org.eclipse.sensinact.gateway.app.manager.test.TestInstaller;
import org.eclipse.sensinact.gateway.app.manager.test.TestUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class TestAppChecker {
    private AppServiceMediator mediator = (AppServiceMediator)Mockito.mock(AppServiceMediator.class);

    @BeforeEach
    public void init() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        ServiceReference serviceReference = (ServiceReference)Mockito.mock(ServiceReference.class);
        ServiceReference[] serviceReferences = new ServiceReference[]{serviceReference};
        BundleContext context = (BundleContext)Mockito.mock(BundleContext.class);
        Bundle bundle = (Bundle)Mockito.mock(Bundle.class);
        TestInstaller installer = new TestInstaller(this.mediator, null);
        Mockito.when((Object)this.mediator.getService(serviceReference)).thenReturn((Object)installer);
        Mockito.when((Object)this.mediator.getServiceReferences(Mockito.anyString())).thenReturn((Object)serviceReferences);
        Mockito.when((Object)bundle.getResource(Mockito.anyString())).thenAnswer((Answer)new Answer<URL>(){

            public URL answer(InvocationOnMock invocationOnMock) throws Throwable {
                if (invocationOnMock.getArguments()[0].equals("/application.json")) {
                    return this.getClass().getResource("/application.json");
                }
                if (invocationOnMock.getArguments()[0].equals("/mock_addition.json")) {
                    return this.getClass().getResource("/mock_addition.json");
                }
                if (invocationOnMock.getArguments()[0].equals("/mock_set.json")) {
                    return this.getClass().getResource("/mock_set.json");
                }
                return null;
            }
        });
        Mockito.when((Object)context.getBundle()).thenReturn((Object)bundle);
        Mockito.when((Object)this.mediator.getContext()).thenReturn((Object)context);
    }

    @Test
    public void testUniqueOutput() throws Exception {
        String content = null;
        try {
            content = TestUtils.readFile(this.getClass().getResourceAsStream("/test_unique_output.json"), Charset.defaultCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        org.junit.jupiter.api.Assertions.assertNotNull(content);
        String applicationName = new JSONObject(content).getJSONArray("parameters").getJSONObject(0).getString("value");
        JSONObject json = new JSONObject(content).getJSONArray("parameters").getJSONObject(1).getJSONObject("value");
        ArrayList<AppComponent> components = new ArrayList<AppComponent>();
        JSONArray componentArray = json.getJSONArray("application");
        for (int i = 0; i < componentArray.length(); ++i) {
            components.add(new AppComponent(this.mediator, componentArray.getJSONObject(i)));
        }
        Assertions.assertThatThrownBy(() -> ArchitectureChecker.checkApplication((String)applicationName, (List)components)).isInstanceOf(InvalidApplicationException.class);
    }

    @Test
    public void testVariableExist() throws Exception {
        String content = null;
        try {
            content = TestUtils.readFile(this.getClass().getResourceAsStream("/test_variable_exist.json"), Charset.defaultCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        org.junit.jupiter.api.Assertions.assertNotNull(content);
        String applicationName = new JSONObject(content).getJSONArray("parameters").getJSONObject(0).getString("value");
        JSONObject json = new JSONObject(content).getJSONArray("parameters").getJSONObject(1).getJSONObject("value");
        ArrayList<AppComponent> components = new ArrayList<AppComponent>();
        JSONArray componentArray = json.getJSONArray("application");
        for (int i = 0; i < componentArray.length(); ++i) {
            components.add(new AppComponent(this.mediator, componentArray.getJSONObject(i)));
        }
        Assertions.assertThatThrownBy(() -> ArchitectureChecker.checkApplication((String)applicationName, (List)components)).isInstanceOf(InvalidApplicationException.class);
    }

    @Test
    @Disabled
    public void testInvalidJSONApplication() throws Exception {
        String content = null;
        try {
            content = TestUtils.readFile(this.getClass().getResourceAsStream("/test_invalid_json.json"), Charset.defaultCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        org.junit.jupiter.api.Assertions.assertNotNull(content);
        JSONObject json = new JSONObject(content).getJSONArray("parameters").getJSONObject(1).getJSONObject("value");
        Assertions.assertThatThrownBy(() -> JsonValidator.validateApplication((AppServiceMediator)this.mediator, (JSONObject)json)).isInstanceOf(ValidationException.class);
    }

    @Test
    @Disabled
    public void testValidJSONComponents() throws Exception {
        String content = null;
        try {
            content = TestUtils.readFile(this.getClass().getResourceAsStream("/test_instance.json"), Charset.defaultCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        org.junit.jupiter.api.Assertions.assertNotNull(content);
        JSONObject json = new JSONObject(content).getJSONArray("parameters").getJSONObject(1).getJSONObject("value");
        JsonValidator.validateFunctionsParameters((AppServiceMediator)this.mediator, (JSONArray)json.getJSONArray("application"));
    }
}

