/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.test;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.eclipse.sensinact.gateway.app.manager.osgi.AppServiceMediator;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.AttributeBuilder;
import org.eclipse.sensinact.gateway.core.ResourceBuilder;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.core.ResourceDescriptor;
import org.eclipse.sensinact.gateway.core.TypeConfig;
import org.eclipse.sensinact.gateway.util.IOUtils;

public class TestUtils {
    static ResourceBuilder createResourceBuilder(AppServiceMediator mediator, ResourceDescriptor descriptor) {
        ResourceConfig resourceConfig = new ResourceConfig();
        TypeConfig typeConfig = new TypeConfig(descriptor.resourceType());
        if (descriptor.resourceImplementationType() != null) {
            typeConfig.setImplementationClass(descriptor.resourceImplementationType());
        }
        resourceConfig.setTypeConfig(typeConfig);
        if (descriptor.updatePolicy() != null) {
            resourceConfig.setUpdatePolicy(descriptor.updatePolicy());
        }
        ResourceBuilder builder = new ResourceBuilder((Mediator)mediator, resourceConfig);
        if (descriptor.resourceName() != null) {
            builder.configureName(descriptor.resourceName());
        }
        if (descriptor.dataType() != null) {
            builder.configureType(descriptor.dataType());
        }
        if (descriptor.dataValue() != null) {
            builder.configureValue(descriptor.dataValue());
        }
        if (descriptor.modifiable() != null) {
            builder.configureRequirement("value", AttributeBuilder.Requirement.MODIFIABLE, (Object)descriptor.modifiable());
        }
        if (descriptor.hidden() != null) {
            builder.configureRequirement("value", AttributeBuilder.Requirement.HIDDEN, (Object)descriptor.hidden());
        }
        return builder;
    }

    public static String readFile(InputStream stream, Charset encoding) throws IOException {
        String output = new String(IOUtils.read((InputStream)stream, (int)stream.available(), (boolean)true), encoding);
        stream.close();
        return output;
    }
}

