/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Enumeration;
import org.eclipse.sensinact.gateway.app.api.plugin.PluginInstaller;
import org.eclipse.sensinact.gateway.app.manager.osgi.AppServiceMediator;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

class AppJsonSchemaListener
implements ServiceListener {
    private final AppServiceMediator mediator;
    private final ResourceImpl resource;
    private static final String APP_INSTALL_HOOK_FILTER = "(objectClass=" + PluginInstaller.class.getCanonicalName() + ")";

    AppJsonSchemaListener(AppServiceMediator mediator, ResourceImpl resource) {
        this.mediator = mediator;
        this.resource = resource;
        try {
            this.resource.getAttribute("value").setValue((Object)this.getJsonSchema());
        }
        catch (InvalidValueException e) {
            e.printStackTrace();
        }
        this.mediator.addServiceListener(this, APP_INSTALL_HOOK_FILTER);
    }

    public void stop() {
        this.mediator.removeServiceListener(this);
    }

    public void serviceChanged(ServiceEvent event) {
        try {
            this.resource.getAttribute("value").setValue((Object)this.getJsonSchema());
        }
        catch (InvalidValueException e) {
            e.printStackTrace();
        }
    }

    private JSONArray getJsonSchema() {
        ServiceReference<?>[] serviceReferences = this.mediator.getServiceReferences(APP_INSTALL_HOOK_FILTER);
        JSONArray pluginsKeywords = new JSONArray();
        if (serviceReferences != null) {
            for (ServiceReference<?> serviceReference : serviceReferences) {
                Enumeration enumFile = serviceReference.getBundle().findEntries("/", "*.json", false);
                if (enumFile == null) continue;
                while (enumFile.hasMoreElements()) {
                    try {
                        int read;
                        InputStream is = ((URL)enumFile.nextElement()).openStream();
                        int bufferLength = 1024;
                        int encodedLength = 0;
                        byte[] buffer = new byte[bufferLength];
                        byte[] encoded = new byte[encodedLength];
                        while ((read = is.read(buffer)) > 0) {
                            encoded = Arrays.copyOfRange(encoded, 0, encodedLength + read);
                            System.arraycopy(buffer, 0, encoded, encodedLength, read);
                            encodedLength += read;
                            if (read >= bufferLength) continue;
                            break;
                        }
                        pluginsKeywords.put((Object)new JSONObject(new String(encoded, Charset.defaultCharset())));
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return pluginsKeywords;
    }
}

