/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.basic.test;

import java.util.ArrayList;
import org.eclipse.sensinact.gateway.app.api.function.FunctionUpdateListener;
import org.eclipse.sensinact.gateway.app.basic.string.ConcatenateFunction;
import org.eclipse.sensinact.gateway.app.basic.string.SubstringFunction;
import org.eclipse.sensinact.gateway.app.manager.component.data.ConstantData;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestStringFunction {
    private static final Logger LOG = LoggerFactory.getLogger(TestStringFunction.class);
    private Mediator mediator = (Mediator)Mockito.mock(Mediator.class);
    private FunctionUpdateListener listener = (FunctionUpdateListener)Mockito.mock(FunctionUpdateListener.class);

    @BeforeEach
    public void init() throws Exception {
        Mockito.when((Object)LOG.isDebugEnabled()).thenReturn((Object)false);
    }

    public void testConcatenate() {
        ConcatenateFunction function = new ConcatenateFunction();
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)"This is a ", String.class));
        variables.add(new ConstantData((Object)"concatenation with the value ", String.class));
        variables.add(new ConstantData((Object)100, Integer.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)"This is a concatenation with the value 100");
    }

    public void testSubstringFromStart() {
        SubstringFunction function = new SubstringFunction();
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)"Something to substring", String.class));
        variables.add(new ConstantData((Object)13, Integer.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)"substring");
    }

    public void testSubstringStartEnd() {
        SubstringFunction function = new SubstringFunction();
        function.setListener(this.listener);
        ArrayList<ConstantData> variables = new ArrayList<ConstantData>();
        variables.add(new ConstantData((Object)"Something to substring", String.class));
        variables.add(new ConstantData((Object)0, Integer.class));
        variables.add(new ConstantData((Object)9, Integer.class));
        function.process(variables);
        ((FunctionUpdateListener)Mockito.verify((Object)this.listener)).updatedResult((Object)"Something");
    }
}

