/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.basic.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import org.eclipse.sensinact.gateway.app.api.function.FunctionUpdateListener;
import org.eclipse.sensinact.gateway.app.api.plugin.PluginHook;
import org.eclipse.sensinact.gateway.app.basic.sna.ActActionFunction;
import org.eclipse.sensinact.gateway.app.basic.sna.SetActionFunction;
import org.eclipse.sensinact.gateway.app.basic.test.DisplayActionResource;
import org.eclipse.sensinact.gateway.app.basic.test.StateActionResource;
import org.eclipse.sensinact.gateway.app.manager.component.data.ConstantData;
import org.eclipse.sensinact.gateway.app.manager.component.data.ResourceData;
import org.eclipse.sensinact.gateway.app.manager.osgi.AppServiceMediator;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.core.ModelConfiguration;
import org.eclipse.sensinact.gateway.core.ModelConfigurationBuilder;
import org.eclipse.sensinact.gateway.core.ModelInstance;
import org.eclipse.sensinact.gateway.core.ModelInstanceBuilder;
import org.eclipse.sensinact.gateway.core.PropertyResource;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.ResourceBuilder;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModel;
import org.eclipse.sensinact.gateway.core.ServiceBuilder;
import org.eclipse.sensinact.gateway.core.ServiceImpl;
import org.eclipse.sensinact.gateway.core.ServiceProviderImpl;
import org.eclipse.sensinact.gateway.core.Session;
import org.eclipse.sensinact.gateway.core.TypeConfig;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponse;
import org.eclipse.sensinact.gateway.core.method.ActResponse;
import org.eclipse.sensinact.gateway.core.method.DescribeMethod;
import org.eclipse.sensinact.gateway.core.method.DescribeResponse;
import org.eclipse.sensinact.gateway.core.method.SetResponse;
import org.eclipse.sensinact.gateway.core.security.AccessLevelOption;
import org.eclipse.sensinact.gateway.core.security.AccessProfileOption;
import org.eclipse.sensinact.gateway.core.security.AccessTree;
import org.eclipse.sensinact.gateway.core.security.AccessTreeImpl;
import org.eclipse.sensinact.gateway.core.security.AuthorizationService;
import org.eclipse.sensinact.gateway.core.security.SecuredAccess;
import org.eclipse.sensinact.gateway.security.signature.api.BundleValidation;
import org.eclipse.sensinact.gateway.security.signature.exception.BundleValidationException;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSnaFunction {
    private static final Logger LOG = LoggerFactory.getLogger(TestSnaFunction.class);
    private String lightState;
    private String displayText;
    private Integer displayTimeout;
    private AppServiceMediator mediator = (AppServiceMediator)Mockito.mock(AppServiceMediator.class);
    private ModelInstance modelInstance;
    private Session session = (Session)Mockito.mock(Session.class);
    private PropertyResource dimResource;

    @BeforeEach
    public void init() throws Exception {
        AuthorizationService authorization = (AuthorizationService)Mockito.mock(AuthorizationService.class);
        SecuredAccess securedAccess = (SecuredAccess)Mockito.mock(SecuredAccess.class);
        Mockito.when((Object)this.mediator.callService((Class)Mockito.any(Class.class), (Executable)Mockito.any(Executable.class))).thenReturn((Object)new BundleValidation(){

            public String check(Bundle bundle) throws BundleValidationException {
                return "xxxxxxxxxxx00000000";
            }
        });
        Mockito.when((Object)authorization.getAuthenticatedAccessLevelOption(Mockito.anyString(), Mockito.anyLong())).thenReturn((Object)AccessLevelOption.ANONYMOUS);
        Mockito.when((Object)authorization.getAuthenticatedAccessLevelOption(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)AccessLevelOption.ANONYMOUS);
        Mockito.when((Object)securedAccess.getAccessTree((String)Mockito.any(String.class))).thenReturn((Object)new AccessTreeImpl().withAccessProfile(AccessProfileOption.ALL_ANONYMOUS));
        BundleContext context = (BundleContext)Mockito.mock(BundleContext.class);
        final ServiceReference reference = (ServiceReference)Mockito.mock(ServiceReference.class);
        final ServiceReference referenceAuth = (ServiceReference)Mockito.mock(ServiceReference.class);
        Mockito.when((Object)context.getServiceReferences((Class)Mockito.any(Class.class), Mockito.anyString())).thenAnswer((Answer)new Answer<Object>(){

            public Collection<ServiceReference<?>> answer(InvocationOnMock invocation) throws Throwable {
                if (SecuredAccess.class.isAssignableFrom((Class)invocation.getArguments()[0])) {
                    return Collections.singletonList(reference);
                }
                if (AuthorizationService.class.isAssignableFrom((Class)invocation.getArguments()[0])) {
                    return Collections.singletonList(referenceAuth);
                }
                return null;
            }
        });
        Mockito.when((Object)context.getServiceReferences(Mockito.anyString(), Mockito.anyString())).thenAnswer((Answer)new Answer<ServiceReference<?>[]>(){

            public ServiceReference<?>[] answer(InvocationOnMock invocation) throws Throwable {
                if (SecuredAccess.class.getCanonicalName().equals(invocation.getArguments()[0])) {
                    return new ServiceReference[]{reference};
                }
                if (AuthorizationService.class.getCanonicalName().equals(invocation.getArguments()[0])) {
                    return new ServiceReference[]{referenceAuth};
                }
                return null;
            }
        });
        Mockito.when((Object)context.getServiceReference((Class)Mockito.eq(SecuredAccess.class))).thenReturn((Object)reference);
        Mockito.when((Object)context.getServiceReference((Class)Mockito.eq(AuthorizationService.class))).thenReturn((Object)referenceAuth);
        Mockito.when((Object)((SecuredAccess)context.getService(reference))).thenReturn((Object)securedAccess);
        Mockito.when((Object)((AuthorizationService)context.getService(referenceAuth))).thenReturn((Object)authorization);
        ServiceRegistration registration = (ServiceRegistration)Mockito.mock(ServiceRegistration.class);
        Mockito.when((Object)context.registerService((Class)Mockito.eq(SensiNactResourceModel.class), (Object)((SensiNactResourceModel)Mockito.any(SensiNactResourceModel.class)), (Dictionary)Mockito.any(Dictionary.class))).thenReturn((Object)registration);
        Mockito.when((Object)context.registerService((String)Mockito.eq((Object)SensiNactResourceModel.class.getCanonicalName()), Mockito.any(SensiNactResourceModel.class), (Dictionary)Mockito.any(Dictionary.class))).thenReturn((Object)registration);
        BundleWiring wiring = (BundleWiring)Mockito.mock(BundleWiring.class);
        Mockito.when((Object)wiring.getClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
        Bundle bundle = (Bundle)Mockito.mock(Bundle.class);
        Mockito.when((Object)((BundleWiring)bundle.adapt((Class)Mockito.eq(BundleWiring.class)))).thenReturn((Object)wiring);
        Mockito.when((Object)bundle.getState()).thenReturn((Object)32);
        Mockito.when((Object)bundle.getSymbolicName()).thenReturn((Object)"fakeBundle");
        Mockito.when((Object)context.getBundle()).thenReturn((Object)bundle);
        this.mediator = new AppServiceMediator(context);
        this.modelInstance = new ModelInstanceBuilder((Mediator)this.mediator).build("SimulatedLight_001", null, new ModelConfigurationBuilder((Mediator)this.mediator, ModelConfiguration.class, ModelInstance.class).withStartAtInitializationTime(true).build(new Object[0]));
        ServiceProviderImpl serviceProvider = this.modelInstance.getRootElement();
        ServiceImpl service = serviceProvider.addService("LightService_SimulatedLight_001");
        ResourceImpl resource = service.addDataResource(PropertyResource.class, "DIM", Integer.TYPE, (Object)0);
        this.dimResource = (PropertyResource)resource.getProxy((AccessTree)new AccessTreeImpl().withAccessProfile(AccessProfileOption.ALL_ANONYMOUS));
        Mockito.when((Object)this.session.resource((String)Mockito.eq((Object)"SimulatedLight_001"), (String)Mockito.eq((Object)"LightService_SimulatedLight_001"), (String)Mockito.eq((Object)"TURN_ON"))).thenReturn((Object)new StateActionResource((Mediator)this.mediator, "TURN_ON", this));
        Mockito.when((Object)this.session.resource((String)Mockito.eq((Object)"SimulatedTV_001"), (String)Mockito.eq((Object)"DisplayService_SimulatedTV_001"), (String)Mockito.eq((Object)"DISPLAY"))).thenReturn((Object)new DisplayActionResource(this));
        Mockito.when((Object)this.session.resource((String)Mockito.eq((Object)"SimulatedLight_001"), (String)Mockito.eq((Object)"LightService_SimulatedLight_001"), (String)Mockito.eq((Object)"DIM"))).thenReturn((Object)this.dimResource);
        Mockito.when((Object)this.session.getResource((String)Mockito.eq((Object)"SimulatedLight_001"), (String)Mockito.eq((Object)"LightService_SimulatedLight_001"), (String)Mockito.eq((Object)"TURN_ON"))).thenReturn((Object)new DescribeResponse<JSONObject>("/SimulatedLight_001/LightService_SimulatedLight_001/TURN_ON", AccessMethodResponse.Status.SUCCESS, DescribeMethod.DescribeType.RESOURCE){
            {
                this.putValue("response", new JSONObject().put("type", (Object)Resource.Type.ACTION.name()));
            }
        });
        Mockito.when((Object)this.session.getResource((String)Mockito.eq((Object)"SimulatedTV_001"), (String)Mockito.eq((Object)"DisplayService_SimulatedTV_001"), (String)Mockito.eq((Object)"DISPLAY"))).thenReturn((Object)new DescribeResponse<JSONObject>("/SimulatedTV_001/DisplayService_SimulatedTV_001/DISPLAY", AccessMethodResponse.Status.SUCCESS, DescribeMethod.DescribeType.RESOURCE){
            {
                this.putValue("response", new JSONObject().put("type", (Object)Resource.Type.ACTION.name()));
            }
        });
        Mockito.when((Object)this.session.getResource((String)Mockito.eq((Object)"SimulatedLight_001"), (String)Mockito.eq((Object)"LightService_SimulatedLight_001"), (String)Mockito.eq((Object)"DIM"))).thenReturn((Object)new DescribeResponse<JSONObject>("/SimulatedLight_001/LightService_SimulatedLight_001/DIM", AccessMethodResponse.Status.SUCCESS, DescribeMethod.DescribeType.RESOURCE){
            {
                this.putValue("response", new JSONObject().put("type", (Object)Resource.Type.PROPERTY.name()));
            }
        });
        final ActResponse actionResponse = (ActResponse)Mockito.mock(ActResponse.class);
        Mockito.when((Object)this.session.act((String)Mockito.eq((Object)"SimulatedLight_001"), (String)Mockito.eq((Object)"LightService_SimulatedLight_001"), (String)Mockito.eq((Object)"TURN_ON"), (Object[])Mockito.any(Object[].class))).thenAnswer((Answer)new Answer<ActResponse>(){

            public ActResponse answer(InvocationOnMock invocation) throws Throwable {
                TestSnaFunction.this.setState("TURN_ON");
                return actionResponse;
            }
        });
        Mockito.when((Object)this.session.act((String)Mockito.eq((Object)"SimulatedTV_001"), (String)Mockito.eq((Object)"DisplayService_SimulatedTV_001"), (String)Mockito.eq((Object)"DISPLAY"), (Object[])Mockito.any(Object[].class))).thenAnswer((Answer)new Answer<ActResponse>(){

            public ActResponse answer(InvocationOnMock invocation) throws Throwable {
                Object[] objects = (Object[])invocation.getArguments()[3];
                TestSnaFunction.this.setDisplay((String)objects[0], (Integer)objects[1]);
                return actionResponse;
            }
        });
        final SetResponse setResponse = (SetResponse)Mockito.mock(SetResponse.class);
        Mockito.when((Object)this.session.set((String)Mockito.eq((Object)"SimulatedLight_001"), (String)Mockito.eq((Object)"LightService_SimulatedLight_001"), (String)Mockito.eq((Object)"DIM"), Mockito.anyString(), Mockito.any(Object[].class), new Object[0])).thenAnswer((Answer)new Answer<SetResponse>(){

            public SetResponse answer(InvocationOnMock invocation) throws Throwable {
                Object[] objects = invocation.getArguments();
                TestSnaFunction.this.dimResource.set(objects[4], new Object[0]);
                return setResponse;
            }
        });
    }

    public void testActActionNoParameters() {
        this.lightState = null;
        ActActionFunction function = new ActActionFunction();
        function.setListener(new FunctionUpdateListener(){

            public void updatedResult(Object result) {
                Assertions.assertTrue((boolean)(result instanceof PluginHook));
            }
        });
        ArrayList<ResourceData> variables = new ArrayList<ResourceData>();
        variables.add(new ResourceData(this.session, "/SimulatedLight_001/LightService_SimulatedLight_001/TURN_ON"));
        function.process(variables);
        function.fireHook();
        Assertions.assertTrue((boolean)this.lightState.equals("TURN_ON"));
    }

    public void testActActionWithParameters() {
        this.displayText = null;
        this.displayTimeout = null;
        ActActionFunction function = new ActActionFunction();
        function.setListener(new FunctionUpdateListener(){

            public void updatedResult(Object result) {
                Assertions.assertTrue((boolean)(result instanceof PluginHook));
            }
        });
        ArrayList<Object> variables = new ArrayList<Object>();
        variables.add(new ResourceData(this.session, "/SimulatedTV_001/DisplayService_SimulatedTV_001/DISPLAY"));
        variables.add(new ConstantData((Object)"Welcome", String.class));
        variables.add(new ConstantData((Object)10, Integer.class));
        function.process(variables);
        function.fireHook();
        Assertions.assertTrue((boolean)this.displayText.equals("Welcome"));
        Assertions.assertTrue((boolean)this.displayTimeout.equals(10));
    }

    public void testSetAction() {
        SetActionFunction function = new SetActionFunction();
        function.setListener(new FunctionUpdateListener(){

            public void updatedResult(Object result) {
                Assertions.assertTrue((boolean)(result instanceof PluginHook));
            }
        });
        ArrayList<Object> variables = new ArrayList<Object>();
        variables.add(new ResourceData(this.session, "/SimulatedLight_001/LightService_SimulatedLight_001/DIM"));
        variables.add(new ConstantData((Object)10, Integer.class));
        function.process(variables);
        function.fireHook();
        Assertions.assertTrue((boolean)this.dimResource.get(new Object[0]).getResponse("value").equals(10));
    }

    public void setState(String action) {
        this.lightState = action;
    }

    public void setDisplay(String text, Integer timeout) {
        this.displayText = text;
        this.displayTimeout = timeout;
    }

    public ServiceBuilder createServiceBuilder() {
        ServiceBuilder builder = new ServiceBuilder((Mediator)this.mediator, ServiceImpl.class);
        builder.configureImplementationClass(ServiceImpl.class);
        return builder;
    }

    public ResourceBuilder createResourceBuilder(Class<? extends Resource> implementationInterface) {
        ResourceConfig resourceConfig = new ResourceConfig();
        Class<? extends Resource> resourceType = implementationInterface;
        if (resourceType == null) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Unable to create a resource builder : null resource type");
            }
            return null;
        }
        TypeConfig typeConfig = new TypeConfig(resourceType);
        resourceConfig.setTypeConfig(typeConfig);
        ResourceBuilder builder = new ResourceBuilder((Mediator)this.mediator, resourceConfig);
        return builder;
    }
}

