/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.constraint;

import java.util.logging.Level;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.constraint.ConstraintOnCollection;
import org.eclipse.sensinact.gateway.common.constraint.InvalidConstraintDefinitionException;
import org.eclipse.sensinact.gateway.util.CastUtils;

public class Contains<T>
extends ConstraintOnCollection<T> {
    public static final String OPERATOR = "in";

    public Contains(Class<T> operandClass, Object operand, boolean complement) throws InvalidConstraintDefinitionException {
        super(OPERATOR, operandClass, operand, complement);
    }

    @Override
    public boolean complies(Object value) {
        boolean complies = false;
        Object castedValue = null;
        try {
            castedValue = CastUtils.cast(this.operandClass, (Object)value);
        }
        catch (ClassCastException e) {
            return complies;
        }
        for (int index = 0; index < this.operand.length; ++index) {
            if (!castedValue.equals(this.operand[index])) continue;
            complies = true;
            break;
        }
        return complies ^ this.isComplement();
    }

    @Override
    public Constraint getComplement() {
        Contains complement = null;
        try {
            complement = new Contains(this.operandClass, this.operand, !this.complement);
        }
        catch (InvalidConstraintDefinitionException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return complement;
    }
}

