/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.constraint;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.constraint.InvalidConstraintDefinitionException;
import org.eclipse.sensinact.gateway.util.CastUtils;

public class Delta
implements Constraint {
    protected static final Logger LOGGER = Logger.getLogger(Delta.class.getCanonicalName());
    public static final String OPERATOR = "diff";
    private final double delta;
    private final double referenceValue;
    private final boolean complement;

    public Delta(Object delta, Object referenceValue, boolean complement) throws InvalidConstraintDefinitionException {
        this.complement = complement;
        try {
            double deltaValue = Math.abs((Double)CastUtils.cast(Double.TYPE, (Object)delta));
            this.delta = deltaValue > 100.0 ? deltaValue - 100.0 : deltaValue;
            this.referenceValue = (Double)CastUtils.cast(Double.TYPE, (Object)referenceValue);
        }
        catch (ClassCastException e) {
            throw new InvalidConstraintDefinitionException("Unable to cast delta and referenceValue arguments into double values");
        }
        catch (NullPointerException e) {
            throw new InvalidConstraintDefinitionException("delta and referenceValue arguments must be not null");
        }
    }

    @Override
    public boolean complies(Object value) {
        boolean complies = false;
        double doubleValue = 0.0;
        try {
            doubleValue = (Double)CastUtils.cast(Double.TYPE, (Object)value);
        }
        catch (Exception e) {
            return complies;
        }
        complies = Math.abs(100.0 - Math.abs(100.0 * doubleValue / this.referenceValue)) >= this.delta;
        return complies ^ this.isComplement();
    }

    @Override
    public String getOperator() {
        return OPERATOR;
    }

    @Override
    public boolean isComplement() {
        return this.complement;
    }

    @Override
    public String getJSON() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        builder.append('\"');
        builder.append("operator");
        builder.append('\"');
        builder.append(':');
        builder.append('\"');
        builder.append(this.getOperator());
        builder.append('\"');
        builder.append(',');
        builder.append('\"');
        builder.append("complement");
        builder.append('\"');
        builder.append(':');
        builder.append(this.complement);
        builder.append(',');
        builder.append('\"');
        builder.append("operand");
        builder.append('\"');
        builder.append(':');
        builder.append('[');
        builder.append(this.delta);
        builder.append(',');
        builder.append(this.referenceValue);
        builder.append(']');
        builder.append('}');
        return builder.toString();
    }

    @Override
    public Constraint getComplement() {
        Delta complement = null;
        try {
            complement = new Delta(this.delta, this.referenceValue, !this.complement);
        }
        catch (InvalidConstraintDefinitionException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return complement;
    }
}

