/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.constraint.test;

import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.constraint.ConstraintFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.skyscreamer.jsonassert.JSONAssert;

public class ConstraintTest {
    public static final String EXPRESSION = "[\"AND\",{\"operator\":\"-\",\"operand\":14, \"complement\":false},{\"operator\":\"regex\",\"operand\":\"(0033)[0-9]{9}\",\"complement\":false}]";
    public static final String COLLECTION = "{\"operator\":\"in\",\"operand\":[\"a\",\"b\",18,3], \"type\":\"string\", \"complement\":false}";
    public static final String RETURNED_COLLECTION = "{\"operator\":\"in\",\"operand\":[\"a\",\"b\",\"18\",\"3\"], \"type\":\"string\", \"complement\":false}";
    public static final String ABSOLUTE = "{\"operator\":\"abs\",\"operand\":[5,18], \"complement\":false}";
    public static final String RETURNED_ABSOLUTE = "{\"operator\":\"abs\",\"operand\":[5.0,18.0], \"complement\":false}";
    private static final String LOG_FILTER = "(objectClass=" + LogService.class.getCanonicalName() + ")";
    private static final String MOCK_BUNDLE_NAME = "MockedBundle";
    private static final long MOCK_BUNDLE_ID = 1L;
    private final BundleContext context = (BundleContext)Mockito.mock(BundleContext.class);
    private final Bundle bundle = (Bundle)Mockito.mock(Bundle.class);

    @BeforeEach
    public void init() throws InvalidSyntaxException {
        Filter filter = (Filter)Mockito.mock(Filter.class);
        Mockito.when((Object)filter.toString()).thenReturn((Object)LOG_FILTER);
        Mockito.when((Object)this.context.createFilter(LOG_FILTER)).thenReturn((Object)filter);
        Mockito.when((Object)this.context.getServiceReferences((String)Mockito.eq(null), (String)Mockito.eq((Object)LOG_FILTER))).thenReturn(null);
        Mockito.when((Object)this.context.getServiceReference(LOG_FILTER)).thenReturn(null);
        Mockito.when((Object)this.context.getServiceReferences(Mockito.anyString(), Mockito.anyString())).then((Answer)new Answer<ServiceReference<?>[]>(){

            public ServiceReference<?>[] answer(InvocationOnMock invocation) throws Throwable {
                Object[] arguments = invocation.getArguments();
                if (arguments == null || arguments.length != 2) {
                    return null;
                }
                return null;
            }
        });
        Mockito.when((Object)this.context.getService((ServiceReference)Mockito.any(ServiceReference.class))).then((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] arguments = invocation.getArguments();
                if (arguments == null || arguments.length != 1) {
                    return null;
                }
                return null;
            }
        });
        Mockito.when((Object)this.context.getBundle()).thenReturn((Object)this.bundle);
        Mockito.when((Object)this.bundle.getSymbolicName()).thenReturn((Object)MOCK_BUNDLE_NAME);
        Mockito.when((Object)this.bundle.getBundleId()).thenReturn((Object)1L);
    }

    @Test
    public void testFactory() throws Exception {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        Constraint constraint = ConstraintFactory.Loader.load((ClassLoader)classloader, (JSONArray)new JSONArray(EXPRESSION));
        Assertions.assertTrue((boolean)constraint.complies((Object)"0033921976095"));
        Assertions.assertFalse((boolean)constraint.complies((Object)"0033aa9976095"));
        Assertions.assertFalse((boolean)constraint.complies((Object)"003368997609544"));
        JSONAssert.assertEquals((String)EXPRESSION, (String)constraint.getJSON(), (boolean)false);
        constraint = ConstraintFactory.Loader.load((ClassLoader)classloader, (JSONObject)new JSONObject(COLLECTION));
        Assertions.assertTrue((boolean)constraint.complies((Object)"3"));
        Assertions.assertTrue((boolean)constraint.complies((Object)"a"));
        Assertions.assertFalse((boolean)constraint.complies((Object)"d"));
        JSONAssert.assertEquals((String)RETURNED_COLLECTION, (String)constraint.getJSON(), (boolean)false);
        constraint = constraint.getComplement();
        Assertions.assertFalse((boolean)constraint.complies((Object)"3"));
        Assertions.assertFalse((boolean)constraint.complies((Object)"a"));
        Assertions.assertTrue((boolean)constraint.complies((Object)"d"));
        constraint = ConstraintFactory.Loader.load((ClassLoader)classloader, (JSONObject)new JSONObject(ABSOLUTE));
        Assertions.assertTrue((boolean)constraint.complies((Object)23));
        Assertions.assertTrue((boolean)constraint.complies((Object)25));
        Assertions.assertTrue((boolean)constraint.complies((Object)13));
        Assertions.assertTrue((boolean)constraint.complies((Object)10));
        Assertions.assertFalse((boolean)constraint.complies((Object)17));
        Assertions.assertFalse((boolean)constraint.complies((Object)18));
        Assertions.assertFalse((boolean)constraint.complies((Object)16));
        JSONAssert.assertEquals((String)RETURNED_ABSOLUTE, (String)constraint.getJSON(), (boolean)false);
    }
}

