/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.constraint;

import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.logging.Logger;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.constraint.InvalidConstraintDefinitionException;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.eclipse.sensinact.gateway.util.JSONUtils;

public abstract class ConstraintOnCollection<T>
implements Constraint {
    protected static final Logger LOGGER = Logger.getLogger(ConstraintOnCollection.class.getCanonicalName());
    protected final String operator;
    protected final boolean complement;
    protected final T[] operand;
    protected Class<T> operandClass;

    public ConstraintOnCollection(String operator, T[] operand, boolean complement) throws InvalidConstraintDefinitionException {
        this.operator = operator;
        if (operand == null) {
            throw new InvalidConstraintDefinitionException("operand argument is required");
        }
        this.operand = operand;
        this.operandClass = this.operand.getClass().getComponentType();
        this.complement = complement;
    }

    public ConstraintOnCollection(String operator, Class<T> operandClass, Object operand, boolean complement) throws InvalidConstraintDefinitionException {
        if (operandClass == null) {
            throw new InvalidConstraintDefinitionException("type is required");
        }
        this.operator = operator;
        this.complement = complement;
        if (operand == null) {
            if (operandClass.isEnum()) {
                this.operandClass = operandClass;
                this.operand = operandClass.getEnumConstants();
                return;
            }
            throw new InvalidConstraintDefinitionException("If the operand argument is null the type must be an Enum one");
        }
        if (operandClass.isArray()) {
            this.operandClass = operandClass.getComponentType();
        } else if (Collection.class.isAssignableFrom(operandClass)) {
            Type[] interfaces = operandClass.getGenericInterfaces();
            Class generic = null;
            for (Type genericInterface : interfaces) {
                try {
                    ParameterizedType parameterized = (ParameterizedType)genericInterface;
                    if (!Collection.class.isAssignableFrom((Class)parameterized.getRawType())) continue;
                    generic = (Class)parameterized.getActualTypeArguments()[0];
                    break;
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
            }
            if (generic == null) {
                throw new InvalidConstraintDefinitionException("Unable to retrieve the type from the specified extended Collection one");
            }
            this.operandClass = generic;
        } else {
            this.operandClass = operandClass;
        }
        Class<T> castedOperandClass = CastUtils.primitiveToComparable(this.operandClass);
        this.operandClass = castedOperandClass != null ? castedOperandClass : this.operandClass;
        try {
            this.operand = (Object[])CastUtils.castArray(((Object[])Array.newInstance(this.operandClass, 0)).getClass(), (Object)operand);
        }
        catch (ClassCastException e) {
            throw new InvalidConstraintDefinitionException(e);
        }
    }

    @Override
    public String getOperator() {
        return this.operator;
    }

    @Override
    public boolean isComplement() {
        return this.complement;
    }

    @Override
    public String getJSON() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        builder.append('\"');
        builder.append("operator");
        builder.append('\"');
        builder.append(':');
        builder.append('\"');
        builder.append(this.getOperator());
        builder.append('\"');
        builder.append(',');
        builder.append('\"');
        builder.append("type");
        builder.append('\"');
        builder.append(':');
        builder.append('\"');
        builder.append(CastUtils.writeClass(this.operandClass));
        builder.append('\"');
        builder.append(',');
        builder.append('\"');
        builder.append("complement");
        builder.append('\"');
        builder.append(':');
        builder.append(this.complement);
        builder.append(',');
        builder.append('\"');
        builder.append("operand");
        builder.append('\"');
        builder.append(':');
        builder.append(JSONUtils.toJSONFormat(this.operand));
        builder.append('}');
        return builder.toString();
    }
}

