/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.primitive;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.common.primitive.Nameable;
import org.eclipse.sensinact.gateway.common.primitive.PathElement;
import org.eclipse.sensinact.gateway.util.UriUtils;

public abstract class Elements<P extends Nameable>
implements Nameable,
PathElement {
    protected List<P> elements;
    protected final String uri;
    protected final String name;

    protected Elements(String uri) {
        this.uri = uri;
        this.name = UriUtils.getLeaf((String)uri);
        this.elements = new ArrayList<P>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int length() {
        List<P> list = this.elements;
        synchronized (list) {
            return this.elements.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P element(String name) {
        if (name == null) {
            return null;
        }
        List<P> list = this.elements;
        synchronized (list) {
            return (P)((Nameable)this.elements.stream().filter(p -> name.equals(p.getName())).findFirst().orElse(null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P element(int index) {
        if (index < this.elements.size()) {
            return null;
        }
        Nameable element = null;
        List<P> list = this.elements;
        synchronized (list) {
            element = (Nameable)this.elements.get(index);
        }
        return (P)element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addElement(P element) {
        if (element == null) {
            return false;
        }
        String name = element.getName();
        if (name == null) {
            return false;
        }
        List<P> list = this.elements;
        synchronized (list) {
            if (this.elements.stream().noneMatch(p -> name.equals(p.getName()))) {
                return this.elements.add(element);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P removeElement(String element) {
        if (element == null) {
            return null;
        }
        List<P> list = this.elements;
        synchronized (list) {
            Iterator<P> iterator = this.elements.iterator();
            while (iterator.hasNext()) {
                Nameable p = (Nameable)iterator.next();
                if (!element.equals(p.getName())) continue;
                iterator.remove();
                return (P)p;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected P removeElement(int index) {
        if (index < this.elements.size()) {
            return null;
        }
        List<P> list = this.elements;
        synchronized (list) {
            return (P)((Nameable)this.elements.remove(index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <O> O search(String uri) {
        String[] uriElements = UriUtils.getUriElements((String)uri);
        int length = uriElements.length;
        Nameable found = null;
        if (length == 0 || !this.getName().equals(uriElements[0])) {
            return (O)found;
        }
        if (length == 1) {
            return (O)this;
        }
        String childUri = UriUtils.getChildUri((String)uri);
        List<P> list = this.elements;
        synchronized (list) {
            for (int index = 0; index < this.elements.size(); ++index) {
                Nameable element = (Nameable)this.elements.get(index);
                if (!element.getName().equals(uriElements[1])) continue;
                if (Elements.class.isAssignableFrom(element.getClass())) {
                    found = ((Elements)element).search(childUri);
                    break;
                }
                found = element;
                break;
            }
        }
        return (O)found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(Executable<P, Void> executor) throws Exception {
        List<P> list = this.elements;
        synchronized (list) {
            int length = this.elements.size();
            for (int index = 0; index < length; ++index) {
                executor.execute((Nameable)this.elements.get(index));
            }
        }
    }

    public Enumeration<P> elements() {
        return new SnaModelElementEnumeration();
    }

    private final class SnaModelElementEnumeration
    implements Enumeration<P> {
        int position = 0;
        Object[] elementArray;

        private SnaModelElementEnumeration() {
            this.elementArray = Elements.this.elements.toArray(new Object[0]);
        }

        @Override
        public boolean hasMoreElements() {
            return this.position < this.elementArray.length;
        }

        @Override
        public P nextElement() {
            if (!this.hasMoreElements()) {
                return null;
            }
            return (Nameable)this.elementArray[this.position++];
        }
    }
}

