/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.props;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.primitive.JSONable;
import org.eclipse.sensinact.gateway.common.props.KeysCollection;
import org.eclipse.sensinact.gateway.common.props.TypedKey;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.eclipse.sensinact.gateway.util.JSONUtils;

public abstract class TypedProperties<T extends Enum<T>>
implements JSONable {
    protected static final String TYPE = "type";
    private final Map<String, Map.Entry<TypedKey<?>, Object>> properties = new HashMap();
    private final T type;

    public TypedProperties(T type) {
        this.type = type;
        this.putValue(TYPE, type);
    }

    @Override
    public String getJSON() {
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<TypedKey<?>, Object>> iterator = this.properties.values().iterator();
        builder.append('{');
        int index = 0;
        while (iterator.hasNext()) {
            Map.Entry<TypedKey<?>, Object> entry = iterator.next();
            TypedKey<?> typedKey = entry.getKey();
            if (typedKey.isHidden()) continue;
            builder.append(index > 0 ? Character.valueOf(',') : "");
            builder.append('\"');
            builder.append(typedKey.getName());
            builder.append('\"');
            builder.append(':');
            builder.append(JSONUtils.toJSONFormat((Object)entry.getValue()));
            ++index;
        }
        builder.append('}');
        return builder.toString();
    }

    protected void putValue(TypedKey<?> key, Object value) {
        this.properties.put(key.getName(), new TypedKeyValue(key, value));
    }

    protected void putValue(String key, Object value) {
        this.putValue(key, value, false);
    }

    protected void putValue(String key, Object value, boolean hidden) {
        TypedKey<Object> typedKey = ((KeysCollection)this.getType()).key(key);
        if (typedKey == null) {
            typedKey = new TypedKey<Object>(key, Object.class, hidden);
        }
        this.putValue(typedKey, value);
    }

    public void put(String key, Object value) {
        this.put(key, value, false);
    }

    public void put(String key, Object value, boolean hidden) {
        if (this.notPresentInType(key)) {
            this.putValue(key, value, hidden);
        }
    }

    private boolean notPresentInType(String key) {
        return ((KeysCollection)this.getType()).keys().stream().noneMatch(k -> k.getName().equals(key));
    }

    public Object remove(String key) {
        Object value = null;
        if (this.notPresentInType(key)) {
            Map.Entry<TypedKey<?>, Object> e = this.properties.remove(key);
            value = e == null ? null : e.getValue();
        }
        return value;
    }

    public <V> V get(String key) {
        Object value;
        Map.Entry<TypedKey<?>, Object> e = this.properties.get(key);
        if (e == null) {
            return null;
        }
        Class<?> type = e.getKey().getType();
        if (!type.isInstance(value = e.getValue())) {
            return (V)CastUtils.cast(type, (Object)value);
        }
        return (V)e.getValue();
    }

    public T getType() {
        return this.type;
    }

    protected Iterator<Map.Entry<TypedKey<?>, Object>> typedKeyValues() {
        return this.properties.values().iterator();
    }

    private static class TypedKeyValue
    implements Map.Entry<TypedKey<?>, Object> {
        private final TypedKey<?> key;
        private final Object value;

        public TypedKeyValue(TypedKey<?> key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public TypedKey<?> getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException("Changing the value via the iterator is not supported");
        }
    }
}

