/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.bundle;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.sensinact.gateway.common.bundle.ManagedConfigurationListener;
import org.eclipse.sensinact.gateway.common.bundle.MediatorManagedConfiguration;
import org.eclipse.sensinact.gateway.common.bundle.ServiceCaller;
import org.eclipse.sensinact.gateway.common.bundle.TrackerCustomizer;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.util.PropertyUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mediator {
    private static final Logger LOG = LoggerFactory.getLogger(Mediator.class);
    public static final String DEFAULT_BUNDLE_PROPERTY_FILEDIR = "felix.fileinstall.dir";
    public static final String SENSINACT_CONFIG_FILE = "sensiNact-conf.xml";
    public final ThreadLocal<ServiceCaller> CALLERS = new ThreadLocal<ServiceCaller>(){

        @Override
        public ServiceCaller initialValue() {
            return new ServiceCaller(Mediator.this.getContext());
        }
    };
    protected Properties properties;
    protected BundleContext context;
    private Map<String, TrackerCustomizer<?>> customizers;
    private List<ServiceTracker<?, ?>> trackers;
    private List<ServiceRegistration<?>> registrations;
    private MediatorManagedConfiguration configuration;

    public Mediator(BundleContext context) {
        this.context = context;
        this.properties = new Properties();
        this.customizers = new HashMap();
        this.trackers = new ArrayList();
        this.registrations = new ArrayList();
        try {
            URL config = context.getBundle().getResource(SENSINACT_CONFIG_FILE);
            if (config != null) {
                InputStream input = config.openStream();
                this.properties.loadFromXML(input);
                input.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.loadBundleProperties();
        String managed = (String)this.getProperty("org.eclipse.sensinact.gateway.managed");
        if (managed != null && Boolean.parseBoolean(managed)) {
            this.configuration = new MediatorManagedConfiguration(this, context.getBundle().getSymbolicName().replace('-', '.'));
            this.configuration.register();
        }
    }

    private void loadBundleProperties() {
        String fileInstallDir = this.context.getProperty(DEFAULT_BUNDLE_PROPERTY_FILEDIR);
        if (fileInstallDir == null) {
            return;
        }
        LOG.info("Configuration directory %s", (Object)fileInstallDir);
        String symbolicName = this.context.getBundle().getSymbolicName();
        LOG.info("Bundle symbolic name %s", (Object)symbolicName);
        String bundlePropertyFileName = String.format("%s/%s.config", fileInstallDir, symbolicName);
        Boolean propertiesLoaded = Boolean.FALSE;
        Properties bundleProperties = new Properties();
        try {
            bundleProperties.load(new FileInputStream(bundlePropertyFileName));
            LOG.debug("File %s loaded successfully", (Object)bundlePropertyFileName);
            this.logBundleProperties(symbolicName, bundlePropertyFileName, bundleProperties);
            propertiesLoaded = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!propertiesLoaded.booleanValue()) {
            LOG.debug("bundle %s does not have custom configuration %s, using default values.", (Object)symbolicName, (Object)bundlePropertyFileName);
        }
        for (Map.Entry<Object, Object> name : bundleProperties.entrySet()) {
            this.properties.put(name.getKey().toString(), name.getValue().toString());
        }
    }

    private void logBundleProperties(String bundleName, String propertyFile, Properties properties) {
        LOG.debug("Loading properties for bundle %s located in %s", (Object)bundleName, (Object)propertyFile);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            LOG.info("%s:%s", entry.getKey(), entry.getValue());
        }
    }

    public void addListener(ManagedConfigurationListener listener) {
        if (this.configuration != null) {
            this.configuration.addListener(listener);
        }
    }

    public void deleteListener(ManagedConfigurationListener listener) {
        if (this.configuration != null) {
            this.configuration.deleteListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> void register(S service, Class<S> serviceType, Dictionary<String, ?> properties) {
        List<ServiceRegistration<?>> list = this.registrations;
        synchronized (list) {
            this.registrations.add(this.context.registerService(serviceType, service, properties));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Dictionary<String, ?> properties, Object service, Class<?>[] serviceTypes) {
        int length = serviceTypes == null ? 0 : serviceTypes.length;
        String[] types = new String[length];
        for (int index = 0; index < length; ++index) {
            types[index] = serviceTypes[index].getName();
        }
        List<ServiceRegistration<?>> list = this.registrations;
        synchronized (list) {
            this.registrations.add(this.context.registerService(types, service, properties));
        }
    }

    public <S, R> R callService(Class<S> serviceType, Executable<S, R> executable) {
        return this.callService(serviceType, null, executable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, R> R callService(Class<S> serviceType, String filter, Executable<S, R> executable) {
        ServiceCaller caller = this.CALLERS.get();
        caller.attach();
        try {
            R r = caller.callService(serviceType, filter, executable);
            return r;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (caller.release() == 0) {
                this.CALLERS.remove();
            }
        }
        return null;
    }

    public <S> void callServices(Class<S> serviceType, Executable<S, Void> executable) {
        this.callServices(serviceType, null, executable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> void callServices(Class<S> serviceType, String filter, Executable<S, Void> executable) {
        ServiceCaller caller = this.CALLERS.get();
        caller.attach();
        try {
            caller.callServices(serviceType, filter, executable);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (caller.release() == 0) {
                this.CALLERS.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, R> Collection<R> callServices(Class<S> serviceType, Class<R> returnType, String filter, Executable<S, R> executable) {
        ServiceCaller caller = this.CALLERS.get();
        caller.attach();
        try {
            Collection<R> collection = caller.callServices(serviceType, returnType, filter, executable);
            return collection;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (caller.release() == 0) {
                this.CALLERS.remove();
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> String attachOnServiceAppearing(Class<S> serviceType, String filter, List<Executable<S, Void>> executables) {
        String key = null;
        String trackingFilter = this.createFilter(serviceType, filter);
        TrackerCustomizer<Object> customizer = this.customizers.get(trackingFilter);
        if (customizer == null) {
            customizer = new TrackerCustomizer(this);
            this.customizers.put(trackingFilter, customizer);
            key = customizer.attachOnAdding(executables);
            ServiceTracker tracker = new ServiceTracker(this.context, serviceType.getCanonicalName(), customizer);
            List<ServiceTracker<?, ?>> list = this.trackers;
            synchronized (list) {
                this.trackers.add(tracker);
            }
            tracker.open();
        } else {
            key = customizer.attachOnAdding(executables);
        }
        return key;
    }

    public <S> String attachOnServiceAppearing(Class<S> serviceType, String filter, Executable<S, Void> executable) {
        return this.attachOnServiceAppearing(serviceType, filter, Collections.singletonList(executable));
    }

    public <S> void detachOnServiceAppearing(Class<S> serviceType, String filter, String key) {
        String trackingFilter = this.createFilter(serviceType, filter);
        TrackerCustomizer<?> customizer = this.customizers.get(trackingFilter);
        customizer.detachOnAdding(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> String attachOnServiceDisappearing(Class<S> serviceType, String filter, List<Executable<S, Void>> executables) {
        String key = null;
        String trackingFilter = this.createFilter(serviceType, filter);
        TrackerCustomizer<Object> customizer = this.customizers.get(trackingFilter);
        if (customizer == null) {
            customizer = new TrackerCustomizer(this);
            this.customizers.put(trackingFilter, customizer);
            key = customizer.attachOnRemoving(executables);
            ServiceTracker tracker = new ServiceTracker(this.context, trackingFilter, customizer);
            List<ServiceTracker<?, ?>> list = this.trackers;
            synchronized (list) {
                this.trackers.add(tracker);
            }
            tracker.open();
        } else {
            key = customizer.attachOnRemoving(executables);
        }
        return key;
    }

    public <S> String attachOnServiceDisappearing(Class<S> serviceType, String filter, Executable<S, Void> executable) {
        return this.attachOnServiceDisappearing(serviceType, filter, Collections.singletonList(executable));
    }

    public <S> void detachOnServiceDisappearing(Class<S> serviceType, String filter, String key) {
        String trackingFilter = this.createFilter(serviceType, filter);
        TrackerCustomizer<?> customizer = this.customizers.get(trackingFilter);
        customizer.detachOnRemoving(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> String attachOnServiceUpdating(Class<S> serviceType, String filter, List<Executable<S, Void>> executables) {
        String key = null;
        String trackingFilter = this.createFilter(serviceType, filter);
        TrackerCustomizer<Object> customizer = this.customizers.get(trackingFilter);
        if (customizer == null) {
            customizer = new TrackerCustomizer(this);
            this.customizers.put(trackingFilter, customizer);
            key = customizer.attachOnModifying(executables);
            ServiceTracker tracker = new ServiceTracker(this.context, trackingFilter, customizer);
            List<ServiceTracker<?, ?>> list = this.trackers;
            synchronized (list) {
                this.trackers.add(tracker);
            }
            tracker.open();
        } else {
            key = customizer.attachOnModifying(executables);
        }
        return key;
    }

    public <S> String attachOnServiceUpdating(Class<S> serviceType, String filter, Executable<S, Void> executable) {
        return this.attachOnServiceUpdating(serviceType, filter, Collections.singletonList(executable));
    }

    public <S> void detachOnServiceUpdating(Class<S> serviceType, String filter, String key) {
        String trackingFilter = this.createFilter(serviceType, filter);
        TrackerCustomizer<?> customizer = this.customizers.get(trackingFilter);
        customizer.detachOnModifying(key);
    }

    public String createFilter(Class<?> serviceType, String filter) {
        StringBuilder classBuilder = null;
        StringBuilder filterBuilder = null;
        if (serviceType != null) {
            classBuilder = new StringBuilder();
            classBuilder.append("(objectClass=");
            classBuilder.append(serviceType.getCanonicalName());
            classBuilder.append(")");
        }
        if (filter != null) {
            filterBuilder = new StringBuilder();
            if (classBuilder != null) {
                filterBuilder.append("(&");
                filterBuilder.append(classBuilder.toString());
            }
            if (!filter.startsWith("(")) {
                filterBuilder.append("(");
            }
            filterBuilder.append(filter);
            if (!filter.endsWith(")")) {
                filterBuilder.append(")");
            }
            if (classBuilder != null) {
                filterBuilder.append(")");
            }
        } else {
            filterBuilder = classBuilder;
        }
        if (filterBuilder != null) {
            return filterBuilder.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        int index;
        int length;
        List<ServiceTracker<?, ?>> list = this.trackers;
        synchronized (list) {
            int n = length = this.trackers == null ? 0 : this.trackers.size();
            for (index = 0; index < length; ++index) {
                this.trackers.remove(0).close();
            }
        }
        list = this.registrations;
        synchronized (list) {
            int n = length = this.registrations == null ? 0 : this.registrations.size();
            for (index = 0; index < length; ++index) {
                try {
                    this.registrations.remove(0).unregister();
                    continue;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
        this.customizers.clear();
        if (this.configuration != null) {
            this.configuration.unregister();
        }
    }

    public BundleContext getContext() {
        return this.context;
    }

    public ClassLoader getClassLoader() {
        ClassLoader classloader;
        block5: {
            classloader = null;
            try {
                classloader = ((BundleWiring)this.getContext().getBundle().adapt(BundleWiring.class)).getClassLoader();
            }
            catch (NullPointerException e) {
                Enumeration entries = this.getContext().getBundle().findEntries("/", "*.class", true);
                if (entries == null || !entries.hasMoreElements()) break block5;
                String classname = ((URL)entries.nextElement()).getPath();
                int startIndex = 0;
                int endIndex = classname.length() - ".class".length();
                classname = classname.substring(startIndex += classname.startsWith("/") ? 1 : 0, endIndex);
                classname = classname.replace('/', '.');
                try {
                    Class clazz = this.getContext().getBundle().loadClass(classname);
                    classloader = clazz.getClassLoader();
                }
                catch (ClassNotFoundException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        if (classloader == null) {
            classloader = Thread.currentThread().getContextClassLoader();
        }
        return classloader;
    }

    public Object getProperty(String property) {
        return PropertyUtils.getProperty((BundleContext)this.context, (Properties)this.properties, (String)property);
    }

    public void setProperty(String property, Object value) {
        if (property == null) {
            return;
        }
        this.properties.put(property, value);
    }

    public Map<?, ?> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }
}

