/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.bundle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

final class ServiceCaller {
    private BundleContext context;
    private AtomicInteger count;
    private Map<String, List<ServiceReference<?>>> references;

    public ServiceCaller(BundleContext context) {
        this.context = context;
        this.count = new AtomicInteger(0);
        this.references = new HashMap();
    }

    private <S> List<ServiceReference<?>> getServiceReferences(Class<S> clazz, String filter) throws InvalidSyntaxException {
        String completeFilter;
        List<Object> referenceList;
        String classname = clazz.getCanonicalName();
        StringBuilder builder = new StringBuilder();
        if (filter != null) {
            builder.append("(&");
        }
        builder.append("(");
        builder.append("objectClass=");
        builder.append(classname);
        builder.append(")");
        if (filter != null) {
            if (!filter.startsWith("(")) {
                builder.append("(");
            }
            builder.append(filter);
            if (!filter.endsWith(")")) {
                builder.append(")");
            }
            builder.append(")");
        }
        if ((referenceList = this.references.get(completeFilter = builder.toString())) == null || referenceList.isEmpty()) {
            Collection referenceCollection = this.context.getServiceReferences(clazz, filter);
            referenceList = referenceCollection == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList(referenceCollection));
            this.references.put(completeFilter, referenceList);
        }
        return referenceList;
    }

    public int attach() {
        return this.count.incrementAndGet();
    }

    public int release() {
        return this.count.decrementAndGet();
    }

    private void checkContext() throws IllegalStateException {
        switch (this.context.getBundle().getState()) {
            case 8: 
            case 16: 
            case 32: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public <S, R> R callService(Class<S> serviceType, Executable<S, R> executor) throws Exception {
        return this.callService(serviceType, null, executor);
    }

    public <S, R> R callService(Class<S> serviceType, String filter, Executable<S, R> executor) throws Exception {
        R result = null;
        Object service = null;
        try {
            this.checkContext();
        }
        catch (IllegalStateException e) {
            return result;
        }
        List<ServiceReference<?>> serviceReferences = this.getServiceReferences(serviceType, filter);
        if (serviceReferences != null && !serviceReferences.isEmpty()) {
            for (ServiceReference<?> serviceReference : serviceReferences) {
                service = this.context.getService(serviceReference);
                if (service == null) continue;
                try {
                    result = executor.execute(service);
                    break;
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    if (service != null) {
                        this.context.ungetService(serviceReference);
                    }
                    service = null;
                }
            }
        }
        return result;
    }

    public <S> void callServices(Class<S> serviceType, Executable<S, Void> executor) throws Exception {
        this.callServices(serviceType, null, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> void callServices(Class<S> serviceType, String filter, Executable<S, Void> executor) throws Exception {
        try {
            this.checkContext();
        }
        catch (IllegalStateException e) {
            return;
        }
        List<ServiceReference<?>> serviceReferences = this.getServiceReferences(serviceType, filter);
        if (serviceReferences != null && !serviceReferences.isEmpty()) {
            Iterator<ServiceReference<?>> iterator = serviceReferences.iterator();
            Object service = null;
            while (iterator.hasNext()) {
                ServiceReference<?> serviceReference = iterator.next();
                service = this.context.getService(serviceReference);
                if (service == null) continue;
                try {
                    executor.execute(service);
                }
                catch (Exception e) {}
                continue;
                finally {
                    if (service != null) {
                        this.context.ungetService(serviceReference);
                    }
                    service = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, R> Collection<R> callServices(Class<S> serviceType, Class<R> returnType, String filter, Executable<S, R> executor) throws Exception {
        try {
            this.checkContext();
        }
        catch (IllegalStateException e) {
            return Collections.emptyList();
        }
        ArrayList<R> collection = new ArrayList<R>();
        List<ServiceReference<?>> serviceReferences = this.getServiceReferences(serviceType, filter);
        if (serviceReferences != null && !serviceReferences.isEmpty()) {
            Iterator<ServiceReference<?>> iterator = serviceReferences.iterator();
            Object service = null;
            while (iterator.hasNext()) {
                ServiceReference<?> serviceReference = iterator.next();
                service = this.context.getService(serviceReference);
                if (service == null) continue;
                try {
                    R result = executor.execute(service);
                    collection.add(result);
                }
                catch (Exception e) {}
                continue;
                finally {
                    if (service != null) {
                        this.context.ungetService(serviceReference);
                    }
                    service = null;
                }
            }
        }
        return collection;
    }
}

