/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.constraint;

import java.util.logging.Level;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.constraint.ConstraintOnComparable;
import org.eclipse.sensinact.gateway.common.constraint.InvalidConstraintDefinitionException;

public class MaxInclusive<T>
extends ConstraintOnComparable<T> {
    public static final String OPERATOR = "<=";

    public MaxInclusive(Class<T> operandClass, Object operand, boolean complement) throws InvalidConstraintDefinitionException {
        super(OPERATOR, operandClass, operand, complement);
    }

    @Override
    public boolean doComplies(T castedValue) {
        return this.operand.compareTo(castedValue) >= 0 ^ this.isComplement();
    }

    @Override
    public Constraint getComplement() {
        MaxInclusive complement = null;
        try {
            complement = new MaxInclusive(this.operand.getClass(), this.operand, !this.complement);
        }
        catch (InvalidConstraintDefinitionException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return complement;
    }
}

