/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.constraint;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.constraint.InvalidConstraintDefinitionException;
import org.eclipse.sensinact.gateway.util.CastUtils;

public class Pattern
implements Constraint {
    protected static final Logger LOGGER = Logger.getLogger(Pattern.class.getCanonicalName());
    public static final String OPERATOR = "regex";
    protected final String operand;
    protected final boolean complement;

    public Pattern(String operand, boolean complement) throws InvalidConstraintDefinitionException {
        this.complement = complement;
        if (operand == null || operand.length() == 0) {
            throw new InvalidConstraintDefinitionException("Unable to create a regular expression using an empty or null string");
        }
        try {
            java.util.regex.Pattern.compile(operand);
        }
        catch (PatternSyntaxException e) {
            throw new InvalidConstraintDefinitionException(e);
        }
        this.operand = operand;
    }

    @Override
    public String getOperator() {
        return OPERATOR;
    }

    @Override
    public boolean isComplement() {
        return this.complement;
    }

    @Override
    public boolean complies(Object value) {
        boolean complies = false;
        if (value == null) {
            return complies;
        }
        String sequence = null;
        try {
            sequence = (String)CastUtils.cast(String.class, (Object)value);
        }
        catch (ClassCastException e) {
            return complies;
        }
        return sequence.matches(this.operand) ^ this.isComplement();
    }

    @Override
    public String getJSON() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        builder.append('\"');
        builder.append("operator");
        builder.append('\"');
        builder.append(':');
        builder.append('\"');
        builder.append(this.getOperator());
        builder.append('\"');
        builder.append(',');
        builder.append('\"');
        builder.append("complement");
        builder.append('\"');
        builder.append(':');
        builder.append(this.complement);
        builder.append(',');
        builder.append('\"');
        builder.append("operand");
        builder.append('\"');
        builder.append(':');
        builder.append('\"');
        builder.append(this.operand);
        builder.append('\"');
        builder.append('}');
        return builder.toString();
    }

    @Override
    public Constraint getComplement() {
        Pattern complement = null;
        try {
            complement = new Pattern(this.operand, !this.complement);
        }
        catch (InvalidConstraintDefinitionException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return complement;
    }
}

