/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.parser;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.generic.parser.XmlElement;
import org.eclipse.sensinact.gateway.generic.parser.XmlModelParsingContext;
import org.eclipse.sensinact.gateway.generic.parser.XmlResourceConfigHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

@XmlElement(tag="interfaceName", field="resourceInterfaceType")
final class ResourceInterfaceDefinition
extends XmlModelParsingContext {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceInterfaceDefinition.class);
    private Class<? extends Resource> resourceInterfaceType;

    public ResourceInterfaceDefinition(Mediator mediator, Attributes atts) {
        super(mediator, atts);
    }

    void setResourceInterfaceType(String interfaceName) {
        if (interfaceName == null || interfaceName.length() == 0) {
            return;
        }
        this.resourceInterfaceType = this.resolveInterfaceType(interfaceName);
        if (this.resourceInterfaceType != null) {
            return;
        }
        try {
            this.resourceInterfaceType = this.mediator.getContext().getBundle().loadClass(interfaceName);
            if (!this.resourceInterfaceType.isInterface()) {
                this.resourceInterfaceType = null;
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private Class<?> resolveInterfaceType(String interfaceName) {
        switch (interfaceName) {
            case "org.eclipse.sensinact.gateway.core.StateVariableResource": {
                return XmlResourceConfigHandler.DEFAULT_VARIABLE_INTERFACE;
            }
            case "org.eclipse.sensinact.gateway.core.SensorDataResource": {
                return XmlResourceConfigHandler.DEFAULT_SENSOR_INTERFACE;
            }
            case "org.eclipse.sensinact.gateway.core.PropertyResource": {
                return XmlResourceConfigHandler.DEFAULT_PROPERTY_INTERFACE;
            }
            case "org.eclipse.sensinact.gateway.core.ActionResource": {
                return XmlResourceConfigHandler.DEFAULT_ACTION_INTERFACE;
            }
        }
        return null;
    }

    public Class<? extends Resource> getResourceInterfaceType() {
        return this.resourceInterfaceType;
    }
}

