/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.parser;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.parser.XmlAttribute;
import org.eclipse.sensinact.gateway.generic.parser.XmlAttributes;
import org.eclipse.sensinact.gateway.generic.parser.XmlElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public abstract class XmlDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(XmlDefinition.class);
    protected Mediator mediator;
    protected Method tagged;

    public XmlDefinition(Mediator mediator, Attributes atts) {
        this.mediator = mediator;
        XmlElement element = this.getClass().getAnnotation(XmlElement.class);
        if (element != null) {
            String name = element.tag();
            String field = element.field();
            if (!name.equals("#DEFAULT_ELEMENT#") && !field.equals("#DEFAULT_ELEMENT#")) {
                char[] fieldChars = field.toCharArray();
                fieldChars[0] = Character.toUpperCase(fieldChars[0]);
                String methodName = "set" + new String(fieldChars);
                this.tagged = this.getMethod(methodName);
            }
        }
        if (atts != null) {
            for (XmlAttribute annotation : this.buildAttributeAnnotationsSet()) {
                String name = annotation.attribute();
                String field = annotation.field();
                String value = null;
                if (name.equals("#DEFAULT_ATTRIBUTE#") || field.equals("#DEFAULT_ATTRIBUTE#") || (value = atts.getValue(name)) == null || value.length() == 0) continue;
                char[] fieldChars = field.toCharArray();
                fieldChars[0] = Character.toUpperCase(fieldChars[0]);
                String methodName = "set" + new String(fieldChars);
                Method method = this.getMethod(methodName);
                if (method == null) continue;
                this.invoke(method, value);
            }
        }
    }

    public void mapTag(String value) {
        this.invoke(this.tagged, value);
    }

    private void invoke(Method method, String value) {
        if (method != null) {
            method.setAccessible(true);
            try {
                method.invoke((Object)this, value);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private XmlAttribute[] buildAttributeAnnotationsSet() {
        ArrayList<XmlAttribute> tags = new ArrayList<XmlAttribute>();
        for (Class<?> currentClass = this.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            XmlAttributes attributes = currentClass.getAnnotation(XmlAttributes.class);
            if (attributes == null) continue;
            for (XmlAttribute attribute : attributes.value()) {
                tags.add(attribute);
            }
        }
        return tags.toArray(new XmlAttribute[tags.size()]);
    }

    private Method getMethod(String methodName) {
        Class<?> currentClass = this.getClass();
        Method method = null;
        while (XmlDefinition.class.isAssignableFrom(currentClass)) {
            try {
                method = currentClass.getDeclaredMethod(methodName, String.class);
                break;
            }
            catch (Exception e) {
                currentClass = currentClass.getSuperclass();
            }
        }
        return method;
    }
}

