/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.parser;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.parser.XmlAttribute;
import org.eclipse.sensinact.gateway.generic.parser.XmlAttributes;
import org.eclipse.sensinact.gateway.generic.parser.XmlDefinition;
import org.xml.sax.Attributes;

@XmlAttributes(value={@XmlAttribute(attribute="identifier", field="serviceProviderIdentifier"), @XmlAttribute(attribute="profile", field="serviceProviderProfile")})
public final class DeviceDefinition
extends XmlDefinition {
    protected LinkedList<String> services = new LinkedList();
    protected Map<String, String> metadata = new HashMap<String, String>();
    protected String serviceProviderIdentifier;
    private String serviceProviderProfile;

    public DeviceDefinition(Mediator mediator, Attributes atts) {
        super(mediator, atts);
        int length = atts == null ? 0 : atts.getLength();
        for (int index = 0; index < length; ++index) {
            String key = atts.getQName(index);
            String value = atts.getValue(key);
            this.metadata.put(key, value);
        }
    }

    public void setServiceProviderIdentifier(String serviceProviderIdentifier) {
        this.serviceProviderIdentifier = serviceProviderIdentifier;
    }

    public String getServiceProviderIdentifier() {
        return this.serviceProviderIdentifier;
    }

    public void setServiceProviderProfile(String serviceProviderProfile) {
        this.serviceProviderProfile = serviceProviderProfile;
    }

    public String getServiceProviderProfile() {
        return this.serviceProviderProfile;
    }

    public void addService(String service) {
        if (service != null) {
            this.services.add(service);
        }
    }

    public String[] getServices() {
        return this.services.toArray(new String[this.services.size()]);
    }

    public Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }
}

