/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.parser;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.parser.XmlAttribute;
import org.eclipse.sensinact.gateway.generic.parser.XmlAttributes;
import org.eclipse.sensinact.gateway.generic.parser.XmlElement;
import org.eclipse.sensinact.gateway.generic.parser.XmlModelParsingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

@XmlElement(tag="identifier", field="identifier")
@XmlAttributes(value={@XmlAttribute(attribute="xsi:type", field="encoding")})
final class IdentifierDefinition
extends XmlModelParsingContext {
    private static final Logger LOG = LoggerFactory.getLogger(IdentifierDefinition.class);
    private String encoding;
    private byte[] identifier;

    public IdentifierDefinition(Mediator mediator, Attributes atts) {
        super(mediator, atts);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setIdentifier(String identifier) {
        char[] identifierChars = identifier.toCharArray();
        if ("stringContent".equals(this.encoding)) {
            this.identifier = new byte[identifierChars.length];
            for (int i = 0; i < identifierChars.length; ++i) {
                this.identifier[i] = (byte)Character.codePointAt(identifierChars, i);
            }
        } else if ("binaryHexContent".equals(this.encoding)) {
            this.identifier = new byte[identifierChars.length / 2];
            int pos = 0;
            for (int i = 0; i < identifierChars.length; i += 2) {
                this.identifier[pos++] = Byte.parseByte(new String(new char[]{identifierChars[i], identifierChars[i + 1]}), 16);
            }
        } else if (LOG.isWarnEnabled()) {
            LOG.warn("Invalid command encoding");
        }
    }

    protected byte[] getIdentifier() {
        if (this.identifier == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("No IdentifierDefinition defined");
            }
            return null;
        }
        byte[] newIdentifierBytesArray = new byte[this.identifier.length];
        for (int n = 0; n < this.identifier.length; ++n) {
            newIdentifierBytesArray[n] = this.identifier[n];
        }
        return newIdentifierBytesArray;
    }
}

