/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.parser.BuilderDefinition;
import org.eclipse.sensinact.gateway.generic.parser.ConditionalConstant;
import org.eclipse.sensinact.gateway.generic.parser.ConstrainableDefinition;
import org.eclipse.sensinact.gateway.generic.parser.ConstraintDefinition;
import org.eclipse.sensinact.gateway.generic.parser.XmlAttributes;
import org.xml.sax.Attributes;

@XmlAttributes(value={})
public class ParameterBuilderDefinition
extends BuilderDefinition
implements ConstrainableDefinition {
    private List<ConditionalConstant> conditionalConstants;
    private String parameterName;

    ParameterBuilderDefinition(Mediator mediator, String parameterName, Attributes atts) {
        super(mediator, atts);
        this.parameterName = parameterName;
        this.conditionalConstants = new ArrayList<ConditionalConstant>();
    }

    @Override
    public String getName() {
        String name = super.getName().toUpperCase();
        if ("CALCULATED".equals(name = name.substring(0, name.length() - 7))) {
            return super.getSubType();
        }
        return name;
    }

    @Override
    public void addConstraint(ConstraintDefinition constraint) {
        ConditionalConstant conditionalConstant = this.conditionalConstants.get(this.conditionalConstants.size() - 1);
        conditionalConstant.addConstraint(constraint);
    }

    public String getJSON() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        builder.append('\"');
        builder.append("reference");
        builder.append('\"');
        builder.append(':');
        builder.append('\"');
        builder.append(super.getReference());
        builder.append('\"');
        builder.append(',');
        builder.append('\"');
        builder.append("builder");
        builder.append('\"');
        builder.append(':');
        builder.append('{');
        builder.append('\"');
        builder.append("type");
        builder.append('\"');
        builder.append(':');
        builder.append('\"');
        builder.append(this.getName());
        builder.append('\"');
        builder.append(',');
        builder.append('\"');
        builder.append("parameter");
        builder.append('\"');
        builder.append(':');
        builder.append('\"');
        builder.append(this.parameterName);
        builder.append('\"');
        if (!this.conditionalConstants.isEmpty()) {
            builder.append(',');
            if (this.conditionalConstants.size() == 1 && this.conditionalConstants.get(0).isUnconditional()) {
                builder.append('\"');
                builder.append("constant");
                builder.append('\"');
                builder.append(':');
                builder.append(this.conditionalConstants.get(0).getJSON());
            } else {
                builder.append('\"');
                builder.append("constants");
                builder.append('\"');
                builder.append(':');
                builder.append('[');
                int length = this.conditionalConstants.size();
                for (int index = 0; index < length; ++index) {
                    builder.append(index > 0 ? Character.valueOf(',') : "");
                    builder.append(this.conditionalConstants.get(index).getJSON());
                }
                builder.append(']');
            }
        }
        builder.append('}');
        builder.append('}');
        return builder.toString();
    }

    public void constantStart(Attributes atts) {
        ConditionalConstant constant = new ConditionalConstant(this.mediator, atts);
        this.conditionalConstants.add(constant);
        super.setNext(constant);
    }
}

