/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.parser;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.ActionResource;
import org.eclipse.sensinact.gateway.core.PropertyResource;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.SensorDataResource;
import org.eclipse.sensinact.gateway.core.StateVariableResource;
import org.eclipse.sensinact.gateway.core.TypeConfig;
import org.eclipse.sensinact.gateway.generic.ExtResourceConfig;
import org.eclipse.sensinact.gateway.generic.ExtResourceImpl;
import org.eclipse.sensinact.gateway.generic.parser.CommandDefinition;
import org.eclipse.sensinact.gateway.generic.parser.Commands;
import org.eclipse.sensinact.gateway.generic.parser.DeviceDefinition;
import org.eclipse.sensinact.gateway.generic.parser.FixedProviders;
import org.eclipse.sensinact.gateway.generic.parser.PolicyDefinition;
import org.eclipse.sensinact.gateway.generic.parser.ResourceClassDefinition;
import org.eclipse.sensinact.gateway.generic.parser.ResourceInfoDefinition;
import org.eclipse.sensinact.gateway.generic.parser.ResourceInterfaceDefinition;
import org.eclipse.sensinact.gateway.generic.parser.RootXmlParsingContext;
import org.eclipse.sensinact.gateway.generic.parser.XmlModelParsingContext;
import org.eclipse.sensinact.gateway.util.xml.AbstractContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XmlResourceConfigHandler
extends AbstractContentHandler<ResourceInfoDefinition>
implements RootXmlParsingContext {
    private static final Logger LOG = LoggerFactory.getLogger(XmlResourceConfigHandler.class);
    static final String LOCATION_KEY_WORD = "LOCATION";
    static final String BINARY_COMMAND_TYPE = "binaryHexContent";
    static final String STRING_COMMAND_TYPE = "stringContent";
    private static final String DEFAULT_POLICY_IMPLEMENTATION = ExtResourceImpl.class.getCanonicalName();
    public static final Class<StateVariableResource> DEFAULT_VARIABLE_INTERFACE = StateVariableResource.class;
    public static final Class<PropertyResource> DEFAULT_PROPERTY_INTERFACE = PropertyResource.class;
    public static final Class<SensorDataResource> DEFAULT_SENSOR_INTERFACE = SensorDataResource.class;
    public static final Class<ActionResource> DEFAULT_ACTION_INTERFACE = ActionResource.class;
    public static final String DEFAULT_VARIABLE_POLICY_INTERFACE = DEFAULT_VARIABLE_INTERFACE.getCanonicalName().intern();
    public static final String DEFAULT_PROPERTY_POLICY_INTERFACE = DEFAULT_PROPERTY_INTERFACE.getCanonicalName().intern();
    public static final String DEFAULT_SENSOR_POLICY_INTERFACE = DEFAULT_SENSOR_INTERFACE.getCanonicalName().intern();
    public static final String DEFAULT_ACTION_POLICY_INTERFACE = DEFAULT_ACTION_INTERFACE.getCanonicalName().intern();
    private Map<String, List<String>> profiles;
    private LinkedList<PolicyDefinition> policies;
    private Stack<CommandDefinition> commands;
    private Stack<DeviceDefinition> devices;
    private List<ExtResourceConfig> configs;
    private Mediator mediator;
    private boolean handleNoProfile;
    XmlModelParsingContext parsingContext;

    public XmlResourceConfigHandler(Mediator mediator) {
        this.mediator = mediator;
        this.commands = new Stack();
        this.devices = new Stack();
        this.policies = new LinkedList();
        this.profiles = new HashMap<String, List<String>>();
        ResourceClassDefinition resourceClassDefinition = new ResourceClassDefinition(mediator, null);
        resourceClassDefinition.end();
        resourceClassDefinition.setResourceClassType(DEFAULT_POLICY_IMPLEMENTATION);
        ResourceInterfaceDefinition resourceInterfaceDefinition = new ResourceInterfaceDefinition(mediator, null);
        resourceInterfaceDefinition.setResourceInterfaceType(DEFAULT_VARIABLE_POLICY_INTERFACE);
        PolicyDefinition policyDefinition = new PolicyDefinition(this.mediator, null);
        policyDefinition.setPolicy(TypeConfig.Type.STATE_VARIABLE.name());
        policyDefinition.setResourceClassDefinition(resourceClassDefinition);
        policyDefinition.setResourceInterfaceDefinition(resourceInterfaceDefinition);
        policyDefinition.setUpdatePolicy(Resource.UpdatePolicy.NONE.name());
        policyDefinition.end();
        this.policies.add(policyDefinition);
        resourceInterfaceDefinition = new ResourceInterfaceDefinition(mediator, null);
        resourceInterfaceDefinition.setResourceInterfaceType(DEFAULT_PROPERTY_POLICY_INTERFACE);
        resourceInterfaceDefinition.end();
        policyDefinition = new PolicyDefinition(this.mediator, null);
        policyDefinition.setPolicy(TypeConfig.Type.PROPERTY.name());
        policyDefinition.setResourceClassDefinition(resourceClassDefinition);
        policyDefinition.setResourceInterfaceDefinition(resourceInterfaceDefinition);
        policyDefinition.setUpdatePolicy(Resource.UpdatePolicy.NONE.name());
        policyDefinition.end();
        this.policies.add(policyDefinition);
        resourceInterfaceDefinition = new ResourceInterfaceDefinition(mediator, null);
        resourceInterfaceDefinition.setResourceInterfaceType(DEFAULT_SENSOR_POLICY_INTERFACE);
        policyDefinition = new PolicyDefinition(this.mediator, null);
        policyDefinition.setPolicy(TypeConfig.Type.SENSOR.name());
        policyDefinition.setResourceClassDefinition(resourceClassDefinition);
        policyDefinition.setResourceInterfaceDefinition(resourceInterfaceDefinition);
        policyDefinition.setUpdatePolicy(Resource.UpdatePolicy.NONE.name());
        policyDefinition.end();
        this.policies.add(policyDefinition);
        resourceInterfaceDefinition = new ResourceInterfaceDefinition(mediator, null);
        resourceInterfaceDefinition.setResourceInterfaceType(DEFAULT_ACTION_POLICY_INTERFACE);
        policyDefinition = new PolicyDefinition(this.mediator, null);
        policyDefinition.setPolicy(TypeConfig.Type.ACTION.name());
        policyDefinition.setResourceClassDefinition(resourceClassDefinition);
        policyDefinition.setResourceInterfaceDefinition(resourceInterfaceDefinition);
        policyDefinition.setUpdatePolicy(Resource.UpdatePolicy.NONE.name());
        policyDefinition.end();
        this.policies.add(policyDefinition);
    }

    public void policyStart(Attributes atts) {
        this.parsingContext = new PolicyDefinition(this.mediator, atts);
    }

    public void policyEnd() {
        Class<? extends Resource> implementationInterface;
        PolicyDefinition policyDefinition = (PolicyDefinition)this.parsingContext;
        this.parsingContext = null;
        policyDefinition.mapTag(this.textContent.toString());
        PolicyDefinition registered = this.removePolicy(policyDefinition.getPolicy().name());
        Class<? extends ExtResourceImpl> implementationClass = policyDefinition.getPolicyImplementationClass();
        if (implementationClass == null) {
            policyDefinition.setPolicyImplementationClass(registered.getPolicyImplementationClass().getCanonicalName());
        }
        if ((implementationInterface = policyDefinition.getPolicyImplementationInterface()) == null) {
            policyDefinition.setPolicyImplementationInterface(registered.getPolicyImplementationInterface().getCanonicalName());
        }
        this.policies.add(policyDefinition);
    }

    public void commandStart(Attributes atts) {
        CommandDefinition commandDefinition = new CommandDefinition(this.mediator, atts);
        this.commands.push(commandDefinition);
        this.parsingContext = commandDefinition;
    }

    public void resourceInfosStart(Attributes atts) throws SAXException {
        this.handleNoProfile = Boolean.parseBoolean(atts.getValue("empty_profile"));
    }

    public void resourceInfosEnd() {
        this.configs = new ArrayList<ExtResourceConfig>();
        for (ResourceInfoDefinition definition : this.stack) {
            this.configs.add((ExtResourceConfig)definition.asResourceConfig());
        }
    }

    public ResourceInfoDefinition resourceInfoStart(Attributes atts) throws SAXException {
        ResourceInfoDefinition definition = new ResourceInfoDefinition(this.mediator, this, atts);
        this.parsingContext = definition;
        return definition;
    }

    public void serviceStart(Attributes atts) {
        String serviceName = atts.getValue("name");
        if (serviceName != null) {
            this.devices.peek().addService(serviceName);
        }
    }

    public void deviceStart(Attributes atts) {
        DeviceDefinition deviceDefinition = new DeviceDefinition(this.mediator, atts);
        this.devices.push(deviceDefinition);
    }

    public ResourceInfoDefinition end(String tag, String qname) {
        ResourceInfoDefinition def = null;
        Method endMethod = null;
        Class<?> clazz = null;
        Object subject = null;
        XmlModelParsingContext parent = null;
        XmlModelParsingContext context = this.getContext();
        if (context != null) {
            for (String escape : context.escaped()) {
                if (!tag.equals(escape)) continue;
                return def;
            }
            context.end();
            parent = this.getParentContext();
            if (parent != null) {
                clazz = parent.getClass();
                subject = parent;
            }
        }
        if (subject == null) {
            clazz = this.getClass();
            subject = this;
        }
        try {
            endMethod = clazz.getDeclaredMethod(qname.concat("End"), new Class[0]);
            def = (ResourceInfoDefinition)endMethod.invoke(subject, new Object[0]);
        }
        catch (Exception e) {
            LOG.debug(e.getMessage());
        }
        if (parent != null) {
            parent.setNext(null);
        } else {
            this.parsingContext = null;
        }
        return def;
    }

    public ResourceInfoDefinition start(String tag, String qname, Attributes atts) throws SAXException {
        ResourceInfoDefinition def = null;
        Method startMethod = null;
        Class<?> clazz = null;
        Object subject = null;
        XmlModelParsingContext context = this.getContext();
        if (context != null) {
            for (String escape : context.escaped()) {
                if (!tag.equals(escape)) continue;
                return def;
            }
            clazz = context.getClass();
            subject = context;
        } else {
            clazz = this.getClass();
            subject = this;
        }
        try {
            startMethod = clazz.getMethod(qname.concat("Start"), Attributes.class);
            def = (ResourceInfoDefinition)startMethod.invoke(subject, atts);
        }
        catch (Exception e) {
            LOG.debug(e.getMessage());
        }
        return def;
    }

    public void characters(char[] chrs, int start, int length) throws SAXException {
        XmlModelParsingContext context = this.getContext();
        if (context != null) {
            context.characters(chrs, start, length);
        }
    }

    public void ignorableWhitespace(char[] chrs, int start, int length) throws SAXException {
        XmlModelParsingContext context = this.getContext();
        if (context != null) {
            context.ignorableWhitespace(chrs, start, length);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        XmlModelParsingContext context = this.getContext();
        if (context != null) {
            context.processingInstruction(target, data);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        XmlModelParsingContext context = this.getContext();
        if (context != null) {
            context.skippedEntity(name);
        }
    }

    @Override
    public PolicyDefinition getPolicy(String policyName) {
        if (policyName != null) {
            for (PolicyDefinition policyDefinition : this.policies) {
                if (!policyName.equals(policyDefinition.getPolicy().name())) continue;
                return policyDefinition;
            }
        }
        return null;
    }

    private PolicyDefinition removePolicy(String policyName) {
        if (policyName != null) {
            for (int index = 0; index < this.policies.size(); ++index) {
                PolicyDefinition policyDefinition = this.policies.get(index);
                if (!policyName.equals(policyDefinition.getPolicy().name())) continue;
                return this.policies.remove(index);
            }
        }
        return null;
    }

    XmlModelParsingContext getContext() {
        if (this.parsingContext == null) {
            return null;
        }
        XmlModelParsingContext context = this.parsingContext;
        while (context.next() != null) {
            context = context.next();
        }
        return context;
    }

    XmlModelParsingContext getParentContext() {
        if (this.parsingContext == null || this.parsingContext.next() == null) {
            return null;
        }
        XmlModelParsingContext parent = null;
        XmlModelParsingContext context = this.parsingContext;
        while (context.next() != null) {
            parent = context;
            context = context.next();
        }
        return parent;
    }

    @Override
    public void registerProfile(String[] profiles, String[] targets) {
        if (profiles == null || profiles.length == 0) {
            return;
        }
        for (String profile : profiles) {
            if (!"ANY_PROFILE".equals(profile) && (!"#ANY_PROFILE#".equals(profile) || this.handleNoProfile)) continue;
            return;
        }
        for (String profile : profiles) {
            int targetLength;
            List<String> services = this.profiles.get(profile);
            if (services == null) {
                services = new ArrayList<String>();
                this.profiles.put(profile, services);
            }
            int n = targetLength = targets == null ? 0 : targets.length;
            for (int targetIndex = 0; targetIndex < targetLength; ++targetIndex) {
                if ("admin".equals(targets[targetIndex]) || services.contains(targets[targetIndex])) continue;
                services.add(targets[targetIndex]);
            }
        }
    }

    public Map<String, List<String>> getProfiles() {
        return Collections.unmodifiableMap(this.profiles);
    }

    public Commands getCommandDefinitions() {
        return new Commands(this.commands);
    }

    public FixedProviders getDeviceDefinitions() {
        return new FixedProviders(this.devices);
    }

    public Iterator<ExtResourceConfig> getXmlResourceConfigs() {
        return this.configs.iterator();
    }
}

