/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.AttributeBuilder;
import org.eclipse.sensinact.gateway.core.RequirementBuilder;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.generic.parser.AttributeDefinition;
import org.eclipse.sensinact.gateway.generic.parser.MethodDefinition;
import org.eclipse.sensinact.gateway.generic.parser.XmlResourceConfigHandler;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.eclipse.sensinact.gateway.util.xml.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ExtResourceConfig
extends ResourceConfig
implements Iterable<MethodDefinition> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtResourceConfig.class);
    protected byte[] identifier;
    protected byte subscriptionMode;
    protected List<AttributeDefinition> attributeDefinitions;
    protected List<MethodDefinition> methodDefinitions;

    public static XmlResourceConfigHandler loadFromXml(Mediator mediator, URL xml) throws ParserConfigurationException, SAXException, IOException {
        if (xml != null) {
            InputStream inputStream = xml.openStream();
            return ExtResourceConfig.loadFromXml(mediator, inputStream);
        }
        return null;
    }

    public static XmlResourceConfigHandler loadFromXml(Mediator mediator, InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        URL schema = ExtResourceConfig.class.getClassLoader().getResource("sensinact-resource.xsd");
        XmlResourceConfigHandler handler = new XmlResourceConfigHandler(mediator);
        try {
            XMLUtil.parse((ContentHandler)((Object)handler), (URL)schema, (InputSource)new InputSource(inputStream));
            return handler;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public ExtResourceConfig() {
        this(new ArrayList<AttributeDefinition>(), new ArrayList<MethodDefinition>());
    }

    public ExtResourceConfig(List<AttributeDefinition> attributeDefinitions, List<MethodDefinition> methodDefinitions) {
        this.attributeDefinitions = attributeDefinitions;
        this.methodDefinitions = methodDefinitions;
    }

    public void setIdentifier(byte[] identifier) {
        this.identifier = identifier;
    }

    public byte[] getIdentifier() {
        return this.identifier;
    }

    public void setSubscriptionMode(byte subscriptionMode) {
        this.subscriptionMode = subscriptionMode;
    }

    public int getSubscriptionMode() {
        return this.subscriptionMode;
    }

    public List<AttributeBuilder> getAttributeBuilders(String service) {
        ArrayList<AttributeBuilder> builders = new ArrayList<AttributeBuilder>();
        builders.addAll(super.getAttributeBuilders(service));
        for (AttributeDefinition attributeDefinition : this.attributeDefinitions) {
            if (!attributeDefinition.isTargeted(service)) continue;
            String name = attributeDefinition.getName();
            Optional<AttributeBuilder> found = builders.stream().filter(b -> name.equals(b.getName())).findFirst();
            if (found.isPresent()) {
                AttributeBuilder builder = found.get();
                List<RequirementBuilder> requirementBuilders = attributeDefinition.getRequirementBuilders(service);
                int length = requirementBuilders.size();
                for (int index = 0; index < length; ++index) {
                    requirementBuilders.get(index).apply(service, builder);
                }
                builder.addConstraints(attributeDefinition.getConstraints(service));
                builder.addMetadataBuilders(attributeDefinition.getMetadataBuilders());
                continue;
            }
            AttributeBuilder attributeBuilder = attributeDefinition.getAttributeBuilder(service);
            if (attributeBuilder == null) continue;
            builders.add(attributeBuilder);
        }
        return builders;
    }

    public List<String> getObserveds(String service) {
        ArrayList<String> observeds = new ArrayList<String>();
        observeds.addAll(super.getObserveds(service));
        for (AttributeDefinition attributeDefinition : this.attributeDefinitions) {
            if (!attributeDefinition.isObserved(service)) continue;
            observeds.add(UriUtils.getUri((String[])new String[]{service, this.getName(service), attributeDefinition.getName()}));
        }
        return observeds;
    }

    @Override
    public Iterator<MethodDefinition> iterator() {
        return Collections.unmodifiableList(this.methodDefinitions).iterator();
    }
}

