/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.packet;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.packet.InvalidPacketException;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.generic.packet.PacketReader;
import org.eclipse.sensinact.gateway.generic.packet.PacketReaderFactory;
import org.eclipse.sensinact.gateway.generic.packet.StructuredPacketReader;
import org.eclipse.sensinact.gateway.util.ReflectUtils;
import org.osgi.framework.Bundle;

public class DefaultPacketReaderFactory
implements PacketReaderFactory {
    private List<Class<? extends PacketReader>> packetReaders;
    private Class<? extends Packet> packetType;

    public <P extends Packet> DefaultPacketReaderFactory(Mediator mediator, ExtModelConfiguration ExtModelConfiguration2) {
        this.packetType = ExtModelConfiguration2.getPacketType();
        this.packetReaders = new ArrayList<Class<? extends PacketReader>>();
        List allTypes = ReflectUtils.getAllTypes((Bundle)mediator.getContext().getBundle());
        List packetReaderTypes = ReflectUtils.getAssignableTypes(PacketReader.class, (List)allTypes);
        if (!packetReaderTypes.isEmpty()) {
            int length;
            int n = length = packetReaderTypes == null ? 0 : packetReaderTypes.size();
            for (int index = 0; index < length; ++index) {
                Class packetReaderType = (Class)packetReaderTypes.get(index);
                this.packetReaders.add(packetReaderType);
            }
        }
        if (this.packetReaders.isEmpty()) {
            this.packetReaders.add(StructuredPacketReader.class);
        }
    }

    @Override
    public boolean handle(Class<? extends Packet> packetType) {
        return this.packetType.isAssignableFrom(packetType);
    }

    @Override
    public <P extends Packet> PacketReader<P> newInstance(ExtModelConfiguration manager, P packet) throws InvalidPacketException {
        int length = this.packetReaders == null ? 0 : this.packetReaders.size();
        PacketReader<Object> packetReader = null;
        for (int index = 0; index < length; ++index) {
            try {
                Class<? extends PacketReader> packetReaderType = this.packetReaders.get(index);
                packetReader = StructuredPacketReader.class.isAssignableFrom(packetReaderType) ? new StructuredPacketReader(packet.getClass()) : (PacketReader)ReflectUtils.getTheBestInstance(packetReaderType, (Object[])new Object[]{manager});
                packetReader.load(packet);
                break;
            }
            catch (Exception e) {
                continue;
            }
        }
        return packetReader;
    }
}

