/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.InvalidServiceProviderException;
import org.eclipse.sensinact.gateway.core.ServiceProvider;
import org.eclipse.sensinact.gateway.generic.ConnectorCustomizer;
import org.eclipse.sensinact.gateway.generic.DefaultConnectorCustomizer;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ExtModelInstance;
import org.eclipse.sensinact.gateway.generic.ExtModelInstanceBuilder;
import org.eclipse.sensinact.gateway.generic.ExtServiceProviderImpl;
import org.eclipse.sensinact.gateway.generic.ProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.generic.TaskManager;
import org.eclipse.sensinact.gateway.generic.packet.InvalidPacketException;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.generic.packet.PacketReader;
import org.eclipse.sensinact.gateway.generic.packet.PayloadFragment;
import org.eclipse.sensinact.gateway.generic.packet.TaskIdValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connector<P extends Packet>
extends TaskManager {
    private static final Logger LOG = LoggerFactory.getLogger(Connector.class);
    protected final Map<String, ExtModelInstance<?>> instances;
    protected final ExtModelConfiguration extModelConfiguration;
    protected final ExtModelInstanceBuilder extModelInstanceBuilder;
    protected ConnectorCustomizer<P> customizer;
    protected boolean locked;
    private Mediator mediator;

    public Connector(Mediator mediator, ProtocolStackEndpoint<?> endpoint, ExtModelConfiguration<P> extModelConfiguration, ConnectorCustomizer<P> customizer) {
        super(endpoint, extModelConfiguration.isLockedAtInitializationTime(), extModelConfiguration.isDesynchronized());
        this.mediator = mediator;
        this.extModelConfiguration = extModelConfiguration;
        this.extModelInstanceBuilder = new ExtModelInstanceBuilder(mediator);
        this.extModelInstanceBuilder.withConnector(this);
        this.locked = extModelConfiguration.isLockedAtInitializationTime();
        this.instances = new ConcurrentHashMap();
        this.customizer = customizer;
        this.configureCustomizer();
    }

    public Connector(Mediator mediator, ProtocolStackEndpoint<?> endpoint, ExtModelConfiguration extModelConfiguration) {
        this(mediator, endpoint, extModelConfiguration, null);
    }

    protected void configureCustomizer() {
        try {
            if (this.customizer == null) {
                this.customizer = new DefaultConnectorCustomizer(this.mediator, this.extModelConfiguration);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void process(P packet) throws InvalidPacketException {
        if (!this.customizer.preProcessing(packet)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Do not process the received packet : exiting");
            }
            return;
        }
        PacketReader<P> reader = this.customizer.newPacketReader(packet);
        if (reader == null) {
            throw new InvalidPacketException("Unable to create an appropriate reader");
        }
        Iterator subPacketIterator = reader.iterator();
        while (subPacketIterator.hasNext()) {
            String serviceProviderName;
            Iterator<TaskIdValuePair> iterator;
            PayloadFragment subPacket = (PayloadFragment)subPacketIterator.next();
            List<TaskIdValuePair> taskIdValuePairs = subPacket.getTaskIdValuePairs();
            Iterator<TaskIdValuePair> iterator2 = iterator = taskIdValuePairs == null || taskIdValuePairs.isEmpty() ? null : taskIdValuePairs.iterator();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    TaskIdValuePair taskIdValuePair = iterator.next();
                    String taskIdentifier = taskIdValuePair.taskIdentifier;
                    List<Task> tasks = super.remove(taskIdentifier);
                    Iterator<Task> taskIterator = tasks.iterator();
                    boolean treated = false;
                    while (taskIterator.hasNext()) {
                        Task task = taskIterator.next();
                        if (task == null || task.isResultAvailable()) continue;
                        task.setResult(taskIdValuePair.getValue(), taskIdValuePair.getTimestamp());
                        treated = true;
                    }
                    if (!treated) continue;
                    subPacket.treated(taskIdentifier);
                }
            }
            if ((serviceProviderName = subPacket.getServiceProviderIdentifier()) == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Unable to identify the targeted service provider");
                continue;
            }
            ExtModelInstance<?> instance = this.instances.get(serviceProviderName);
            ExtServiceProviderImpl serviceProvider = null;
            if (subPacket.isGoodByeMessage()) {
                this.processGoodbye(instance);
                if (instance == null) continue;
                this.instances.remove(serviceProviderName, instance);
                continue;
            }
            if (instance == null) {
                try {
                    instance = this.addModelInstance(subPacket.getProfileId(), serviceProviderName);
                    if (instance == null) continue;
                    LOG.debug("Service provider discovered : {}", (Object)serviceProviderName);
                }
                catch (InvalidServiceProviderException e) {
                    throw new InvalidPacketException(e);
                }
            }
            serviceProvider = instance.getRootElement();
            if (subPacket.isHelloMessage()) {
                this.processHello(serviceProvider);
            }
            serviceProvider.process(subPacket);
            this.customizer.postProcessing(serviceProvider, reader);
        }
    }

    protected void processHello(ExtServiceProviderImpl serviceProvider) {
        if (ServiceProvider.LifecycleStatus.INACTIVE.equals((Object)serviceProvider.getStatus())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Service provider {} activated", (Object)serviceProvider.getName());
            }
            serviceProvider.start();
        }
    }

    protected void processGoodbye(ExtModelInstance<?> instance) {
        if (instance == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("An unknown model instance is leaving the network");
            }
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Service provider '" + instance.getName() + "' is leaving the network");
        }
        instance.unregister();
    }

    protected synchronized ExtModelInstance<?> addModelInstance(String profileId, String serviceProviderName) throws InvalidServiceProviderException {
        Object instance = this.extModelInstanceBuilder.build(serviceProviderName, profileId, this.extModelConfiguration);
        if (instance != null) {
            this.instances.put(serviceProviderName, (ExtModelInstance<?>)((Object)instance));
        }
        return instance;
    }

    public ExtModelInstance<?> getModelInstance(String instanceName) {
        return this.instances.get(instanceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        if (this.instances == null || this.instances.size() == 0) {
            return;
        }
        Map<String, ExtModelInstance<?>> map = this.instances;
        synchronized (map) {
            this.instances.values().forEach(e -> {
                try {
                    e.unregister();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            });
            this.instances.clear();
        }
    }
}

